/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import java.util.Objects;
import java.util.Optional;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractListCandidateSequence;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;

public abstract class SMGAbstractListCandidateSequenceBlock<S>
implements SMGAbstractionBlock {
    private final S shape;
    private final int length;
    private final SMGMemoryPath pointerToStartObject;

    protected SMGAbstractListCandidateSequenceBlock(S pShape, int pLength, SMGMemoryPath pPointerToStartObject) {
        this.shape = pShape;
        this.length = pLength;
        this.pointerToStartObject = pPointerToStartObject;
    }

    @Override
    public boolean isBlocked(SMGAbstractionCandidate pCandidate, UnmodifiableCLangSMG smg) {
        if (!(pCandidate instanceof SMGAbstractListCandidateSequence)) {
            return false;
        }
        SMGAbstractListCandidateSequence lcs = (SMGAbstractListCandidateSequence)pCandidate;
        if (!this.shape.equals(((SMGListCandidate)lcs.getCandidate()).getShape())) {
            return false;
        }
        if (this.length != lcs.getLength()) {
            return false;
        }
        Optional<SMGEdgeHasValue> edge = smg.getHVEdgeFromMemoryLocation(this.pointerToStartObject);
        if (!edge.isPresent()) {
            return false;
        }
        SMGValue value = edge.orElseThrow().getValue();
        if (!smg.isPointer(value)) {
            return false;
        }
        SMGObject startObjectLock = smg.getPointer(value).getObject();
        return startObjectLock.equals(((SMGListCandidate)lcs.getCandidate()).getStartObject());
    }

    public int hashCode() {
        return Objects.hash(this.length, this.pointerToStartObject, this.shape);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SMGAbstractListCandidateSequenceBlock)) {
            return false;
        }
        SMGAbstractListCandidateSequenceBlock other = (SMGAbstractListCandidateSequenceBlock)obj;
        return this.length == other.length && Objects.equals(this.pointerToStartObject, other.pointerToStartObject) && Objects.equals(this.shape, other.shape);
    }
}

