/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Table;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;

public abstract class SMGJoinAbstractListProgress<K, C extends SMGListCandidate<?>> {
    protected final Table<SMGObject, K, C> candidates = HashBasedTable.create();
    protected final Table<C, SMGJoinStatus, Integer> candidateLength = HashBasedTable.create();

    protected SMGJoinAbstractListProgress() {
    }

    public void updateProgress(C pPrevCandidate, C pCandidate, SMGJoinStatus pStatus, boolean pHasToBeLastInSequence) {
        Map candidateLengths = this.candidateLength.row(pCandidate);
        switch (pStatus) {
            case EQUAL: {
                this.updateEqualSegment(candidateLengths, pPrevCandidate);
                break;
            }
            case RIGHT_ENTAIL: {
                this.updateREntailSegment(candidateLengths, pPrevCandidate);
                break;
            }
            case LEFT_ENTAIL: {
                this.updateLEntailSegment(candidateLengths, pPrevCandidate);
                break;
            }
            case INCOMPARABLE: {
                this.updateIncomparableSegment(candidateLengths, pPrevCandidate);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private void updateIncomparableSegment(Map<SMGJoinStatus, Integer> candidateLengths, C pPrevCandidate) {
        if (candidateLengths.containsKey((Object)SMGJoinStatus.EQUAL) || candidateLengths.containsKey((Object)SMGJoinStatus.LEFT_ENTAIL) || candidateLengths.containsKey((Object)SMGJoinStatus.RIGHT_ENTAIL) || candidateLengths.containsKey((Object)SMGJoinStatus.INCOMPARABLE)) {
            int length = this.getMaxLength(candidateLengths, SMGJoinStatus.EQUAL, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.RIGHT_ENTAIL, SMGJoinStatus.INCOMPARABLE);
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.INCOMPARABLE, (Object)(length + 1));
        }
    }

    private void updateLEntailSegment(Map<SMGJoinStatus, Integer> candidateLengths, C pPrevCandidate) {
        int length;
        if (candidateLengths.containsKey((Object)SMGJoinStatus.EQUAL) || candidateLengths.containsKey((Object)SMGJoinStatus.LEFT_ENTAIL)) {
            length = this.getMaxLength(candidateLengths, SMGJoinStatus.EQUAL, SMGJoinStatus.LEFT_ENTAIL);
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.LEFT_ENTAIL, (Object)(length + 1));
        }
        if (candidateLengths.containsKey((Object)SMGJoinStatus.RIGHT_ENTAIL) || candidateLengths.containsKey((Object)SMGJoinStatus.INCOMPARABLE)) {
            length = this.getMaxLength(candidateLengths, SMGJoinStatus.RIGHT_ENTAIL, SMGJoinStatus.INCOMPARABLE);
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.INCOMPARABLE, (Object)(length + 1));
        }
    }

    private void updateREntailSegment(Map<SMGJoinStatus, Integer> candidateLengths, C pPrevCandidate) {
        int length;
        if (candidateLengths.containsKey((Object)SMGJoinStatus.EQUAL) || candidateLengths.containsKey((Object)SMGJoinStatus.RIGHT_ENTAIL)) {
            length = this.getMaxLength(candidateLengths, SMGJoinStatus.EQUAL, SMGJoinStatus.RIGHT_ENTAIL);
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.RIGHT_ENTAIL, (Object)(length + 1));
        }
        if (candidateLengths.containsKey((Object)SMGJoinStatus.LEFT_ENTAIL) || candidateLengths.containsKey((Object)SMGJoinStatus.INCOMPARABLE)) {
            length = this.getMaxLength(candidateLengths, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.INCOMPARABLE);
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.INCOMPARABLE, (Object)(length + 1));
        }
    }

    private int getMaxLength(Map<SMGJoinStatus, Integer> candidateLengths, SMGJoinStatus ... status) {
        int result = 0;
        for (SMGJoinStatus s : status) {
            result = Math.max(result, candidateLengths.getOrDefault((Object)s, 0));
        }
        return result;
    }

    private void updateEqualSegment(Map<SMGJoinStatus, Integer> candidateLengths, C pPrevCandidate) {
        if (candidateLengths.containsKey((Object)SMGJoinStatus.EQUAL)) {
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.EQUAL, (Object)(candidateLengths.get((Object)SMGJoinStatus.EQUAL) + 1));
        }
        if (candidateLengths.containsKey((Object)SMGJoinStatus.LEFT_ENTAIL)) {
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.LEFT_ENTAIL, (Object)(candidateLengths.get((Object)SMGJoinStatus.LEFT_ENTAIL) + 1));
        }
        if (candidateLengths.containsKey((Object)SMGJoinStatus.RIGHT_ENTAIL)) {
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.RIGHT_ENTAIL, (Object)(candidateLengths.get((Object)SMGJoinStatus.RIGHT_ENTAIL) + 1));
        }
        if (candidateLengths.containsKey((Object)SMGJoinStatus.INCOMPARABLE)) {
            this.candidateLength.put(pPrevCandidate, (Object)SMGJoinStatus.INCOMPARABLE, (Object)(candidateLengths.get((Object)SMGJoinStatus.INCOMPARABLE) + 1));
        }
    }

    public @Nullable C getCandidate(SMGObject pObject, K key) {
        return (C)((SMGListCandidate)this.candidates.get((Object)pObject, key));
    }

    public void initializeLastInSequenceCandidate(C pCandidate) {
        this.candidateLength.put(pCandidate, (Object)SMGJoinStatus.EQUAL, (Object)1);
    }

    public boolean containsCandidate(SMGObject pObject, K key) {
        return this.candidates.contains((Object)pObject, key);
    }

    public boolean containsCandidateMap(SMGObject pObject) {
        return this.candidates.containsRow((Object)pObject);
    }

    public Set<SMGAbstractionCandidate> getValidCandidates(int pSeqLengthSubGraphEqualityThreshold, int pSeqLengthSubGraphEntailmentThreshold, int pSeqLengthSubGraphIncomparabilityThreshold, UnmodifiableCLangSMG pSMG, Set<? extends SMGAbstractListCandidateSequenceBlock<?>> pAbstractListBlocks) {
        HashSet<SMGAbstractionCandidate> resultBeforeBlocks = new HashSet<SMGAbstractionCandidate>();
        for (SMGListCandidate candidate : this.candidates.values()) {
            this.addCandidate(SMGJoinStatus.EQUAL, candidate, pSeqLengthSubGraphEqualityThreshold, pSMG, resultBeforeBlocks);
            this.addCandidate(SMGJoinStatus.LEFT_ENTAIL, candidate, pSeqLengthSubGraphEntailmentThreshold, pSMG, resultBeforeBlocks);
            this.addCandidate(SMGJoinStatus.RIGHT_ENTAIL, candidate, pSeqLengthSubGraphEntailmentThreshold, pSMG, resultBeforeBlocks);
            this.addCandidate(SMGJoinStatus.INCOMPARABLE, candidate, pSeqLengthSubGraphIncomparabilityThreshold, pSMG, resultBeforeBlocks);
        }
        HashSet<SMGAbstractionCandidate> result = new HashSet<SMGAbstractionCandidate>();
        for (SMGAbstractionCandidate candidate : resultBeforeBlocks) {
            if (!Iterables.all(pAbstractListBlocks, b -> !b.isBlocked(candidate, pSMG))) continue;
            result.add(candidate);
        }
        return result;
    }

    private void addCandidate(SMGJoinStatus joinStatus, C pCandidate, int pThreshold, UnmodifiableCLangSMG pSMG, Set<SMGAbstractionCandidate> pResultBeforeBlocks) {
        Integer length = (Integer)this.candidateLength.get(pCandidate, (Object)joinStatus);
        if (length != null && length >= pThreshold) {
            pResultBeforeBlocks.add(this.getCandidat(pCandidate, length, joinStatus, pSMG));
        }
    }

    protected abstract SMGAbstractionCandidate getCandidat(C var1, int var2, SMGJoinStatus var3, UnmodifiableCLangSMG var4);
}

