/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectVisitor;

public abstract class SMGObject
implements Comparable<SMGObject> {
    private final long size;
    private final String label;
    private final int level;
    private final SMGObjectKind kind;
    private static int count;
    private final int id;

    public SMGObjectKind getKind() {
        return this.kind;
    }

    protected SMGObject(long pSize, String pLabel, SMGObjectKind pKind) {
        this(pSize, pLabel, 0, pKind);
    }

    protected SMGObject(long pSize, String pLabel, int pLevel, SMGObjectKind pKind) {
        this(pSize, pLabel, pLevel, pKind, SMGObject.getNewId());
    }

    protected SMGObject(SMGObject pOther) {
        this(pOther.size, pOther.label, pOther.level, pOther.kind, pOther.id);
    }

    private SMGObject(long pSize, String pLabel, int pLevel, SMGObjectKind pKind, int pId) {
        this.size = pSize;
        this.label = pLabel;
        this.level = pLevel;
        this.kind = pKind;
        this.id = pId;
    }

    public abstract SMGObject copy(int var1);

    public String getLabel() {
        return this.label;
    }

    public long getSize() {
        return this.size;
    }

    public abstract boolean isAbstract();

    public abstract <T> T accept(SMGObjectVisitor<T> var1);

    public abstract boolean isMoreGeneral(SMGObject var1);

    public abstract SMGObject join(SMGObject var1, int var2);

    public int getLevel() {
        return this.level;
    }

    private static int getNewId() {
        return ++count;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public int compareTo(SMGObject o) {
        return Integer.compare(this.getId(), o.getId());
    }
}

