/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import com.google.errorprone.annotations.Immutable;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectVisitor;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGObjectTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

@Immutable
public final class SMGRegion
extends SMGObject
implements SMGObjectTemplate {
    public SMGRegion(long pSize, String pLabel) {
        super(pSize, pLabel, SMGObjectKind.REG);
    }

    public SMGRegion(long pSize) {
        super(pSize, "ID" + SMGCPA.getNewValue(), SMGObjectKind.REG);
    }

    public SMGRegion(SMGRegion pOther) {
        super(pOther);
    }

    public SMGRegion(long pSize, String pLabel, int pLevel) {
        super(pSize, pLabel, pLevel, SMGObjectKind.REG);
    }

    public String toString() {
        return "REGION(" + this.getLabel() + ", " + this.getSize() + "b, level=" + this.getLevel() + ")";
    }

    @Override
    public boolean isAbstract() {
        return false;
    }

    @Override
    public <T> T accept(SMGObjectVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public SMGObject join(SMGObject pOther, int pDestLevel) {
        if (pOther.isAbstract()) {
            return pOther.join(this, pDestLevel);
        }
        if (this.getSize() == pOther.getSize()) {
            return new SMGRegion(this.getSize(), this.getLabel(), pDestLevel);
        }
        throw new UnsupportedOperationException("join() called on incompatible SMGObjects");
    }

    @Override
    public SMGRegion createConcreteObject(Map<SMGValue, SMGValue> pAbstractToConcretePointerMap) {
        return new SMGRegion(this.getSize(), this.getLabel() + " ID " + SMGCPA.getNewValue());
    }

    @Override
    public SMGObject copy(int pNewLevel) {
        return new SMGRegion(this.getSize(), "ID" + SMGCPA.getNewValue() + " Copy of " + this.getId(), pNewLevel);
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        return false;
    }
}

