/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;

public class SMGRegionTest {
    @Before
    public void setUp() {
    }

    @Test
    public void testIsAbstract() {
        SMGRegion region = new SMGRegion(64L, "region");
        Truth.assertThat((Boolean)region.isAbstract()).isFalse();
    }

    @Test
    public void testJoin() {
        SMGRegion region = new SMGRegion(64L, "region");
        SMGRegion region_same = new SMGRegion(64L, "region");
        SMGObject objectJoint = region.join(region_same, region_same.getLevel());
        Truth.assertThat((Comparable)objectJoint).isInstanceOf(SMGRegion.class);
        SMGRegion regionJoint = (SMGRegion)objectJoint;
        Truth.assertThat((Long)regionJoint.getSize()).isEqualTo((Object)64);
        Truth.assertThat((String)regionJoint.getLabel()).isEqualTo((Object)"region");
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testJoinDiffSize() {
        SMGRegion region = new SMGRegion(64L, "region");
        SMGRegion regionDiff = new SMGRegion(80L, "region");
        region.join(regionDiff, regionDiff.getLevel());
    }

    @Test
    public void testPropertiesEqual() {
        SMGRegion one = new SMGRegion(64L, "region");
        SMGRegion two = new SMGRegion(64L, "region");
        SMGRegion three = new SMGRegion(80L, "region");
        SMGRegion four = new SMGRegion(64L, "REGION");
        Truth.assertThat((Long)two.getSize()).isEqualTo((Object)one.getSize());
        Truth.assertThat((Long)three.getSize()).isNotEqualTo((Object)one.getSize());
        Truth.assertThat((Long)four.getSize()).isEqualTo((Object)one.getSize());
        Truth.assertThat((String)two.getLabel()).isEqualTo((Object)one.getLabel());
        Truth.assertThat((String)three.getLabel()).isEqualTo((Object)one.getLabel());
        Truth.assertThat((String)four.getLabel()).isNotEqualTo((Object)one.getLabel());
    }
}

