/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionFinder;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGJoinDllProgress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGsForAbstraction;
import org.sosy_lab.cpachecker.util.Pair;

public class SMGDoublyLinkedListFinder
extends SMGAbstractionFinder {
    @VisibleForTesting
    public SMGDoublyLinkedListFinder() {
    }

    public SMGDoublyLinkedListFinder(int pSeqLengthEqualityThreshold, int pSeqLengthEntailmentThreshold, int pSeqLengthIncomparableThreshold) {
        super(pSeqLengthEqualityThreshold, pSeqLengthEntailmentThreshold, pSeqLengthIncomparableThreshold);
    }

    @Override
    public Set<SMGAbstractionCandidate> traverse(UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSMGState, Set<SMGAbstractionBlock> pAbstractionBlocks) throws SMGInconsistentException {
        SMGJoinDllProgress progress = new SMGJoinDllProgress();
        for (SMGObject object : pSmg.getHeapObjects()) {
            this.startTraversal(object, pSmg, pSMGState, progress);
        }
        ImmutableSet dllBlocks = FluentIterable.from(pAbstractionBlocks).filter(SMGDoublyLinkedListCandidateSequenceBlock.class).toSet();
        return progress.getValidCandidates(this.seqLengthEqualityThreshold, this.seqLengthEntailmentThreshold, this.seqLengthIncomparableThreshold, pSmg, (Set<? extends SMGAbstractListCandidateSequenceBlock<?>>)dllBlocks);
    }

    private void startTraversal(SMGObject pObject, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGJoinDllProgress pProgress) throws SMGInconsistentException {
        if (pProgress.containsCandidateMap(pObject)) {
            return;
        }
        this.createCandidatesOfObject(pObject, pSmg, pSmgState, pProgress);
    }

    private void createCandidatesOfObject(SMGObject pObject, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSMGState, SMGJoinDllProgress pProgress) throws SMGInconsistentException {
        if (!pSmg.isObjectValid(pObject)) {
            return;
        }
        if (pObject.getKind() != SMGObjectKind.DLL && pObject.getKind() != SMGObjectKind.REG) {
            return;
        }
        SMGHasValueEdges hvesOfObject = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject));
        if (hvesOfObject.size() < 2) {
            return;
        }
        for (SMGEdgeHasValue hveNext : hvesOfObject) {
            SMGObject nextObject;
            SMGHasValueEdges nextObjectHves;
            SMGValue nextPointer = hveNext.getValue();
            if (!pSmg.isPointer(nextPointer)) continue;
            SMGEdgePointsTo nextPointerEdge = pSmg.getPointer(nextPointer);
            long hfo = nextPointerEdge.getOffset();
            SMGTargetSpecifier nextPointerTg = nextPointerEdge.getTargetSpecifier();
            if (nextPointerTg != SMGTargetSpecifier.REGION && nextPointerTg != SMGTargetSpecifier.FIRST || (nextObjectHves = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject = nextPointerEdge.getObject()))).size() < 2 || pObject == nextObject || pObject.getSize() != nextObject.getSize() || !pSmg.isObjectValid(nextObject) || nextObject.getLevel() != pObject.getLevel() || nextObject.getKind() != SMGObjectKind.DLL && nextObject.getKind() != SMGObjectKind.REG) continue;
            long nfo = hveNext.getOffset();
            for (SMGEdgeHasValue hvePrev : nextObjectHves) {
                Iterable<SMGEdgeHasValue> prevObjectprevPointer;
                SMGTargetSpecifier prevPointerTg;
                SMGEdgePointsTo prevPointerEdge;
                SMGValue prevPointer;
                long pfo = hvePrev.getOffset();
                if (nfo >= pfo || !pSmg.isPointer(prevPointer = hvePrev.getValue()) || (prevPointerEdge = pSmg.getPointer(prevPointer)).getOffset() != hfo || (prevPointerTg = prevPointerEdge.getTargetSpecifier()) != SMGTargetSpecifier.REGION && prevPointerTg != SMGTargetSpecifier.LAST || pObject != prevPointerEdge.getObject() || Iterables.size(prevObjectprevPointer = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject).filterAtOffset(pfo).filterBySize(pSmg.getSizeofPtrInBits()))) != 1 || !pSmg.isPointer(((SMGEdgeHasValue)Iterables.getOnlyElement(prevObjectprevPointer)).getValue())) continue;
                SMGDoublyLinkedListCandidate candidate = new SMGDoublyLinkedListCandidate(pObject, pObject, hfo, pfo, nfo, hvePrev.getSizeInBits(), hveNext.getSizeInBits(), pSmg.getMachineModel());
                pProgress.initializeCandidiate(candidate);
                this.continueTraversal(nextPointer, candidate, pSmg, pSMGState, pProgress);
            }
        }
    }

    private void continueTraversal(SMGValue pValue, SMGDoublyLinkedListCandidate pPrevCandidate, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGJoinDllProgress pProgress) throws SMGInconsistentException {
        SMGDoublyLinkedListCandidate candidate;
        SMGEdgePointsTo pt = pSmg.getPointer(pValue);
        SMGObject nextObject = pt.getObject();
        SMGObject startObject = pPrevCandidate.getStartObject();
        if (!pSmg.isHeapObject(nextObject)) {
            return;
        }
        if (!pProgress.containsCandidateMap(nextObject)) {
            this.startTraversal(nextObject, pSmg, pSmgState, pProgress);
        }
        Long nfo = ((SMGDoublyLinkedListShape)pPrevCandidate.getShape()).getNfo();
        Long pfo = ((SMGDoublyLinkedListShape)pPrevCandidate.getShape()).getPfo();
        Long hfo = ((SMGDoublyLinkedListShape)pPrevCandidate.getShape()).getHfo();
        if (!pProgress.containsCandidate(nextObject, Pair.of(nfo, pfo))) {
            if (!pSmg.isObjectValid(nextObject) || nextObject.getLevel() != startObject.getLevel()) {
                return;
            }
            if (nextObject.getKind() != SMGObjectKind.DLL && nextObject.getKind() != SMGObjectKind.REG) {
                return;
            }
            Iterable<SMGEdgeHasValue> nextObjectNextField = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(nfo).filterBySize(pSmg.getSizeofPtrInBits()));
            if (Iterables.size(nextObjectNextField) != 1) {
                return;
            }
            SMGEdgeHasValue nfoField = (SMGEdgeHasValue)Iterables.getOnlyElement(nextObjectNextField);
            SMGEdgeHasValue pfoField = (SMGEdgeHasValue)Iterables.getOnlyElement(pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(pfo).filterBySize(pSmg.getSizeofPtrInBits())));
            if (!pSmg.isPointer(nfoField.getValue())) {
                return;
            }
            candidate = new SMGDoublyLinkedListCandidate(nextObject, nextObject, hfo, pfo, nfo, pfoField.getSizeInBits(), nfoField.getSizeInBits(), pSmg.getMachineModel());
            pProgress.initializeLastInSequenceCandidate(candidate);
        } else {
            candidate = (SMGDoublyLinkedListCandidate)pProgress.getCandidate(nextObject, Pair.of(nfo, pfo));
        }
        if (candidate.getLastObject().equals(startObject)) {
            return;
        }
        if (((SMGDoublyLinkedListShape)candidate.getShape()).getHfo() != ((SMGDoublyLinkedListShape)pPrevCandidate.getShape()).getHfo()) {
            return;
        }
        SMGJoinSubSMGsForAbstraction join = new SMGJoinSubSMGsForAbstraction(pSmg.copyOf(), startObject, nextObject, candidate, pSmgState);
        if (!join.isDefined()) {
            return;
        }
        Set<SMGObject> nonSharedObject1 = join.getNonSharedObjectsFromSMG1();
        Set<SMGValue> nonSharedValues1 = join.getNonSharedValuesFromSMG1();
        Set<SMGObject> nonSharedObject2 = join.getNonSharedObjectsFromSMG2();
        Set<SMGValue> nonSharedValues2 = join.getNonSharedValuesFromSMG2();
        HashSet<SMGObject> objectsOfSubSmg1 = new HashSet<SMGObject>();
        HashSet<SMGObject> objectsOfSubSmg2 = new HashSet<SMGObject>();
        HashSet<SMGValue> valuesOfSubSmg1 = new HashSet<SMGValue>();
        HashSet<SMGValue> valuesOfSubSmg2 = new HashSet<SMGValue>();
        Predicate<SMGEdgeHasValue> check = hve -> hve.getOffset() != pfo.longValue() && hve.getOffset() != nfo.longValue();
        this.getSubSmgOf(startObject, check, pSmg, valuesOfSubSmg1, objectsOfSubSmg1);
        this.getSubSmgOf(nextObject, check, pSmg, valuesOfSubSmg2, objectsOfSubSmg2);
        objectsOfSubSmg1.remove(startObject);
        objectsOfSubSmg2.remove(nextObject);
        nonSharedValues2.remove(pValue);
        SMGValue prevValue = ((SMGEdgeHasValue)Iterables.getOnlyElement(pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(pfo).filterWithoutSize()))).getValue();
        nonSharedValues1.remove(prevValue);
        if (!this.isSubSmgSeperate(nonSharedObject1, nonSharedValues1, pSmg, objectsOfSubSmg1, valuesOfSubSmg1, startObject)) {
            return;
        }
        if (!this.isSubSmgSeperate(nonSharedObject2, nonSharedValues2, pSmg, objectsOfSubSmg2, valuesOfSubSmg2, nextObject)) {
            return;
        }
        Set<SMGEdgePointsTo> ptes1 = SMGUtils.getPointerToThisObject(startObject, pSmg);
        Set<SMGEdgePointsTo> ptes2 = SMGUtils.getPointerToThisObject(nextObject, pSmg);
        for (SMGEdgePointsTo pte : ptes1) {
            Iterable<SMGEdgeHasValue> prevs;
            if (!(pte.getOffset() != ((SMGDoublyLinkedListShape)candidate.getShape()).getHfo() ? !nonSharedValues1.contains(pte.getValue()) : startObject.getKind() == SMGObjectKind.DLL && pte.getTargetSpecifier() == SMGTargetSpecifier.LAST && Iterables.size(prevs = pSmg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(pte.getValue()))) != 1)) continue;
            return;
        }
        boolean hasToBeLastInSequence = false;
        SMGJoinStatus joinStatus = join.getStatus();
        for (SMGEdgePointsTo pte : ptes2) {
            if (pte.getOffset() != ((SMGDoublyLinkedListShape)candidate.getShape()).getHfo()) {
                if (nonSharedValues2.contains(pte.getValue())) continue;
                return;
            }
            if (nextObject.getKind() == SMGObjectKind.DLL && pte.getTargetSpecifier() == SMGTargetSpecifier.FIRST) {
                Iterable<SMGEdgeHasValue> prevs = pSmg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(pte.getValue()));
                if (Iterables.size(prevs) == 1) continue;
                return;
            }
            if (nextObject.getKind() != SMGObjectKind.REG || hasToBeLastInSequence) continue;
            Iterable<SMGEdgeHasValue> hves = pSmg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(pte.getValue()));
            int count = 0;
            for (SMGEdgeHasValue hve2 : hves) {
                if (nonSharedObject2.contains(hve2.getObject())) continue;
                ++count;
            }
            if (count == 2) continue;
            hasToBeLastInSequence = true;
            joinStatus = SMGJoinStatus.RIGHT_ENTAIL;
        }
        pProgress.updateProgress(pPrevCandidate, candidate, joinStatus, hasToBeLastInSequence);
    }
}

