/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll;

import com.google.common.collect.ImmutableSet;
import com.google.common.truth.Truth;
import java.math.BigInteger;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CSimpleType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMGTest;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListFinder;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGDoublyLinkedListFinderTest {
    private CSimpleType intType = CNumericTypes.SIGNED_INT;
    private final MachineModel MM = MachineModel.LINUX32;
    private CType pointerType = new CPointerType(false, false, this.intType);
    private final BigInteger ptrSize = this.MM.getSizeofInBits(this.pointerType);
    private CLangSMG smg1;

    @Before
    public void setUp() {
        this.smg1 = new CLangSMG(this.MM);
    }

    @Test
    public void simpleFindAbstractionCandidateTest() throws SMGInconsistentException {
        this.smg1.addStackFrame(CLangSMGTest.DUMMY_FUNCTION);
        for (int i = 0; i < 15; ++i) {
            SMGCPA.getNewValue();
        }
        SMGRegion l1 = new SMGRegion(96L, "l1");
        SMGRegion l2 = new SMGRegion(96L, "l2");
        SMGRegion l3 = new SMGRegion(96L, "l3");
        SMGRegion l4 = new SMGRegion(96L, "l4");
        SMGRegion l5 = new SMGRegion(96L, "l5");
        SMGRegion head = new SMGRegion(64L, "head");
        SMGKnownExpValue value5 = SMGKnownExpValue.valueOf(5);
        SMGKnownExpValue value6 = SMGKnownExpValue.valueOf(6);
        SMGKnownExpValue value7 = SMGKnownExpValue.valueOf(7);
        SMGKnownExpValue value8 = SMGKnownExpValue.valueOf(8);
        SMGKnownExpValue value9 = SMGKnownExpValue.valueOf(9);
        SMGKnownExpValue value10 = SMGKnownExpValue.valueOf(10);
        SMGEdgeHasValue headfn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)head, (SMGValue)value6);
        SMGEdgeHasValue l1fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l1, (SMGValue)value7);
        SMGEdgeHasValue l2fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l2, (SMGValue)value8);
        SMGEdgeHasValue l3fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l3, (SMGValue)value9);
        SMGEdgeHasValue l4fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l4, (SMGValue)value10);
        SMGEdgeHasValue l5fn = new SMGEdgeHasValue(this.ptrSize, 0L, (SMGObject)l5, (SMGValue)value5);
        SMGEdgeHasValue l1fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l1, (SMGValue)value5);
        SMGEdgeHasValue l2fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l2, (SMGValue)value6);
        SMGEdgeHasValue l3fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l3, (SMGValue)value7);
        SMGEdgeHasValue l4fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l4, (SMGValue)value8);
        SMGEdgeHasValue l5fp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)l5, (SMGValue)value9);
        SMGEdgeHasValue headfp = new SMGEdgeHasValue(this.ptrSize, 32L, (SMGObject)head, (SMGValue)value10);
        SMGEdgePointsTo lht = new SMGEdgePointsTo(value5, head, 0L);
        SMGEdgePointsTo l1t = new SMGEdgePointsTo(value6, l1, 0L);
        SMGEdgePointsTo l2t = new SMGEdgePointsTo(value7, l2, 0L);
        SMGEdgePointsTo l3t = new SMGEdgePointsTo(value8, l3, 0L);
        SMGEdgePointsTo l4t = new SMGEdgePointsTo(value9, l4, 0L);
        SMGEdgePointsTo l5t = new SMGEdgePointsTo(value10, l5, 0L);
        this.smg1.addGlobalObject(head);
        this.smg1.addHeapObject(l1);
        this.smg1.addHeapObject(l2);
        this.smg1.addHeapObject(l3);
        this.smg1.addHeapObject(l4);
        this.smg1.addHeapObject(l5);
        this.smg1.addValue(value5);
        this.smg1.addValue(value6);
        this.smg1.addValue(value7);
        this.smg1.addValue(value8);
        this.smg1.addValue(value9);
        this.smg1.addValue(value10);
        this.smg1.addHasValueEdge(headfn);
        this.smg1.addHasValueEdge(l1fn);
        this.smg1.addHasValueEdge(l2fn);
        this.smg1.addHasValueEdge(l3fn);
        this.smg1.addHasValueEdge(l4fn);
        this.smg1.addHasValueEdge(l5fn);
        this.smg1.addHasValueEdge(headfp);
        this.smg1.addHasValueEdge(l1fp);
        this.smg1.addHasValueEdge(l2fp);
        this.smg1.addHasValueEdge(l3fp);
        this.smg1.addHasValueEdge(l4fp);
        this.smg1.addHasValueEdge(l5fp);
        this.smg1.addPointsToEdge(l1t);
        this.smg1.addPointsToEdge(l2t);
        this.smg1.addPointsToEdge(l3t);
        this.smg1.addPointsToEdge(l4t);
        this.smg1.addPointsToEdge(l5t);
        this.smg1.addPointsToEdge(lht);
        this.smg1.setValidity(l1, true);
        this.smg1.setValidity(l2, true);
        this.smg1.setValidity(l3, true);
        this.smg1.setValidity(l4, true);
        this.smg1.setValidity(l5, true);
        this.smg1.setValidity(head, true);
        SMGDoublyLinkedListFinder f = new SMGDoublyLinkedListFinder();
        Set<SMGAbstractionCandidate> s = f.traverse(this.smg1, null, (Set<SMGAbstractionBlock>)ImmutableSet.of());
        Truth.assertThat(s).isNotEmpty();
    }
}

