/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll;

import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGJoinAbstractListProgress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListCandidateSequence;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.Pair;

class SMGJoinDllProgress
extends SMGJoinAbstractListProgress<Pair<Long, Long>, SMGDoublyLinkedListCandidate> {
    @Override
    public void updateProgress(SMGDoublyLinkedListCandidate pPrevCandidate, SMGDoublyLinkedListCandidate pCandidate, SMGJoinStatus pStatus, boolean pHasToBeLastInSequence) {
        pPrevCandidate.updateLastObject(pCandidate.getLastObject());
        if (pHasToBeLastInSequence) {
            assert ((Integer)this.candidateLength.get((Object)pPrevCandidate, (Object)SMGJoinStatus.EQUAL) == 1);
            this.candidateLength.put((Object)pPrevCandidate, (Object)pStatus, (Object)2);
            return;
        }
        super.updateProgress(pPrevCandidate, pCandidate, pStatus, pHasToBeLastInSequence);
    }

    public void initializeCandidiate(SMGDoublyLinkedListCandidate pCandidate) {
        this.candidates.put((Object)pCandidate.getStartObject(), Pair.of(((SMGDoublyLinkedListShape)pCandidate.getShape()).getNfo(), ((SMGDoublyLinkedListShape)pCandidate.getShape()).getPfo()), (Object)pCandidate);
        this.candidateLength.put((Object)pCandidate, (Object)SMGJoinStatus.EQUAL, (Object)1);
    }

    protected SMGDoublyLinkedListCandidateSequence getCandidat(SMGDoublyLinkedListCandidate pCandidate, int length, SMGJoinStatus status, UnmodifiableCLangSMG pSMG) {
        return new SMGDoublyLinkedListCandidateSequence(pCandidate, length, status, this.isDllPartOfSequence(pCandidate, length, pSMG));
    }

    private boolean isDllPartOfSequence(SMGDoublyLinkedListCandidate pCandidate, int pLength, UnmodifiableCLangSMG pSMG) {
        SMGObject nextObject = pCandidate.getStartObject();
        if (nextObject.getKind() == SMGObjectKind.DLL) {
            return true;
        }
        for (int i = 1; i < pLength; ++i) {
            SMGEdgeHasValue nextHveEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(pSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(((SMGDoublyLinkedListShape)pCandidate.getShape()).getNfo()).filterBySize(pSMG.getSizeofPtrInBits())));
            if ((nextObject = pSMG.getPointer(nextHveEdge.getValue()).getObject()).getKind() != SMGObjectKind.DLL) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "SMGJoinDllProgress [candidates=" + this.candidates + ", candidateLength=" + this.candidateLength + "]";
    }
}

