/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectVisitor;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidateTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.MaterlisationStep;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class GenericAbstraction
extends SMGObject
implements SMGAbstractObject {
    private final ImmutableMap<SMGValue, SMGValue> abstractToConcretePointerMap;
    private final ImmutableMap<SMGValue, List<MaterlisationStep>> materlisationStepMap;

    protected GenericAbstraction(int pSize, String pLabel, Map<SMGValue, List<MaterlisationStep>> pMaterlisationSteps, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap) {
        super(pSize, pLabel, SMGObjectKind.GENERIC);
        this.abstractToConcretePointerMap = ImmutableMap.copyOf(pAbstractToConcretePointerMap);
        this.materlisationStepMap = ImmutableMap.copyOf(pMaterlisationSteps);
    }

    public GenericAbstraction(long pSize, String pLabel, Map<SMGValue, List<MaterlisationStep>> pMaterlisationStepMap, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap, int pNewLevel) {
        super(pSize, pLabel, pNewLevel, SMGObjectKind.GENERIC);
        this.abstractToConcretePointerMap = ImmutableMap.copyOf(pAbstractToConcretePointerMap);
        this.materlisationStepMap = ImmutableMap.copyOf(pMaterlisationStepMap);
    }

    @Override
    public boolean matchGenericShape(SMGAbstractObject pOther) {
        return false;
    }

    @Override
    public boolean matchSpecificShape(SMGAbstractObject pOther) {
        return false;
    }

    public static GenericAbstraction valueOf(MachineModel pMachineModel, Map<SMGValue, List<MaterlisationStep>> pMaterlisationSteps, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap) {
        return new GenericAbstraction(100 * pMachineModel.getSizeofCharInBits(), "generic abtraction ID " + SMGCPA.getNewValue(), pMaterlisationSteps, pAbstractToConcretePointerMap);
    }

    public List<SMG> materialize(SMG pSMG, SMGValue pointer) {
        return Lists.transform(this.getSteps(pointer), step -> step.materialize(pSMG, (Map<SMGValue, SMGValue>)this.abstractToConcretePointerMap));
    }

    private List<MaterlisationStep> getSteps(SMGValue pPointer) {
        for (Map.Entry entry : this.abstractToConcretePointerMap.entrySet()) {
            if (!((SMGValue)entry.getValue()).equals(pPointer)) continue;
            return (List)this.materlisationStepMap.get(entry.getKey());
        }
        throw new AssertionError();
    }

    public ImmutableMap<SMGValue, List<MaterlisationStep>> getMaterlisationStepMap() {
        return this.materlisationStepMap;
    }

    public ImmutableMap<SMGValue, SMGValue> getAbstractToConcretePointerMap() {
        return this.abstractToConcretePointerMap;
    }

    public String toString() {
        return "Generic Abstraction:\npointersToThisAbstraction " + this.abstractToConcretePointerMap + "\npointersToThisAbstraction " + this.abstractToConcretePointerMap + "\nmaterlisationSteps " + this.materlisationStepMap;
    }

    public GenericAbstractionCandidateTemplate createCandidateTemplate(MachineModel pMachineModel) {
        return GenericAbstractionCandidateTemplate.valueOf(pMachineModel, this.materlisationStepMap);
    }

    @Override
    public SMGObject copy(int pNewLevel) {
        return new GenericAbstraction(this.getSize(), this.getLabel(), (Map<SMGValue, List<MaterlisationStep>>)this.materlisationStepMap, (Map<SMGValue, SMGValue>)this.abstractToConcretePointerMap, pNewLevel);
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        return false;
    }

    @Override
    public <T> T accept(SMGObjectVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public SMGObject join(SMGObject pOther, int pDestLevel) {
        throw new UnsupportedOperationException("GenericAbstraction does not join");
    }

    @Override
    public boolean isAbstract() {
        throw new UnsupportedOperationException("GenericAbstraction does not know if it is abstract?");
    }
}

