/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidateTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.MaterlisationStep;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGGenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class GenericAbstractionCandidate
implements SMGGenericAbstractionCandidate {
    private final MachineModel machineModel;
    private final Set<SMGObject> objectsToBeRemoved;
    private final Map<SMGValue, SMGValue> abstractToConcretePointerMap;
    private final Map<SMGValue, List<MaterlisationStep>> materlisationStep;
    private final int score;

    private GenericAbstractionCandidate(MachineModel pMachineModel, Set<SMGObject> pObjectsToBeRemoved, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap, Map<SMGValue, List<MaterlisationStep>> pMaterlisationStep, int pScore) {
        this.machineModel = pMachineModel;
        this.objectsToBeRemoved = pObjectsToBeRemoved;
        this.abstractToConcretePointerMap = pAbstractToConcretePointerMap;
        this.materlisationStep = pMaterlisationStep;
        this.score = pScore;
    }

    public Set<SMGObject> getObjectsToBeRemoved() {
        return this.objectsToBeRemoved;
    }

    public Map<SMGValue, SMGValue> getAbstractToConcretePointerMap() {
        return this.abstractToConcretePointerMap;
    }

    public static GenericAbstractionCandidate valueOf(MachineModel pMachineModel, Set<SMGObject> pObjectsToBeRemoved, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap, Map<SMGValue, List<MaterlisationStep>> pMaterlisationStep, int pScore) {
        return new GenericAbstractionCandidate(pMachineModel, pObjectsToBeRemoved, pAbstractToConcretePointerMap, pMaterlisationStep, pScore);
    }

    @Override
    public int getScore() {
        return this.score;
    }

    @Override
    public SMG execute(SMG pSMG) {
        GenericAbstraction genericAbstraction = GenericAbstraction.valueOf(this.machineModel, this.materlisationStep, this.abstractToConcretePointerMap);
        HashSet<SMGEdgePointsTo> pointsToThisAbstraction = new HashSet<SMGEdgePointsTo>();
        HashSet<SMGEdgeHasValue> pointsFromThisAbstraction = new HashSet<SMGEdgeHasValue>();
        int c = 0;
        for (SMGValue pointer : this.abstractToConcretePointerMap.values()) {
            assert (pSMG.isPointer(pointer));
            SMGEdgePointsTo pointerEdge = pSMG.getPointer(pointer);
            if (this.objectsToBeRemoved.contains(pointerEdge.getObject())) {
                SMGEdgePointsTo newPointer = new SMGEdgePointsTo(pointer, genericAbstraction, pointerEdge.getOffset());
                pointsToThisAbstraction.add(newPointer);
                continue;
            }
            SMGEdgeHasValue dummyEdge = new SMGEdgeHasValue(1L, (long)c, (SMGObject)genericAbstraction, pointer);
            pointsFromThisAbstraction.add(dummyEdge);
            ++c;
        }
        for (SMGObject obj : this.objectsToBeRemoved) {
            assert (pSMG.getObjects().contains(obj));
            pSMG.markObjectDeletedAndRemoveEdges(obj);
        }
        this.connect(pSMG, genericAbstraction, pointsToThisAbstraction, pointsFromThisAbstraction);
        return pSMG;
    }

    private void connect(SMG pSMG, GenericAbstraction pGenericAbstraction, Set<SMGEdgePointsTo> pAbstractAddresses, Set<SMGEdgeHasValue> pAbstractFields) {
        pSMG.addObject(pGenericAbstraction);
        for (SMGEdgePointsTo pte : pAbstractAddresses) {
            pSMG.addPointsToEdge(pte);
        }
        for (SMGEdgeHasValue hve : pAbstractFields) {
            pSMG.addHasValueEdge(hve);
        }
    }

    @Override
    public boolean isUnknown() {
        return false;
    }

    public GenericAbstractionCandidateTemplate createTemplate(MachineModel pMachineModel) {
        return GenericAbstractionCandidateTemplate.valueOf(pMachineModel, this.materlisationStep);
    }
}

