/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeHasValueTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeHasValueTemplateWithConcreteValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgePointsToTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGObjectTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class MaterlisationStep {
    private final boolean stop;
    private final Set<SMGEdgePointsToTemplate> targetAdressTemplateOfPointer;
    private final Set<SMGEdgePointsToTemplate> pointerTemplate;
    private final Set<SMGEdgeHasValueTemplate> fieldTemplateContainingPointer;
    private final Set<SMGEdgeHasValueTemplate> fieldTemplateContainingPointerTemplate;
    private final Set<SMGEdgeHasValueTemplateWithConcreteValue> fieldTemplateContainingValue;
    private final Set<SMGObjectTemplate> objectTemplates;
    private final Map<SMGValue, SMGValue> uniquePointerTemplateToInterfacePointerTemplate;

    public MaterlisationStep(Set<SMGObjectTemplate> pAbstractObjects, Set<SMGEdgePointsToTemplate> pAbstractPointer, Set<SMGEdgeHasValueTemplateWithConcreteValue> pAbstractFields, Set<SMGEdgeHasValueTemplate> pAbstractFieldsToIPointer, Set<SMGEdgePointsToTemplate> pAbstractAdressesToOPointer, Set<SMGEdgeHasValueTemplate> pAbstractFieldsToOPointer, Map<SMGValue, SMGValue> pUniquePointerTemplateToInterfacePointerTemplate, boolean pStop) {
        this.targetAdressTemplateOfPointer = ImmutableSet.copyOf(pAbstractAdressesToOPointer);
        this.objectTemplates = ImmutableSet.copyOf(pAbstractObjects);
        this.pointerTemplate = ImmutableSet.copyOf(pAbstractPointer);
        this.fieldTemplateContainingValue = ImmutableSet.copyOf(pAbstractFields);
        this.fieldTemplateContainingPointerTemplate = ImmutableSet.copyOf(pAbstractFieldsToIPointer);
        this.fieldTemplateContainingPointer = ImmutableSet.copyOf(pAbstractFieldsToOPointer);
        this.uniquePointerTemplateToInterfacePointerTemplate = pUniquePointerTemplateToInterfacePointerTemplate;
        this.stop = pStop;
    }

    public boolean isStopStep() {
        return this.stop;
    }

    public Set<SMGObjectTemplate> getAbstractObjects() {
        return this.objectTemplates;
    }

    public Set<SMGEdgeHasValueTemplateWithConcreteValue> getAbstractFields() {
        return this.fieldTemplateContainingValue;
    }

    public Set<SMGEdgeHasValueTemplate> getAbstractFieldsToOPointer() {
        return this.fieldTemplateContainingPointer;
    }

    public Set<SMGEdgePointsToTemplate> getAbstractAdressesToOPointer() {
        return this.targetAdressTemplateOfPointer;
    }

    public Set<SMGEdgeHasValueTemplate> getAbstractFieldsToIPointer() {
        return this.fieldTemplateContainingPointerTemplate;
    }

    public Set<SMGEdgePointsToTemplate> getAbstractPointers() {
        return this.pointerTemplate;
    }

    public SMG materialize(SMG pSMG, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap) {
        HashMap<SMGObjectTemplate, Map<SMGValue, SMGValue>> abstractObjectToPointersMap = new HashMap<SMGObjectTemplate, Map<SMGValue, SMGValue>>();
        for (SMGEdgePointsToTemplate sMGEdgePointsToTemplate : this.pointerTemplate) {
            this.assignAbstractToConcretePointer(sMGEdgePointsToTemplate, abstractObjectToPointersMap, pAbstractToConcretePointerMap, true);
        }
        for (SMGEdgePointsToTemplate sMGEdgePointsToTemplate : this.targetAdressTemplateOfPointer) {
            this.assignAbstractToConcretePointer(sMGEdgePointsToTemplate, abstractObjectToPointersMap, pAbstractToConcretePointerMap, false);
        }
        for (SMGEdgeHasValueTemplate sMGEdgeHasValueTemplate : this.fieldTemplateContainingPointerTemplate) {
            this.assignAbstractToConcretePointer(sMGEdgeHasValueTemplate, abstractObjectToPointersMap, pAbstractToConcretePointerMap, true);
        }
        for (SMGEdgeHasValueTemplate sMGEdgeHasValueTemplate : this.fieldTemplateContainingPointer) {
            this.assignAbstractToConcretePointer(sMGEdgeHasValueTemplate, abstractObjectToPointersMap, pAbstractToConcretePointerMap, false);
        }
        HashMap<SMGObjectTemplate, SMGObject> concreteObjectMap = new HashMap<SMGObjectTemplate, SMGObject>(this.objectTemplates.size());
        for (SMGObjectTemplate sMGObjectTemplate : this.objectTemplates) {
            HashMap<SMGValue, SMGValue> abstractToConcretePointerForObject = new HashMap<SMGValue, SMGValue>((Map)abstractObjectToPointersMap.get(sMGObjectTemplate));
            this.prepareForGenericAbstraction(abstractToConcretePointerForObject);
            SMGObject concreteObject = sMGObjectTemplate.createConcreteObject(abstractToConcretePointerForObject);
            concreteObjectMap.put(sMGObjectTemplate, concreteObject);
        }
        HashSet<SMGEdgePointsTo> hashSet = new HashSet<SMGEdgePointsTo>();
        for (SMGEdgePointsToTemplate abstractPointer : this.pointerTemplate) {
            this.createPointer(abstractPointer, abstractObjectToPointersMap, concreteObjectMap, hashSet);
        }
        for (SMGEdgePointsToTemplate abstractPointer : this.targetAdressTemplateOfPointer) {
            this.createPointer(abstractPointer, abstractObjectToPointersMap, concreteObjectMap, hashSet);
        }
        HashSet<SMGEdgeHasValue> hashSet2 = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValueTemplate aHve : this.fieldTemplateContainingPointerTemplate) {
            this.createFieldToPointer(aHve, concreteObjectMap, abstractObjectToPointersMap, hashSet2);
        }
        for (SMGEdgeHasValueTemplate aHve : this.fieldTemplateContainingPointer) {
            this.createFieldToPointer(aHve, concreteObjectMap, abstractObjectToPointersMap, hashSet2);
        }
        for (SMGEdgeHasValueTemplateWithConcreteValue aField : this.fieldTemplateContainingValue) {
            SMGObjectTemplate templateObject = aField.getObjectTemplate();
            long offset = aField.getOffset();
            SMGValue value = aField.getValue();
            SMGObject concreteObject = (SMGObject)concreteObjectMap.get(templateObject);
            SMGEdgeHasValue concreteHve = new SMGEdgeHasValue(aField.getSizeInBits(), offset, concreteObject, value);
            hashSet2.add(concreteHve);
        }
        for (SMGObject object : concreteObjectMap.values()) {
            pSMG.addObject(object);
        }
        for (SMGEdgeHasValue hve : hashSet2) {
            pSMG.addValue(hve.getValue());
            pSMG.addHasValueEdge(hve);
        }
        for (SMGEdgePointsTo pte : hashSet) {
            pSMG.addValue(pte.getValue());
            pSMG.addPointsToEdge(pte);
        }
        return pSMG;
    }

    private void prepareForGenericAbstraction(Map<SMGValue, SMGValue> pAbstractToConcretePointerForObject) {
        for (SMGValue abstractPointer : ImmutableSet.copyOf(pAbstractToConcretePointerForObject.keySet())) {
            if (!this.uniquePointerTemplateToInterfacePointerTemplate.containsKey(abstractPointer)) continue;
            SMGValue value = pAbstractToConcretePointerForObject.get(abstractPointer);
            SMGValue pointerTmp = this.uniquePointerTemplateToInterfacePointerTemplate.get(abstractPointer);
            pAbstractToConcretePointerForObject.remove(abstractPointer);
            pAbstractToConcretePointerForObject.put(pointerTmp, value);
        }
    }

    private void createFieldToPointer(SMGEdgeHasValueTemplate pAbstractField, Map<SMGObjectTemplate, SMGObject> pConcreteObjectMap, Map<SMGObjectTemplate, Map<SMGValue, SMGValue>> pAbstractObjectToPointersMap, Set<SMGEdgeHasValue> concreteHves) {
        SMGObjectTemplate templateObject = pAbstractField.getObjectTemplate();
        SMGObject object = pConcreteObjectMap.get(templateObject);
        long offset = pAbstractField.getOffset();
        SMGValue abstractValue = pAbstractField.getAbstractValue();
        SMGValue value = pAbstractObjectToPointersMap.get(templateObject).get(abstractValue);
        concreteHves.add(new SMGEdgeHasValue(pAbstractField.getSizeInBits(), offset, object, value));
    }

    private void createPointer(SMGEdgeTemplate pAbstractPointer, Map<SMGObjectTemplate, Map<SMGValue, SMGValue>> pAbstractObjectToPointersMap, Map<SMGObjectTemplate, SMGObject> pConcreteObjectMap, Set<SMGEdgePointsTo> concretePointer) {
        SMGObjectTemplate templateTarget = pAbstractPointer.getObjectTemplate();
        long offset = pAbstractPointer.getOffset();
        SMGValue abstractPointerValue = pAbstractPointer.getAbstractValue();
        SMGValue concretePointerValue = pAbstractObjectToPointersMap.get(templateTarget).get(abstractPointerValue);
        SMGObject concreteObjectTarget = pConcreteObjectMap.get(templateTarget);
        SMGEdgePointsTo edge = new SMGEdgePointsTo(concretePointerValue, concreteObjectTarget, offset);
        concretePointer.add(edge);
    }

    private void assignAbstractToConcretePointer(SMGEdgeTemplate edgeOfPointerTemplate, Map<SMGObjectTemplate, Map<SMGValue, SMGValue>> pAbstractObjectToPointersMap, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap, boolean createNewConcreteValue) {
        SMGObjectTemplate objectTemplate = edgeOfPointerTemplate.getObjectTemplate();
        if (!pAbstractObjectToPointersMap.containsKey(objectTemplate)) {
            pAbstractObjectToPointersMap.put(objectTemplate, new HashMap());
        }
        SMGValue abstractValue = edgeOfPointerTemplate.getAbstractValue();
        SMGValue value = createNewConcreteValue ? SMGKnownSymValue.of() : pAbstractToConcretePointerMap.get(abstractValue);
        pAbstractObjectToPointersMap.get(objectTemplate).put(abstractValue, value);
    }

    public Set<SMGRegion> getEntryRegions() {
        return FluentIterable.from(this.targetAdressTemplateOfPointer).transform(edge -> edge.getObjectTemplate()).filter(SMGRegion.class).toSet();
    }

    public Set<SMGEdgePointsToTemplate> getPointerToThisTemplate(SMGObjectTemplate pTemplate) {
        assert (this.objectTemplates.contains(pTemplate));
        return FluentIterable.from(this.pointerTemplate).append(this.targetAdressTemplateOfPointer).filter(ptEdge -> ptEdge.getObjectTemplate() == pTemplate).toSet();
    }

    public FieldsOfTemplate getFieldsOfThisTemplate(SMGObjectTemplate pTemplate) {
        assert (this.objectTemplates.contains(pTemplate));
        ImmutableSet lFieldTemplateContainingValue = FluentIterable.from(this.fieldTemplateContainingValue).filter(ptEdge -> ptEdge.getObjectTemplate() == pTemplate).toSet();
        ImmutableSet lFieldTemplateContainingPointerTemplate = FluentIterable.from(this.fieldTemplateContainingPointerTemplate).filter(ptEdge -> ptEdge.getObjectTemplate() == pTemplate).toSet();
        ImmutableSet lFieldTemplateContainingPointer = FluentIterable.from(this.fieldTemplateContainingPointer).filter(ptEdge -> ptEdge.getObjectTemplate() == pTemplate).toSet();
        return new FieldsOfTemplate((Set<SMGEdgeHasValueTemplateWithConcreteValue>)lFieldTemplateContainingValue, (Set<SMGEdgeHasValueTemplate>)lFieldTemplateContainingPointerTemplate, (Set<SMGEdgeHasValueTemplate>)lFieldTemplateContainingPointer, pTemplate);
    }

    public Set<SMGEdgeHasValueTemplate> getFieldsOfValue(SMGValue value) {
        return FluentIterable.from(this.fieldTemplateContainingValue).filter(SMGEdgeHasValueTemplate.class).append(this.fieldTemplateContainingPointerTemplate).append(this.fieldTemplateContainingPointer).filter(edge -> value.equals(edge.getAbstractValue())).toSet();
    }

    public Optional<SMGEdgePointsToTemplate> getPointer(SMGValue value) {
        for (SMGEdgePointsToTemplate edge : this.pointerTemplate) {
            if (!edge.getAbstractValue().equals(value)) continue;
            return Optional.of(edge);
        }
        for (SMGEdgePointsToTemplate edge : this.targetAdressTemplateOfPointer) {
            if (!edge.getAbstractValue().equals(value)) continue;
            return Optional.of(edge);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.targetAdressTemplateOfPointer.toString() + this.pointerTemplate + this.fieldTemplateContainingPointer + this.fieldTemplateContainingPointerTemplate + this.fieldTemplateContainingValue;
    }

    public boolean abstractInterfaceContains(SMGValue abstractValue) {
        for (SMGEdgeHasValueTemplate sMGEdgeHasValueTemplate : this.fieldTemplateContainingPointer) {
            if (!sMGEdgeHasValueTemplate.getAbstractValue().equals(abstractValue)) continue;
            return true;
        }
        for (SMGEdgePointsToTemplate sMGEdgePointsToTemplate : this.targetAdressTemplateOfPointer) {
            if (!sMGEdgePointsToTemplate.getAbstractValue().equals(abstractValue)) continue;
            return true;
        }
        return false;
    }

    public static class FieldsOfTemplate {
        private final SMGObjectTemplate template;
        private final Set<SMGEdgeHasValueTemplate> fieldTemplateContainingPointer;
        private final Set<SMGEdgeHasValueTemplate> fieldTemplateContainingPointerTemplate;
        private final Set<SMGEdgeHasValueTemplateWithConcreteValue> fieldTemplateContainingValue;

        public FieldsOfTemplate(Set<SMGEdgeHasValueTemplateWithConcreteValue> pFieldTemplateContainingValue, Set<SMGEdgeHasValueTemplate> pFieldTemplateContainingPointerTemplate, Set<SMGEdgeHasValueTemplate> pFieldTemplateContainingPointer, SMGObjectTemplate pTemplate) {
            this.fieldTemplateContainingPointer = pFieldTemplateContainingPointer;
            this.fieldTemplateContainingPointerTemplate = pFieldTemplateContainingPointerTemplate;
            this.fieldTemplateContainingValue = pFieldTemplateContainingValue;
            this.template = pTemplate;
        }

        public Set<SMGEdgeHasValueTemplateWithConcreteValue> getFieldTemplateContainingValue() {
            return this.fieldTemplateContainingValue;
        }

        public int size() {
            return this.fieldTemplateContainingPointer.size() + this.fieldTemplateContainingPointerTemplate.size() + this.fieldTemplateContainingValue.size();
        }

        public Set<SMGEdgeHasValueTemplate> getFieldTemplateContainingPointerTemplate() {
            return this.fieldTemplateContainingPointerTemplate;
        }

        public Set<SMGEdgeHasValueTemplate> getFieldTemplateContainingPointer() {
            return this.fieldTemplateContainingPointer;
        }

        public SMGObjectTemplate getTemplate() {
            return this.template;
        }
    }
}

