/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.optional;

import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectVisitor;

public class SMGOptionalObject
extends SMGObject
implements SMGAbstractObject {
    private final int id = SMGCPA.getNewValue();

    public SMGOptionalObject(int pSize) {
        super(pSize, "1/0", SMGObjectKind.OPTIONAL);
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    public SMGOptionalObject(long pSize, int pLevel) {
        super(pSize, "1/0", pLevel, SMGObjectKind.OPTIONAL);
    }

    @Override
    public boolean matchGenericShape(SMGAbstractObject pOther) {
        return pOther.getKind() == SMGObjectKind.OPTIONAL;
    }

    @Override
    public boolean matchSpecificShape(SMGAbstractObject pOther) {
        return this.matchGenericShape(pOther) && this.getSize() == ((SMGObject)((Object)pOther)).getSize();
    }

    @Override
    public SMGObject copy(int pNewLevel) {
        return new SMGOptionalObject(this.getSize(), pNewLevel);
    }

    @Override
    public boolean isMoreGeneral(SMGObject pOther) {
        switch (pOther.getKind()) {
            case REG: {
                return this.getSize() == pOther.getSize();
            }
        }
        return false;
    }

    @Override
    public <T> T accept(SMGObjectVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public SMGObject join(SMGObject pOther, int pDestLevel) {
        assert (this.getSize() == pOther.getSize());
        int level = Math.max(this.getLevel(), pOther.getLevel());
        switch (pOther.getKind()) {
            case REG: 
            case OPTIONAL: {
                return this.copy(level);
            }
        }
        return pOther.join(this, pDestLevel);
    }

    public String toString() {
        return "OPTIONAL(id=" + this.id + " size=" + this.getSize() + ", level=" + this.getLevel() + ")";
    }
}

