/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll;

import com.google.common.collect.Iterables;
import java.util.Map;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractListCandidateSequence;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGsForAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPathCollector;

public class SMGSingleLinkedListCandidateSequence
extends SMGAbstractListCandidateSequence<SMGSingleLinkedListCandidate> {
    public SMGSingleLinkedListCandidateSequence(SMGSingleLinkedListCandidate pCandidate, int pLength, SMGJoinStatus pSmgJoinStatus, boolean pIncludesSll) {
        super(pCandidate, pLength, pSmgJoinStatus, pIncludesSll);
    }

    @Override
    public CLangSMG execute(CLangSMG pSMG, SMGState pSmgState) throws SMGInconsistentException {
        SMGObject prevObject = ((SMGSingleLinkedListCandidate)this.candidate).getStartObject();
        long nfo = ((SMGSingleLinkedListShape)((SMGSingleLinkedListCandidate)this.candidate).getShape()).getNfo();
        pSmgState.pruneUnreachable();
        if (!pSMG.getHeapObjects().contains(prevObject)) {
            return pSMG;
        }
        for (int i = 1; i < this.length; ++i) {
            SMGJoinSubSMGsForAbstraction jointest;
            SMGEdgeHasValue nextEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(pSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(prevObject).filterAtOffset(nfo).filterBySize(pSMG.getSizeofPtrInBits())));
            SMGObject nextObject = pSMG.getPointer(nextEdge.getValue()).getObject();
            if (nextObject == prevObject) {
                throw new AssertionError((Object)"Invalid candidate sequence: Attempt to merge object with itself");
            }
            if (this.length > 1 && !(jointest = new SMGJoinSubSMGsForAbstraction(pSMG.copyOf(), prevObject, nextObject, this.candidate, pSmgState)).isDefined()) {
                return pSMG;
            }
            SMGJoinSubSMGsForAbstraction join = new SMGJoinSubSMGsForAbstraction(pSMG, prevObject, nextObject, this.candidate, pSmgState);
            if (!join.isDefined()) {
                throw new AssertionError((Object)"Unexpected join failure while abstracting longest mergeable sequence");
            }
            SMGObject newAbsObj = join.getNewAbstractObject();
            for (SMGEdgePointsTo sMGEdgePointsTo : SMGUtils.getPointerToThisObject(nextObject, pSMG)) {
                pSMG.removePointsToEdge(sMGEdgePointsTo.getValue());
                if (sMGEdgePointsTo.getTargetSpecifier() != SMGTargetSpecifier.ALL) continue;
                SMGEdgePointsTo newPte = new SMGEdgePointsTo(sMGEdgePointsTo.getValue(), newAbsObj, sMGEdgePointsTo.getOffset(), SMGTargetSpecifier.ALL);
                pSMG.addPointsToEdge(newPte);
            }
            this.addPointsToEdges(pSMG, prevObject, newAbsObj, SMGTargetSpecifier.FIRST);
            SMGEdgeHasValue nextObj2hve = (SMGEdgeHasValue)Iterables.getOnlyElement(pSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(nfo).filterBySize(pSMG.getSizeofPtrInBits())));
            for (SMGObject obj : join.getNonSharedObjectsFromSMG1()) {
                pSMG.markHeapObjectDeletedAndRemoveEdges(obj);
            }
            for (SMGObject obj : join.getNonSharedObjectsFromSMG2()) {
                pSMG.markHeapObjectDeletedAndRemoveEdges(obj);
            }
            pSMG.markHeapObjectDeletedAndRemoveEdges(nextObject);
            pSMG.markHeapObjectDeletedAndRemoveEdges(prevObject);
            prevObject = newAbsObj;
            SMGEdgeHasValue sMGEdgeHasValue = new SMGEdgeHasValue(nextObj2hve.getSizeInBits(), nextObj2hve.getOffset(), newAbsObj, nextObj2hve.getValue());
            pSMG.addHasValueEdge(sMGEdgeHasValue);
            pSmgState.pruneUnreachable();
            this.replaceSourceValues(pSMG, newAbsObj);
        }
        return pSMG;
    }

    public String toString() {
        return "SMGSingleLinkedListCandidateSequence [candidate=" + this.candidate + ", length=" + this.length + "]";
    }

    @Override
    public SMGAbstractionBlock createAbstractionBlock(UnmodifiableSMGState pSmgState) {
        Map<SMGObject, SMGMemoryPath> map = new SMGMemoryPathCollector(pSmgState.getHeap()).getHeapObjectMemoryPaths();
        SMGMemoryPath pPointerToStartObject = map.get(((SMGSingleLinkedListCandidate)this.candidate).getStartObject());
        return new SMGSingleLinkedListCandidateSequenceBlock((SMGSingleLinkedListShape)((SMGSingleLinkedListCandidate)this.candidate).getShape(), this.length, pPointerToStartObject);
    }
}

