/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidateSequence;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.TestHelpers;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

public class SMGSingleLinkedListCandidateTest {
    @Test
    public void basicTest() {
        SMGRegion object = new SMGRegion(64L, "object");
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(object, 32L, 0L, MachineModel.LINUX32.getSizeofInBits(CPointerType.POINTER_TO_VOID).longValueExact(), MachineModel.LINUX32);
        SMGSingleLinkedListCandidateSequence candidateSeq = new SMGSingleLinkedListCandidateSequence(candidate, 2, SMGJoinStatus.INCOMPARABLE, false);
        Truth.assertThat((Comparable)candidate.getStartObject()).isSameInstanceAs((Object)object);
        Truth.assertThat((Long)((SMGSingleLinkedListShape)candidate.getShape()).getNfo()).isEqualTo((Object)32);
        Truth.assertThat((Long)((SMGSingleLinkedListShape)candidate.getShape()).getHfo()).isEqualTo((Object)0);
        Truth.assertThat((Integer)candidateSeq.getLength()).isEqualTo((Object)2);
    }

    @Test
    public void executeOnSimpleList() throws SMGInconsistentException, InvalidConfigurationException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        int NODE_SIZE = 64;
        int SEGMENT_LENGTH = 4;
        int OFFSET = 0;
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, SEGMENT_LENGTH, NODE_SIZE, OFFSET, "pointer");
        SMGValue value = root.getValue();
        SMGObject startObject = smg.getPointer(value).getObject();
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(startObject, OFFSET, 0L, MachineModel.LINUX32.getSizeofInBits(CPointerType.POINTER_TO_VOID).longValueExact(), MachineModel.LINUX32);
        SMGSingleLinkedListCandidateSequence candidateSeq = new SMGSingleLinkedListCandidateSequence(candidate, SEGMENT_LENGTH, SMGJoinStatus.INCOMPARABLE, false);
        CLangSMG abstractedSmg = candidateSeq.execute(smg, new SMGState(LogManager.createTestLogManager(), MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration())));
        PersistentSet<SMGObject> heap = abstractedSmg.getHeapObjects();
        Truth.assertThat(heap).hasSize(2);
        SMGHasValueEdges globalHves = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(root.getObject()));
        root = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)globalHves);
        value = root.getValue();
        SMGObject pointedObject = abstractedSmg.getPointer(value).getObject();
        Truth.assertThat((Comparable)pointedObject).isInstanceOf(SMGSingleLinkedList.class);
        Truth.assertThat((Boolean)pointedObject.isAbstract()).isTrue();
        SMGSingleLinkedList segment = (SMGSingleLinkedList)pointedObject;
        Truth.assertThat((Long)segment.getSize()).isEqualTo((Object)NODE_SIZE);
        Truth.assertThat((Integer)segment.getMinimumLength()).isEqualTo((Object)SEGMENT_LENGTH);
        Truth.assertThat((Long)segment.getNfo()).isEqualTo((Object)OFFSET);
        SMGHasValueEdges outboundEdges = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(segment));
        Truth.assertThat((Iterable)outboundEdges).hasSize(1);
        SMGEdgeHasValue onlyOutboundEdge = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)outboundEdges);
        Truth.assertThat((Long)onlyOutboundEdge.getOffset()).isEqualTo((Object)OFFSET);
        Truth.assertThat((Iterable)outboundEdges).hasSize(1);
        onlyOutboundEdge = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)outboundEdges);
        Truth.assertThat((Comparable)onlyOutboundEdge.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
        Truth.assertThat((Long)onlyOutboundEdge.getOffset()).isEqualTo((Object)0);
        Truth.assertThat((Long)onlyOutboundEdge.getSizeInBits()).isEqualTo((Object)NODE_SIZE);
    }

    @Test
    public void executeOnNullTerminatedList() throws SMGInconsistentException, InvalidConfigurationException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, 2, 128, 64, "pointer");
        SMGValue value = root.getValue();
        SMGObject startObject = smg.getPointer(value).getObject();
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(startObject, 64L, 0L, MachineModel.LINUX32.getSizeofInBits(CPointerType.POINTER_TO_VOID).longValueExact(), MachineModel.LINUX32);
        SMGSingleLinkedListCandidateSequence candidateSeq = new SMGSingleLinkedListCandidateSequence(candidate, 2, SMGJoinStatus.INCOMPARABLE, false);
        CLangSMG abstractedSmg = candidateSeq.execute(smg, new SMGState(LogManager.createTestLogManager(), MachineModel.LINUX64, new SMGOptions(Configuration.defaultConfiguration())));
        PersistentSet<SMGObject> heap = abstractedSmg.getHeapObjects();
        Truth.assertThat(heap).hasSize(2);
        SMGHasValueEdges globalHves = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(root.getObject()));
        root = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)globalHves);
        value = root.getValue();
        SMGObject sll = abstractedSmg.getPointer(value).getObject();
        Truth.assertThat((Boolean)sll.isAbstract()).isTrue();
        Truth.assertThat((Comparable)sll).isInstanceOf(SMGSingleLinkedList.class);
        SMGSingleLinkedList realSll = (SMGSingleLinkedList)sll;
        Truth.assertThat((Integer)realSll.getMinimumLength()).isEqualTo((Object)2);
        SMGHasValueEdges outboundEdges = abstractedSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(realSll));
        Truth.assertThat((Iterable)outboundEdges).hasSize(1);
        SMGEdgeHasValue outbound = (SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)outboundEdges);
        Truth.assertThat((Long)outbound.getOffset()).isEqualTo((Object)64);
        Truth.assertThat((Long)outbound.getSizeInBits()).isEqualTo((Object)64);
        Truth.assertThat((Comparable)outbound.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
    }
}

