/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionFinder;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGJoinSllProgress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidateSequenceBlock;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGsForAbstraction;

public class SMGSingleLinkedListFinder
extends SMGAbstractionFinder {
    @VisibleForTesting
    public SMGSingleLinkedListFinder() {
    }

    public SMGSingleLinkedListFinder(int pSeqLengthEqualityThreshold, int pSeqLengthEntailmentThreshold, int pSeqLengthIncomparableThreshold) {
        super(pSeqLengthEqualityThreshold, pSeqLengthEntailmentThreshold, pSeqLengthIncomparableThreshold);
    }

    @Override
    public Set<SMGAbstractionCandidate> traverse(UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSMGState, Set<SMGAbstractionBlock> pAbstractionBlocks) throws SMGInconsistentException {
        SMGJoinSllProgress pProgress = new SMGJoinSllProgress();
        for (SMGObject object : pSmg.getHeapObjects()) {
            this.startTraversal(object, pSmg, pSMGState, pProgress);
        }
        ImmutableSet sllBlocks = FluentIterable.from(pAbstractionBlocks).filter(SMGSingleLinkedListCandidateSequenceBlock.class).toSet();
        return pProgress.getValidCandidates(this.seqLengthEqualityThreshold, this.seqLengthEntailmentThreshold, this.seqLengthIncomparableThreshold, pSmg, (Set<? extends SMGAbstractListCandidateSequenceBlock<?>>)sllBlocks);
    }

    private void startTraversal(SMGObject pObject, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGJoinSllProgress pProgress) throws SMGInconsistentException {
        if (pProgress.containsCandidateMap(pObject)) {
            return;
        }
        this.createCandidatesOfObject(pObject, pSmg, pSmgState, pProgress);
    }

    private void createCandidatesOfObject(SMGObject pObject, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSMGState, SMGJoinSllProgress pProgress) throws SMGInconsistentException {
        if (!pSmg.isObjectValid(pObject)) {
            return;
        }
        if (pObject.getKind() != SMGObjectKind.SLL && pObject.getKind() != SMGObjectKind.REG && pObject.getKind() != SMGObjectKind.OPTIONAL) {
            return;
        }
        for (SMGEdgeHasValue hveNext : pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject))) {
            SMGObject nextObject;
            long nfo = hveNext.getOffset();
            SMGValue nextPointer = hveNext.getValue();
            if (!pSmg.isPointer(nextPointer)) continue;
            SMGEdgePointsTo nextPointerEdge = pSmg.getPointer(nextPointer);
            long hfo = nextPointerEdge.getOffset();
            SMGTargetSpecifier nextPointerTg = nextPointerEdge.getTargetSpecifier();
            if (nextPointerTg != SMGTargetSpecifier.REGION && nextPointerTg != SMGTargetSpecifier.FIRST && nextPointerTg != SMGTargetSpecifier.OPT || pObject == (nextObject = nextPointerEdge.getObject()) || pObject.getSize() != nextObject.getSize() || nextObject.getKind() != SMGObjectKind.SLL && nextObject.getKind() != SMGObjectKind.REG && nextObject.getKind() != SMGObjectKind.OPTIONAL || !pSmg.isObjectValid(nextObject) || nextObject.getLevel() != pObject.getLevel()) continue;
            HashSet<Long> typeSizesOfThisObject = new HashSet<Long>();
            for (SMGEdgePointsTo edge : SMGUtils.getPointerToThisObject(pObject, pSmg)) {
                Iterable<SMGEdgeHasValue> hves = pSmg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(edge.getValue()).filterBySize(pSmg.getSizeofPtrInBits()));
                for (SMGEdgeHasValue hve : hves) {
                    typeSizesOfThisObject.add(hve.getSizeInBits());
                }
            }
            long nextSize = hveNext.getSizeInBits();
            if (!typeSizesOfThisObject.contains(nextSize)) continue;
            SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(pObject, nfo, hfo, nextSize, pSmg.getMachineModel());
            pProgress.initializeCandidiate(candidate);
            this.continueTraversal(nextPointer, candidate, pSmg, pSMGState, pProgress);
        }
    }

    private void continueTraversal(SMGValue pValue, SMGSingleLinkedListCandidate pPrevCandidate, UnmodifiableCLangSMG pSmg, UnmodifiableSMGState pSmgState, SMGJoinSllProgress pProgress) throws SMGInconsistentException {
        SMGSingleLinkedListCandidate candidate;
        SMGEdgePointsTo pt = pSmg.getPointer(pValue);
        SMGObject nextObject = pt.getObject();
        SMGObject startObject = pPrevCandidate.getStartObject();
        if (!pSmg.isHeapObject(nextObject)) {
            return;
        }
        if (!pProgress.containsCandidateMap(nextObject)) {
            this.startTraversal(nextObject, pSmg, pSmgState, pProgress);
        }
        Long nfo = ((SMGSingleLinkedListShape)pPrevCandidate.getShape()).getNfo();
        Long hfo = ((SMGSingleLinkedListShape)pPrevCandidate.getShape()).getHfo();
        if (!pProgress.containsCandidate(nextObject, nfo)) {
            if (!pSmg.isObjectValid(nextObject) || nextObject.getLevel() != startObject.getLevel()) {
                return;
            }
            if (nextObject.getKind() != SMGObjectKind.SLL && nextObject.getKind() != SMGObjectKind.REG && nextObject.getKind() != SMGObjectKind.OPTIONAL) {
                return;
            }
            Iterable<SMGEdgeHasValue> nextObjectNextPointer = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(nextObject).filterAtOffset(nfo).filterBySize(pSmg.getSizeofPtrInBits()));
            if (Iterables.size(nextObjectNextPointer) != 1) {
                return;
            }
            SMGEdgeHasValue nextEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(nextObjectNextPointer);
            if (!pSmg.isPointer(nextEdge.getValue())) {
                return;
            }
            candidate = new SMGSingleLinkedListCandidate(nextObject, nfo, hfo, nextEdge.getSizeInBits(), pSmg.getMachineModel());
            pProgress.initializeLastInSequenceCandidate(candidate);
        } else {
            candidate = (SMGSingleLinkedListCandidate)pProgress.getCandidate(nextObject, nfo);
        }
        if (((SMGSingleLinkedListShape)candidate.getShape()).getHfo() != ((SMGSingleLinkedListShape)pPrevCandidate.getShape()).getHfo()) {
            return;
        }
        SMGJoinSubSMGsForAbstraction join = new SMGJoinSubSMGsForAbstraction(pSmg.copyOf(), startObject, nextObject, candidate, pSmgState);
        if (!join.isDefined()) {
            return;
        }
        Set<SMGObject> nonSharedObject1 = join.getNonSharedObjectsFromSMG1();
        Set<SMGValue> nonSharedValues1 = join.getNonSharedValuesFromSMG1();
        Set<SMGObject> nonSharedObject2 = join.getNonSharedObjectsFromSMG2();
        Set<SMGValue> nonSharedValues2 = join.getNonSharedValuesFromSMG2();
        HashSet<SMGObject> objectsOfSubSmg1 = new HashSet<SMGObject>();
        HashSet<SMGObject> objectsOfSubSmg2 = new HashSet<SMGObject>();
        HashSet<SMGValue> valuesOfSubSmg1 = new HashSet<SMGValue>();
        HashSet<SMGValue> valuesOfSubSmg2 = new HashSet<SMGValue>();
        Predicate<SMGEdgeHasValue> check = hve -> hve.getOffset() != nfo.longValue();
        this.getSubSmgOf(startObject, check, pSmg, valuesOfSubSmg1, objectsOfSubSmg1);
        this.getSubSmgOf(nextObject, check, pSmg, valuesOfSubSmg2, objectsOfSubSmg2);
        objectsOfSubSmg1.remove(startObject);
        objectsOfSubSmg2.remove(nextObject);
        nonSharedValues2.remove(pValue);
        if (!this.isSubSmgSeperate(nonSharedObject1, nonSharedValues1, pSmg, objectsOfSubSmg1, valuesOfSubSmg1, startObject)) {
            this.isSubSmgSeperate(nonSharedObject1, nonSharedValues1, pSmg, objectsOfSubSmg1, valuesOfSubSmg1, startObject);
            return;
        }
        if (!this.isSubSmgSeperate(nonSharedObject2, nonSharedValues2, pSmg, objectsOfSubSmg2, valuesOfSubSmg2, nextObject)) {
            this.isSubSmgSeperate(nonSharedObject2, nonSharedValues2, pSmg, objectsOfSubSmg2, valuesOfSubSmg2, nextObject);
            return;
        }
        for (SMGEdgePointsTo pte : SMGUtils.getPointerToThisObject(startObject, pSmg)) {
            if (pte.getOffset() == ((SMGSingleLinkedListShape)candidate.getShape()).getHfo() || nonSharedValues1.contains(pte.getValue())) continue;
            return;
        }
        for (SMGEdgePointsTo pte : SMGUtils.getPointerToThisObject(nextObject, pSmg)) {
            Iterable<SMGEdgeHasValue> prevs;
            if (!(pte.getOffset() != ((SMGSingleLinkedListShape)candidate.getShape()).getHfo() ? !nonSharedValues2.contains(pte.getValue()) : Iterables.size(prevs = pSmg.getHVEdges(SMGEdgeHasValueFilter.valueFilter(pte.getValue()))) != 1)) continue;
            return;
        }
        pProgress.updateProgress(pPrevCandidate, candidate, join.getStatus(), true);
    }
}

