/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.Collection;
import java.util.Set;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidateSequence;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListFinder;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.TestHelpers;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGSingleLinkedListFinderTest {
    @Test
    public void simpleListTest() throws SMGInconsistentException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, 5, 128, 64, "pointer");
        SMGSingleLinkedListFinder finder = new SMGSingleLinkedListFinder();
        Set<SMGAbstractionCandidate> candidates = finder.traverse(smg, null, (Set<SMGAbstractionBlock>)ImmutableSet.of());
        Truth.assertThat((Boolean)(!candidates.isEmpty() ? 1 : 0)).isTrue();
        SMGAbstractionCandidate candidate = this.getBestCandidate(candidates);
        Truth.assertThat((Object)candidate).isInstanceOf(SMGSingleLinkedListCandidateSequence.class);
        SMGSingleLinkedListCandidateSequence sllCandidate = (SMGSingleLinkedListCandidateSequence)candidate;
        Truth.assertThat((Integer)sllCandidate.getLength()).isEqualTo((Object)5);
        Truth.assertThat((Long)((SMGSingleLinkedListShape)((SMGSingleLinkedListCandidate)sllCandidate.getCandidate()).getShape()).getNfo()).isEqualTo((Object)64);
        SMGRegion expectedStart = (SMGRegion)smg.getPointer(root.getValue()).getObject();
        Truth.assertThat((Comparable)((SMGSingleLinkedListCandidate)sllCandidate.getCandidate()).getStartObject()).isSameInstanceAs((Object)expectedStart);
    }

    private SMGAbstractionCandidate getBestCandidate(Collection<SMGAbstractionCandidate> candidates) {
        SMGAbstractionCandidate bestCandidate = candidates.iterator().next();
        for (SMGAbstractionCandidate candidate : candidates) {
            if (candidate.getScore() <= bestCandidate.getScore()) continue;
            bestCandidate = candidate;
        }
        return bestCandidate;
    }

    @Test
    public void nullifiedPointerInferenceTest() throws SMGInconsistentException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        TestHelpers.createGlobalList(smg, 2, 128, 64, "pointer");
        SMGSingleLinkedListFinder finder = new SMGSingleLinkedListFinder(2, 2, 2);
        Set<SMGAbstractionCandidate> candidates = finder.traverse(smg, null, (Set<SMGAbstractionBlock>)ImmutableSet.of());
        Truth.assertThat(candidates).hasSize(1);
    }

    @Test
    public void listWithInboundPointersTest() throws SMGInconsistentException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        SMGValue tail = TestHelpers.createList(smg, 4, 128, 64, "tail");
        SMGEdgeHasValue head = TestHelpers.createGlobalList(smg, 3, 128, 64, "head");
        SMGRegion inside = new SMGRegion(128L, "pointed_at");
        SMGEdgeHasValue tailConnection = new SMGEdgeHasValue(smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 64L, (SMGObject)inside, tail);
        SMGKnownSymbolicValue addressOfInside = SMGKnownSymValue.of();
        SMGEdgePointsTo insidePT = new SMGEdgePointsTo(addressOfInside, inside, 0L);
        SMGRegion inboundPointer = new SMGRegion(64L, "inbound_pointer");
        SMGEdgeHasValue inboundPointerConnection = new SMGEdgeHasValue(smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 0L, (SMGObject)inboundPointer, (SMGValue)addressOfInside);
        SMGObject lastFromHead = smg.getPointer(head.getValue()).getObject();
        SMGEdgeHasValue connection = null;
        do {
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(lastFromHead).filterAtOffset(64L).filterBySize(smg.getSizeofPtrInBits());
            Iterable<SMGEdgeHasValue> connections = smg.getHVEdges(filter);
            connection = null;
            if (!connections.iterator().hasNext()) continue;
            connection = (SMGEdgeHasValue)Iterables.getOnlyElement(connections);
            lastFromHead = smg.getPointer(connection.getValue()).getObject();
        } while (connection != null);
        for (SMGEdgeHasValue hv : smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(lastFromHead))) {
            smg.removeHasValueEdge(hv);
        }
        SMGEdgeHasValue headConnection = new SMGEdgeHasValue(smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 64L, lastFromHead, (SMGValue)addressOfInside);
        SMGRegion tailPointer = new SMGRegion(64L, "tail_pointer");
        SMGEdgeHasValue tailPointerConnection = new SMGEdgeHasValue(smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID), 0L, (SMGObject)tailPointer, tail);
        smg.addGlobalObject(tailPointer);
        smg.addHasValueEdge(tailPointerConnection);
        smg.addHeapObject(inside);
        smg.addValue(addressOfInside);
        smg.addPointsToEdge(insidePT);
        smg.addGlobalObject(inboundPointer);
        smg.addHasValueEdge(inboundPointerConnection);
        smg.addHasValueEdge(tailConnection);
        smg.addHasValueEdge(headConnection);
        SMGSingleLinkedListFinder finder = new SMGSingleLinkedListFinder();
        Set<SMGAbstractionCandidate> candidates = finder.traverse(smg, null, (Set<SMGAbstractionBlock>)ImmutableSet.of());
        Truth.assertThat((Boolean)(!candidates.isEmpty() ? 1 : 0)).isTrue();
        for (SMGAbstractionCandidate candidate : candidates) {
            Truth.assertThat((Boolean)(candidate.getLength() < 5 ? 1 : 0)).isTrue();
        }
    }
}

