/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.DummyAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;

public class SMGSingleLinkedListTest {
    @Test
    public void basicsTest() {
        SMGSingleLinkedList sll = new SMGSingleLinkedList(128L, 0L, 2L, 4, 0);
        Truth.assertThat((Boolean)sll.isAbstract()).isTrue();
        Truth.assertThat((Integer)sll.getMinimumLength()).isEqualTo((Object)4);
        Truth.assertThat((Long)sll.getSize()).isEqualTo((Object)128);
        Truth.assertThat((Long)sll.getNfo()).isEqualTo((Object)2);
    }

    @Test
    public void matchGenericShapeTest() {
        SMGRegion prototype = new SMGRegion(128L, "prototype");
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(128L, 0L, 0L, 4, 0);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(128L, 0L, 0L, 7, 0);
        SMGSingleLinkedList sll3 = new SMGSingleLinkedList(128L, 0L, 8L, 4, 0);
        DummyAbstraction dummy = new DummyAbstraction(prototype);
        Truth.assertThat((Boolean)sll1.matchGenericShape(dummy)).isFalse();
        Truth.assertThat((Boolean)sll1.matchGenericShape(sll2)).isTrue();
        Truth.assertThat((Boolean)sll2.matchGenericShape(sll3)).isTrue();
        Truth.assertThat((Boolean)sll1.matchGenericShape(sll3)).isTrue();
    }

    @Test
    public void matchSpecificShapeTest() {
        SMGRegion prototype = new SMGRegion(128L, "prototype");
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(128L, 0L, 0L, 4, 0);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(128L, 0L, 0L, 7, 0);
        SMGSingleLinkedList sll3 = new SMGSingleLinkedList(128L, 0L, 8L, 4, 0);
        DummyAbstraction dummy = new DummyAbstraction(prototype);
        Truth.assertThat((Boolean)sll1.matchSpecificShape(dummy)).isFalse();
        Truth.assertThat((Boolean)sll1.matchSpecificShape(sll2)).isTrue();
        Truth.assertThat((Boolean)sll2.matchSpecificShape(sll3)).isFalse();
        Truth.assertThat((Boolean)sll1.matchSpecificShape(sll3)).isFalse();
    }
}

