/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.test;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListAbstractionTestHelpers;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListAbstractionTestInputs;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListCircularity;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListLinkage;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;

@RunWith(value=Parameterized.class)
public class SMGAttachRegionToListTest {
    private static final String GLOBAL_LIST_POINTER_LABEL = "pointer";
    private static final MachineModel MACHINE_MODEL_FOR_TESTING = MachineModel.LINUX64;
    private static final int LEVEL_ZERO = 0;
    @Parameterized.Parameter(value=0)
    public SMGValue[] values;
    @Parameterized.Parameter(value=1)
    public SMGValue valueToAttach;
    @Parameterized.Parameter(value=2)
    public SMGListCircularity circularity;
    @Parameterized.Parameter(value=3)
    public SMGListLinkage linkage;
    private CLangSMG smg;
    private SMGState state;
    private SMGRegion globalListPointer;
    private SMGValue addressOfList;
    private SMGValue addressOfRegion;
    private SMGObjectKind listKind;
    private int nodeSize;
    private int hfo;
    private int nfo;
    private int pfo;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return SMGListAbstractionTestInputs.getAttachRegionToListTestInputs();
    }

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.smg = new CLangSMG(MACHINE_MODEL_FOR_TESTING);
        int intSize = 8 * MACHINE_MODEL_FOR_TESTING.getSizeofInt();
        int ptrSize = MACHINE_MODEL_FOR_TESTING.getSizeofPtrInBits();
        this.hfo = 0;
        this.nfo = 0;
        this.pfo = this.linkage == SMGListLinkage.DOUBLY_LINKED ? ptrSize : -1;
        int dfo = this.linkage == SMGListLinkage.DOUBLY_LINKED ? 2 * ptrSize : ptrSize;
        int dataSize = intSize;
        this.nodeSize = dfo + dataSize;
        this.listKind = this.linkage == SMGListLinkage.DOUBLY_LINKED ? SMGObjectKind.DLL : SMGObjectKind.SLL;
        this.addressOfRegion = SMGListAbstractionTestHelpers.addLinkedRegionsWithValuesToHeap(this.smg, new SMGValue[]{this.valueToAttach}, this.nodeSize, this.hfo, this.nfo, this.pfo, dfo, dataSize, this.circularity, this.linkage)[0];
        this.addressOfList = SMGListAbstractionTestHelpers.addLinkedListsWithValuesToHeap(this.smg, new SMGValue[][]{this.values}, this.nodeSize, this.hfo, this.nfo, this.pfo, dfo, dataSize, this.circularity, this.linkage)[0];
        this.state = new SMGState(LogManager.createTestLogManager(), new SMGOptions(Configuration.defaultConfiguration()), this.smg, 0, PersistentBiMap.of());
    }

    @Test
    public void testAbstractionOfListWithPrependedRegion() throws SMGInconsistentException {
        SMGValue firstAddress = this.addressOfRegion;
        SMGValue secondAddress = this.addressOfList;
        firstAddress = SMGListAbstractionTestHelpers.linkObjectsOnHeap(this.smg, new SMGValue[]{firstAddress, secondAddress}, this.hfo, this.nfo, this.pfo, this.circularity, this.linkage)[0];
        this.globalListPointer = SMGListAbstractionTestHelpers.addGlobalListPointerToSMG(this.smg, firstAddress, GLOBAL_LIST_POINTER_LABEL);
        SMGListAbstractionTestHelpers.executeHeapAbstractionWithConsistencyChecks(this.state, this.smg);
        SMGHasValueEdges hves = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(this.globalListPointer));
        Truth.assertThat((Iterable)hves).hasSize(1);
        SMGEdgePointsTo pt = this.smg.getPointer(((SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)hves)).getValue());
        SMGObject segment = pt.getObject();
        SMGListAbstractionTestHelpers.assertAbstractListSegmentAsExpected(segment, this.nodeSize, 0, this.listKind, this.values.length + 1);
    }

    @Test
    public void testAbstractonOfListWithAppendedRegion() throws SMGInconsistentException {
        SMGValue firstAddress = this.addressOfList;
        SMGValue secondAddress = this.addressOfRegion;
        firstAddress = SMGListAbstractionTestHelpers.linkObjectsOnHeap(this.smg, new SMGValue[]{firstAddress, secondAddress}, this.hfo, this.nfo, this.pfo, this.circularity, this.linkage)[0];
        this.globalListPointer = SMGListAbstractionTestHelpers.addGlobalListPointerToSMG(this.smg, firstAddress, GLOBAL_LIST_POINTER_LABEL);
        SMGListAbstractionTestHelpers.executeHeapAbstractionWithConsistencyChecks(this.state, this.smg);
        SMGHasValueEdges hves = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(this.globalListPointer));
        Truth.assertThat((Iterable)hves).hasSize(1);
        SMGEdgePointsTo pt = this.smg.getPointer(((SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)hves)).getValue());
        SMGObject segment = pt.getObject();
        SMGListAbstractionTestHelpers.assertAbstractListSegmentAsExpected(segment, this.nodeSize, 0, this.listKind, this.values.length + 1);
    }
}

