/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Stream;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionManager;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGRuntimeCheck;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListCircularity;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListLinkage;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public final class SMGListAbstractionTestHelpers {
    private static SMGValue newVal() {
        return SMGKnownSymValue.of();
    }

    private static SMGValue[] generateNewAddresses(int pCount) {
        Preconditions.checkArgument((pCount >= 1 ? 1 : 0) != 0, (Object)"Count must be at least 1.");
        SMGValue[] addresses = new SMGValue[pCount];
        for (int i = 0; i < pCount; ++i) {
            addresses[i] = SMGListAbstractionTestHelpers.newVal();
        }
        return addresses;
    }

    private static SMGObject[] createRegionsOnHeap(CLangSMG pSmg, int pCount, int pSize) {
        Preconditions.checkArgument((pCount >= 1 ? 1 : 0) != 0, (Object)"Count must be at least 1.");
        SMGObject[] regions = new SMGObject[pCount];
        for (int i = 0; i < pCount; ++i) {
            SMGRegion region = new SMGRegion(pSize, "list_node" + i);
            pSmg.addHeapObject(region);
            regions[i] = region;
        }
        return regions;
    }

    private static SMGObject[] createListsOnHeap(CLangSMG pSmg, int pCount, int pSize, int pHfo, int pNfo, int pPfo, int[] pMinLengths, int pLevel, SMGListLinkage pLinkage) {
        Preconditions.checkArgument((pCount >= 1 ? 1 : 0) != 0, (Object)"Count must be at least 1.");
        SMGObject[] lists = new SMGObject[pCount];
        for (int i = 0; i < pCount; ++i) {
            SMGAbstractList list = null;
            switch (pLinkage) {
                case SINGLE_LINKED: {
                    list = new SMGSingleLinkedList(pSize, pHfo, pNfo, pMinLengths[i], pLevel);
                    break;
                }
                case DOUBLY_LINKED: {
                    list = new SMGDoublyLinkedList((long)pSize, pHfo, (long)pNfo, pPfo, pMinLengths[i], pLevel);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported linkage type: " + pLinkage);
                }
            }
            pSmg.addHeapObject(list);
            lists[i] = list;
        }
        return lists;
    }

    private static SMGEdgeHasValue[] addFieldsToObjectsOnHeap(CLangSMG pSmg, SMGObject[] pObjects, SMGValue[] pValues, int pFieldSize, int pFieldOffset) {
        Preconditions.checkArgument((pObjects != null && pValues != null && pObjects.length != 0 ? 1 : 0) != 0, (Object)"The provided arrays must not be null or empty.");
        Preconditions.checkArgument((pObjects.length == pValues.length ? 1 : 0) != 0, (Object)"The number of objects must be equal to the number of values.");
        SMGEdgeHasValue[] hvEdges = new SMGEdgeHasValue[pObjects.length];
        for (int i = 0; i < pObjects.length; ++i) {
            pSmg.addValue(pValues[i]);
            SMGEdgeHasValue hv = new SMGEdgeHasValue(pFieldSize, (long)pFieldOffset, pObjects[i], pValues[i]);
            pSmg.addHasValueEdge(hv);
            hvEdges[i] = hv;
        }
        return hvEdges;
    }

    private static SMGEdgePointsTo[] addPointersToRegionsOnHeap(CLangSMG pSmg, SMGObject[] pRegions, SMGValue[] pAddresses, int pOffset) {
        Preconditions.checkArgument((pRegions != null && pAddresses != null && pRegions.length != 0 ? 1 : 0) != 0, (Object)"The provided arrays must not be null or empty.");
        Preconditions.checkArgument((pRegions.length == pAddresses.length ? 1 : 0) != 0, (Object)"The number of regions must be equal to the number of addresses.");
        SMGEdgePointsTo[] ptEdges = new SMGEdgePointsTo[pRegions.length];
        for (int i = 0; i < pRegions.length; ++i) {
            pSmg.addValue(pAddresses[i]);
            SMGEdgePointsTo pt = new SMGEdgePointsTo(pAddresses[i], pRegions[i], pOffset, SMGTargetSpecifier.REGION);
            pSmg.addPointsToEdge(pt);
            ptEdges[i] = pt;
        }
        return ptEdges;
    }

    private static SMGEdgePointsTo[] addPointersToListsOnHeap(CLangSMG pSmg, SMGObject[] pLists, SMGValue[] pAddresses, int pHeadOffset, SMGTargetSpecifier pFirstOrLast) {
        Preconditions.checkArgument((pLists != null && pAddresses != null && pLists.length != 0 ? 1 : 0) != 0, (Object)"The provided arrays must not be null or empty.");
        Preconditions.checkArgument((pLists.length == pAddresses.length ? 1 : 0) != 0, (Object)"The number of lists must be equal to the number of addresses.");
        SMGEdgePointsTo[] ptEdges = new SMGEdgePointsTo[pLists.length];
        for (int i = 0; i < pLists.length; ++i) {
            pSmg.addValue(pAddresses[i]);
            SMGEdgePointsTo pt = new SMGEdgePointsTo(pAddresses[i], pLists[i], pHeadOffset, pFirstOrLast);
            pSmg.addPointsToEdge(pt);
            ptEdges[i] = pt;
        }
        return ptEdges;
    }

    static SMGValue[] linkObjectsOnHeap(CLangSMG pSmg, SMGValue[] pAddresses, int pHfo, int pNfo, int pPfo, SMGListCircularity pCircularity, SMGListLinkage pLinkage) {
        SMGEdgeHasValue hvNext;
        Preconditions.checkArgument((pSmg != null ? 1 : 0) != 0, (Object)"The smg was null.");
        Preconditions.checkArgument((pAddresses != null && pAddresses.length >= 1 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        Preconditions.checkArgument((pCircularity == SMGListCircularity.OPEN || pCircularity == SMGListCircularity.CIRCULAR ? 1 : 0) != 0, (String)"Unsupported list circularity: %s", (Object)((Object)pCircularity));
        Preconditions.checkArgument((pLinkage == SMGListLinkage.SINGLE_LINKED || pLinkage == SMGListLinkage.DOUBLY_LINKED ? 1 : 0) != 0, (String)"Unsupported list linkage: %s", (Object)((Object)pLinkage));
        SMGListAbstractionTestHelpers.deleteLinksOfObjects(pSmg, pAddresses, pNfo, pPfo);
        int ptrSize = pSmg.getSizeofPtrInBits();
        SMGValue firstAddress = pAddresses[0];
        if (!pSmg.isPointer(firstAddress)) {
            throw new IllegalArgumentException("Address " + firstAddress + " is not a valid pointer in the smg.");
        }
        SMGObject firstNode = pSmg.getObjectPointedBy(firstAddress);
        SMGObject node = null;
        SMGValue address = firstAddress;
        for (int i = 0; i < pAddresses.length; ++i) {
            SMGEdgeHasValue hvPrev;
            SMGValue previousAddress = address;
            address = pAddresses[i];
            SMGObject previousNode = node;
            if (!pSmg.isPointer(address)) {
                throw new IllegalArgumentException("Address " + address + " is not a valid pointer in the smg.");
            }
            node = pSmg.getObjectPointedBy(address);
            if (i == 0) {
                if (pCircularity != SMGListCircularity.OPEN || pLinkage != SMGListLinkage.DOUBLY_LINKED) continue;
                hvPrev = new SMGEdgeHasValue(ptrSize, (long)pPfo, node, (SMGValue)SMGZeroValue.INSTANCE);
                pSmg.addHasValueEdge(hvPrev);
                continue;
            }
            if (pLinkage == SMGListLinkage.DOUBLY_LINKED) {
                if (previousNode.getKind() == SMGObjectKind.DLL) {
                    SMGValue address2 = null;
                    Set<SMGEdgePointsTo> pte = pSmg.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(previousNode).filterByTargetSpecifier(SMGTargetSpecifier.LAST));
                    if (pte.isEmpty()) {
                        address2 = SMGListAbstractionTestHelpers.newVal();
                        pSmg.addValue(address2);
                        SMGEdgePointsTo pt2 = new SMGEdgePointsTo(address2, previousNode, pHfo, SMGTargetSpecifier.LAST);
                        pSmg.addPointsToEdge(pt2);
                    } else {
                        address2 = ((SMGEdgePointsTo)Iterables.getOnlyElement(pte)).getValue();
                    }
                    hvPrev = new SMGEdgeHasValue(ptrSize, (long)pPfo, node, address2);
                    pSmg.addHasValueEdge(hvPrev);
                } else {
                    hvPrev = new SMGEdgeHasValue(ptrSize, (long)pPfo, node, previousAddress);
                    pSmg.addHasValueEdge(hvPrev);
                }
            }
            SMGEdgeHasValue previousHvNext = new SMGEdgeHasValue(ptrSize, (long)pNfo, previousNode, address);
            pSmg.addHasValueEdge(previousHvNext);
        }
        assert (node != null);
        if (pCircularity.equals((Object)SMGListCircularity.CIRCULAR)) {
            hvNext = new SMGEdgeHasValue(ptrSize, (long)pNfo, node, firstAddress);
            if (pLinkage == SMGListLinkage.DOUBLY_LINKED) {
                SMGEdgeHasValue hvPrev;
                if (node.getKind() == SMGObjectKind.DLL) {
                    SMGValue address2 = null;
                    Set<SMGEdgePointsTo> pte = pSmg.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(node).filterByTargetSpecifier(SMGTargetSpecifier.LAST));
                    if (pte.isEmpty()) {
                        address2 = SMGListAbstractionTestHelpers.newVal();
                        pSmg.addValue(address2);
                        SMGEdgePointsTo pt2 = new SMGEdgePointsTo(address2, node, pHfo, SMGTargetSpecifier.LAST);
                        pSmg.addPointsToEdge(pt2);
                    } else {
                        address2 = ((SMGEdgePointsTo)Iterables.getOnlyElement(pte)).getValue();
                    }
                    hvPrev = new SMGEdgeHasValue(ptrSize, (long)pPfo, firstNode, address2);
                    pSmg.addHasValueEdge(hvPrev);
                } else {
                    hvPrev = new SMGEdgeHasValue(ptrSize, (long)pPfo, firstNode, address);
                    pSmg.addHasValueEdge(hvPrev);
                }
            }
        } else {
            hvNext = new SMGEdgeHasValue(ptrSize, (long)pNfo, node, (SMGValue)SMGZeroValue.INSTANCE);
        }
        pSmg.addHasValueEdge(hvNext);
        return pAddresses;
    }

    private static SMGValue[] joinValuesPerList(SMGValue[][] pLists) {
        Preconditions.checkArgument((pLists != null && pLists.length != 0 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        SMGValue[] values = new SMGValue[pLists.length];
        for (int i = 0; i < pLists.length; ++i) {
            Object[] list = pLists[i];
            if (list == null) {
                throw new IllegalArgumentException("The provided array must not contain null.");
            }
            values[i] = list.length < 1 || !Collections3.allElementsEqual((Object[])list) ? SMGListAbstractionTestHelpers.newVal() : list[0];
        }
        return values;
    }

    private static int[] getMinLengths(SMGValue[][] pLists) {
        Preconditions.checkArgument((pLists != null && pLists.length != 0 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        int[] minLengths = new int[pLists.length];
        for (int i = 0; i < pLists.length; ++i) {
            Preconditions.checkArgument((pLists[i] != null ? 1 : 0) != 0, (Object)"The provided array must not contain null.");
            minLengths[i] = pLists[i].length;
        }
        return minLengths;
    }

    private static void deleteLinksOfObjects(CLangSMG pSmg, SMGValue[] pAddresses, int pNfo, int pPfo) {
        Preconditions.checkArgument((pAddresses != null && pAddresses.length != 0 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        for (SMGValue address : pAddresses) {
            SMGObject object = pSmg.getObjectPointedBy(address);
            for (int offset : new int[]{pNfo, pPfo}) {
                Iterable<SMGEdgeHasValue> set = pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(object).filterAtOffset(offset).filterBySize(pSmg.getSizeofPtrInBits()));
                for (SMGEdgeHasValue hv : set) {
                    pSmg.removeHasValueEdge(hv);
                }
            }
        }
    }

    static SMGValue[] addLinkedRegionsWithValuesToHeap(CLangSMG pSmg, SMGValue[] pValues, int pSize, int pHfo, int pNfo, int pPfo, int pDfo, int pDataSize, SMGListCircularity pCircularity, SMGListLinkage pLinkage) {
        Preconditions.checkArgument((pValues != null && pValues.length >= 1 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        SMGValue[] addresses = SMGListAbstractionTestHelpers.generateNewAddresses(pValues.length);
        SMGObject[] regions = SMGListAbstractionTestHelpers.createRegionsOnHeap(pSmg, pValues.length, pSize);
        SMGListAbstractionTestHelpers.addPointersToRegionsOnHeap(pSmg, regions, addresses, 0);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, regions, pValues, pDataSize, pDfo);
        return SMGListAbstractionTestHelpers.linkObjectsOnHeap(pSmg, addresses, pHfo, pNfo, pPfo, pCircularity, pLinkage);
    }

    static SMGValue[] addLinkedRegionsWithRegionsWithValuesToHeap(CLangSMG pSmg, SMGValue[] pValues, int pRegionSize, int pSubregionSize, int pHfo, int pNfo, int pPfo, int pDfo, int pSubDfo, int pDataSize, int pSubDataSize, SMGListCircularity pCircularity, SMGListLinkage pLinkage) {
        Preconditions.checkArgument((pValues != null && pValues.length >= 1 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        SMGValue[] addresses = SMGListAbstractionTestHelpers.generateNewAddresses(pValues.length);
        SMGObject[] regions = SMGListAbstractionTestHelpers.createRegionsOnHeap(pSmg, pValues.length, pRegionSize);
        SMGValue[] subaddresses = SMGListAbstractionTestHelpers.generateNewAddresses(pValues.length);
        SMGObject[] subregions = SMGListAbstractionTestHelpers.createRegionsOnHeap(pSmg, pValues.length, pSubregionSize);
        SMGListAbstractionTestHelpers.addPointersToRegionsOnHeap(pSmg, regions, addresses, 0);
        SMGListAbstractionTestHelpers.addPointersToRegionsOnHeap(pSmg, subregions, subaddresses, 0);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, regions, subaddresses, pDataSize, pDfo);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, subregions, pValues, pSubDataSize, pSubDfo);
        return SMGListAbstractionTestHelpers.linkObjectsOnHeap(pSmg, addresses, pHfo, pNfo, pPfo, pCircularity, pLinkage);
    }

    static SMGValue[] addLinkedRegionsWithSublistsWithValuesToHeap(CLangSMG pSmg, SMGValue[][] pSublists, int pNodeSize, int pHfo, int pNfo, int pPfo, int pDfo, int pDataSize, SMGListCircularity pCircularity, SMGListLinkage pLinkage) {
        Preconditions.checkArgument((pSublists != null && pSublists.length >= 1 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        SMGValue[] addresses = SMGListAbstractionTestHelpers.generateNewAddresses(pSublists.length);
        SMGObject[] regions = SMGListAbstractionTestHelpers.createRegionsOnHeap(pSmg, pSublists.length, pNodeSize);
        SMGValue[] subaddresses = SMGListAbstractionTestHelpers.generateNewAddresses(pSublists.length);
        int[] minLengths = SMGListAbstractionTestHelpers.getMinLengths(pSublists);
        int level = 0;
        SMGObject[] sublists = SMGListAbstractionTestHelpers.createListsOnHeap(pSmg, pSublists.length, pNodeSize, pHfo, pNfo, pPfo, minLengths, level, pLinkage);
        SMGListAbstractionTestHelpers.addPointersToRegionsOnHeap(pSmg, regions, addresses, 0);
        SMGListAbstractionTestHelpers.addPointersToListsOnHeap(pSmg, sublists, subaddresses, pHfo, SMGTargetSpecifier.FIRST);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, regions, subaddresses, pSmg.getSizeofPtrInBits(), pDfo);
        SMGValue[] values = SMGListAbstractionTestHelpers.joinValuesPerList(pSublists);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, sublists, values, pDataSize, pDfo);
        return SMGListAbstractionTestHelpers.linkObjectsOnHeap(pSmg, addresses, pHfo, pNfo, pPfo, pCircularity, pLinkage);
    }

    static SMGValue[] addLinkedListsWithValuesToHeap(CLangSMG pSmg, SMGValue[][] pLists, int pNodeSize, int pHfo, int pNfo, int pPfo, int pDfo, int pDataSize, SMGListCircularity pCircularity, SMGListLinkage pLinkage) {
        Preconditions.checkArgument((pLists != null && pLists.length != 0 ? 1 : 0) != 0, (Object)"The provided array must not be null or empty.");
        SMGValue[] addresses = SMGListAbstractionTestHelpers.generateNewAddresses(pLists.length);
        int level = 0;
        int[] minLengths = SMGListAbstractionTestHelpers.getMinLengths(pLists);
        SMGObject[] lists = SMGListAbstractionTestHelpers.createListsOnHeap(pSmg, pLists.length, pNodeSize, pHfo, pNfo, pPfo, minLengths, level, pLinkage);
        SMGListAbstractionTestHelpers.addPointersToListsOnHeap(pSmg, lists, addresses, pHfo, SMGTargetSpecifier.FIRST);
        SMGValue[] values = SMGListAbstractionTestHelpers.joinValuesPerList(pLists);
        SMGListAbstractionTestHelpers.addFieldsToObjectsOnHeap(pSmg, lists, values, pDataSize, pDfo);
        return SMGListAbstractionTestHelpers.linkObjectsOnHeap(pSmg, addresses, pHfo, pNfo, pPfo, pCircularity, pLinkage);
    }

    static SMGRegion addGlobalListPointerToSMG(CLangSMG pSmg, SMGValue pHeadAddress, String pLabel) {
        SMGRegion globalVar = new SMGRegion(pSmg.getSizeofPtrInBits(), pLabel);
        SMGEdgeHasValue hv = new SMGEdgeHasValue(pSmg.getSizeofPtrInBits(), 0L, (SMGObject)globalVar, pHeadAddress);
        pSmg.addGlobalObject(globalVar);
        pSmg.addHasValueEdge(hv);
        return globalVar;
    }

    static void executeHeapAbstractionWithConsistencyChecks(SMGState pState, CLangSMG pSmg) throws SMGInconsistentException {
        SMGAbstractionManager manager = new SMGAbstractionManager(LogManager.createTestLogManager(), pSmg, pState);
        pState.performConsistencyCheck(SMGRuntimeCheck.FORCED);
        manager.execute();
        pState.pruneUnreachable();
        pState.performConsistencyCheck(SMGRuntimeCheck.FORCED);
    }

    static void assertAbstractListSegmentAsExpected(SMGObject pSegment, int pRegionSize, int pLevel, SMGObjectKind pListKind, int pListLength) {
        Truth.assertThat((Boolean)pSegment.isAbstract()).isTrue();
        Truth.assertThat((Long)pSegment.getSize()).isEqualTo((Object)pRegionSize);
        Truth.assertThat((Integer)pSegment.getLevel()).isEqualTo((Object)pLevel);
        Truth.assertThat((Comparable)((Object)pSegment.getKind())).isSameInstanceAs((Object)pListKind);
        Truth.assertThat((Comparable)pSegment).isInstanceOf(SMGAbstractList.class);
        SMGAbstractList segmentAsList = (SMGAbstractList)pSegment;
        Truth.assertThat((Integer)segmentAsList.getMinimumLength()).isAtMost((Comparable)Integer.valueOf(pListLength));
        Truth.assertThat((Integer)segmentAsList.getMinimumLength()).isEqualTo((Object)pListLength);
    }

    static void assertStoredDataOfAbstractList(CLangSMG pSmg, SMGValue[] pValues, SMGObject pObject, int pDfo) {
        if (Collections3.allElementsEqual((Object[])pValues)) {
            SMGEdgeHasValue hv = (SMGEdgeHasValue)Iterables.getOnlyElement(pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObject).filterAtOffset(pDfo).filterWithoutSize()));
            if (pValues.length > 0) {
                Truth.assertThat((Comparable)hv.getValue()).isEqualTo((Object)pValues[0]);
            }
        }
    }

    static void assertStoredDataOfAbstractSublist(CLangSMG pSmg, SMGValue[][] pSublists, SMGObject pSubobject, int pDfo) {
        if (pSublists.length == 0) {
            return;
        }
        if (Stream.of(pSublists).anyMatch(e -> e == null || ((SMGValue[])e).length == 0)) {
            return;
        }
        if (!Collections3.allElementsEqual(Stream.of(pSublists).flatMap(Arrays::stream))) {
            return;
        }
        SMGEdgeHasValue hv = (SMGEdgeHasValue)Iterables.getOnlyElement(pSmg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pSubobject).filterAtOffset(pDfo).filterWithoutSize()));
        Truth.assertThat((Comparable)hv.getValue()).isEqualTo((Object)pSublists[0][0]);
    }

    private SMGListAbstractionTestHelpers() {
    }
}

