/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.object.test;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListAbstractionTestHelpers;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListAbstractionTestInputs;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListCircularity;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.test.SMGListLinkage;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;

@RunWith(value=Parameterized.class)
public class SMGListsWithValuesTest {
    private static final String GLOBAL_LIST_POINTER_LABEL = "pointer";
    private static final MachineModel MACHINE_MODEL_FOR_TESTING = MachineModel.LINUX64;
    private static final int LEVEL_ZERO = 0;
    @Parameterized.Parameter(value=0)
    public SMGValue[][] testLists;
    @Parameterized.Parameter(value=1)
    public SMGListCircularity circularity;
    @Parameterized.Parameter(value=2)
    public SMGListLinkage linkage;
    private CLangSMG smg;
    private SMGState state;
    private SMGRegion globalListPointer;
    private int nodeSize;
    private int dfo;
    private SMGObjectKind listKind;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return SMGListAbstractionTestInputs.getListsWithSublistsAsTestInputs();
    }

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.smg = new CLangSMG(MACHINE_MODEL_FOR_TESTING);
        this.state = new SMGState(LogManager.createTestLogManager(), new SMGOptions(Configuration.defaultConfiguration()), this.smg, 0, PersistentBiMap.of());
        int intSize = 8 * MACHINE_MODEL_FOR_TESTING.getSizeofInt();
        int ptrSize = MACHINE_MODEL_FOR_TESTING.getSizeofPtrInBits();
        boolean hfo = false;
        boolean nfo = false;
        int pfo = this.linkage == SMGListLinkage.DOUBLY_LINKED ? ptrSize : -1;
        this.dfo = this.linkage == SMGListLinkage.DOUBLY_LINKED ? 2 * ptrSize : ptrSize;
        int dataSize = intSize;
        this.nodeSize = this.dfo + dataSize;
        this.listKind = this.linkage == SMGListLinkage.DOUBLY_LINKED ? SMGObjectKind.DLL : SMGObjectKind.SLL;
        SMGValue[] addresses = SMGListAbstractionTestHelpers.addLinkedListsWithValuesToHeap(this.smg, this.testLists, this.nodeSize, 0, 0, pfo, this.dfo, dataSize, this.circularity, this.linkage);
        this.globalListPointer = SMGListAbstractionTestHelpers.addGlobalListPointerToSMG(this.smg, addresses[0], GLOBAL_LIST_POINTER_LABEL);
        SMGObject segment = this.smg.getObjectPointedBy(addresses[0]);
        Truth.assertThat((Boolean)segment.isAbstract()).isTrue();
        Truth.assertThat((Comparable)((Object)segment.getKind())).isSameInstanceAs((Object)this.listKind);
        Truth.assertThat((Integer)segment.getLevel()).isEqualTo((Object)0);
        Truth.assertThat((Long)segment.getSize()).isEqualTo((Object)this.nodeSize);
    }

    @Test
    public void testAbstractionOfLinkedLists() throws SMGInconsistentException {
        SMGListAbstractionTestHelpers.executeHeapAbstractionWithConsistencyChecks(this.state, this.smg);
        SMGHasValueEdges hvs = this.smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(this.globalListPointer));
        Truth.assertThat((Iterable)hvs).hasSize(1);
        SMGEdgePointsTo pt = this.smg.getPointer(((SMGEdgeHasValue)Iterables.getOnlyElement((Iterable)hvs)).getValue());
        SMGObject abstractionResult = pt.getObject();
        int sumOfMinLengths = 0;
        for (SMGValue[] testList : this.testLists) {
            sumOfMinLengths += testList.length;
        }
        SMGListAbstractionTestHelpers.assertAbstractListSegmentAsExpected(abstractionResult, this.nodeSize, 0, this.listKind, sumOfMinLengths);
        SMGListAbstractionTestHelpers.assertStoredDataOfAbstractSublist(this.smg, this.testLists, abstractionResult, this.dfo);
    }
}

