/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.value;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public final class SMGAddress {
    public static final SMGAddress UNKNOWN = new SMGAddress(null, SMGUnknownValue.INSTANCE);
    public static final SMGAddress ZERO = new SMGAddress(SMGNullObject.INSTANCE, SMGZeroValue.INSTANCE);
    private final SMGObject object;
    private final SMGExplicitValue offset;

    SMGAddress(SMGObject pObject, SMGExplicitValue pOffset) {
        Preconditions.checkNotNull((Object)pOffset);
        this.object = pObject;
        this.offset = pOffset;
    }

    public boolean isUnknown() {
        return this.object == null || this.offset.isUnknown();
    }

    public SMGAddress add(SMGExplicitValue pAddedOffset) {
        if (this.object == null || this.offset.isUnknown() || pAddedOffset.isUnknown()) {
            return UNKNOWN;
        }
        return SMGAddress.valueOf(this.object, this.offset.add(pAddedOffset));
    }

    public SMGExplicitValue getOffset() {
        return this.offset;
    }

    public SMGObject getObject() {
        return this.object;
    }

    public static SMGAddress valueOf(SMGObject object, SMGExplicitValue offset) {
        return new SMGAddress(object, offset);
    }

    public String toString() {
        if (this.isUnknown()) {
            return "Unkown";
        }
        return "Object: " + this.object.getLabel() + " Offset: " + this.offset;
    }

    public int hashCode() {
        return Objects.hash(this.object, this.offset);
    }

    public boolean equals(Object o) {
        if (!(o instanceof SMGAddress)) {
            return false;
        }
        SMGAddress other = (SMGAddress)o;
        return Objects.equals(this.object, other.object) && Objects.equals(this.offset, other.offset);
    }

    public static SMGAddress valueOf(SMGObject pObj, int pOffset) {
        return new SMGAddress(pObj, SMGKnownExpValue.valueOf(pOffset));
    }
}

