/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.value;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddress;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGAddressValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public final class SMGKnownAddressValue
extends SMGKnownSymValue
implements SMGAddressValue {
    private final SMGAddress address;

    private SMGKnownAddressValue(BigInteger pValue, SMGAddress pAddress) {
        super(pValue);
        Preconditions.checkNotNull((Object)pAddress);
        this.address = pAddress;
    }

    public static SMGAddressValue valueOf(SMGKnownSymbolicValue pAddress, SMGObject pObject, SMGKnownExpValue pOffset) {
        if (pAddress.isZero() && pObject.equals(SMGNullObject.INSTANCE) && pOffset.isZero()) {
            return SMGZeroValue.INSTANCE;
        }
        if (pAddress.isUnknown() || pObject == null) {
            return SMGUnknownValue.INSTANCE;
        }
        return new SMGKnownAddressValue(pAddress.getId(), SMGAddress.valueOf(pObject, pOffset));
    }

    public static SMGAddressValue valueOf(SMGEdgePointsTo edge) {
        if (edge.getValue().isZero() && edge.getObject().equals(SMGNullObject.INSTANCE) && edge.getOffset() == 0L) {
            return SMGZeroValue.INSTANCE;
        }
        if (edge.getValue().isUnknown() || edge.getObject() == null) {
            return SMGUnknownValue.INSTANCE;
        }
        return new SMGKnownAddressValue(((SMGSymbolicValue)edge.getValue()).getId(), SMGAddress.valueOf(edge.getObject(), SMGKnownExpValue.valueOf(edge.getOffset())));
    }

    @Override
    public SMGAddress getAddress() {
        return this.address;
    }

    @Override
    public String toString() {
        return super.toString() + " with address <" + this.address + ">";
    }

    @Override
    public SMGKnownExpValue getOffset() {
        return (SMGKnownExpValue)this.address.getOffset();
    }

    @Override
    public SMGObject getObject() {
        return this.address.getObject();
    }
}

