/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.value;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public class SMGKnownExpValue
extends SMGKnownValue
implements SMGExplicitValue {
    protected SMGKnownExpValue(BigInteger pValue) {
        super(pValue);
    }

    @Override
    public BigInteger getValue() {
        return super.getValue();
    }

    @Override
    public final int getAsInt() {
        return this.getValue().intValue();
    }

    @Override
    public final long getAsLong() {
        return this.getValue().longValue();
    }

    @Override
    public boolean equals(Object pObj) {
        return pObj instanceof SMGKnownExpValue && super.equals(pObj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public SMGExplicitValue negate() {
        return SMGKnownExpValue.valueOf(this.getValue().negate());
    }

    @Override
    public SMGExplicitValue xor(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().xor(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue or(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().or(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue and(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().and(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue shiftLeft(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().shiftLeft(pRVal.getValue().intValue()));
    }

    @Override
    public SMGExplicitValue multiply(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().multiply(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue divide(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().divide(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue subtract(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().subtract(pRVal.getValue()));
    }

    @Override
    public SMGExplicitValue add(SMGExplicitValue pRVal) {
        if (pRVal.isUnknown()) {
            return SMGUnknownValue.INSTANCE;
        }
        return SMGKnownExpValue.valueOf(this.getValue().add(pRVal.getValue()));
    }

    public static SMGKnownExpValue valueOf(int pValue) {
        return SMGKnownExpValue.valueOf(BigInteger.valueOf(pValue));
    }

    public static SMGKnownExpValue valueOf(long pValue) {
        return SMGKnownExpValue.valueOf(BigInteger.valueOf(pValue));
    }

    public static SMGKnownExpValue valueOf(BigInteger pValue) {
        Preconditions.checkNotNull((Object)pValue);
        if (pValue.equals(BigInteger.ZERO)) {
            return SMGZeroValue.INSTANCE;
        }
        return new SMGKnownExpValue(pValue);
    }

    @Override
    public String asDotId() {
        return this.getValue().toString();
    }

    @Override
    public String toString() {
        return "Exp_" + super.toString();
    }
}

