/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.value;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.math.BigInteger;
import org.sosy_lab.common.UniqueIdGenerator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public class SMGKnownSymValue
extends SMGKnownValue
implements SMGKnownSymbolicValue {
    public static final SMGKnownSymValue TRUE = new SMGKnownSymValue(BigInteger.valueOf(-1L));
    private static final UniqueIdGenerator idGenerator = new UniqueIdGenerator();

    SMGKnownSymValue(BigInteger pValue) {
        super(pValue);
    }

    public static SMGKnownSymbolicValue of() {
        return SMGKnownSymValue.valueOf(idGenerator.getFreshId() + 1);
    }

    @VisibleForTesting
    public static SMGKnownSymbolicValue valueOf(int pValue) {
        return SMGKnownSymValue.valueOf(BigInteger.valueOf(pValue));
    }

    private static SMGKnownSymbolicValue valueOf(BigInteger pValue) {
        Preconditions.checkNotNull((Object)pValue);
        if (pValue.equals(BigInteger.ZERO)) {
            return SMGZeroValue.INSTANCE;
        }
        return new SMGKnownSymValue(pValue);
    }

    @Override
    public final boolean equals(Object pObj) {
        return pObj instanceof SMGKnownSymValue && super.equals(pObj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String asDotId() {
        return "Sym" + this.getValue();
    }

    @Override
    public BigInteger getId() {
        return this.getValue();
    }

    @Override
    public String toString() {
        return "Sym_" + super.toString();
    }
}

