/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.graphs.value;

import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGExplicitValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGUnknownValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;

public interface SMGValue
extends Comparable<SMGValue> {
    @Override
    default public int compareTo(SMGValue other) {
        if (this.isUnknown()) {
            return other.isUnknown() ? 0 : -1;
        }
        if (this.isZero()) {
            if (other.isUnknown()) {
                return 1;
            }
            if (other.isZero()) {
                return 0;
            }
            return -1;
        }
        if (this instanceof SMGExplicitValue) {
            if (other.isUnknown() || other.isZero()) {
                return 1;
            }
            if (other instanceof SMGExplicitValue) {
                return ((SMGExplicitValue)this).getValue().compareTo(((SMGExplicitValue)other).getValue());
            }
            return -1;
        }
        if (this instanceof SMGSymbolicValue) {
            if (other.isUnknown() || other.isZero() || !(other instanceof SMGSymbolicValue)) {
                return 1;
            }
            return ((SMGSymbolicValue)this).getId().compareTo(((SMGSymbolicValue)other).getId());
        }
        throw new AssertionError((Object)String.format("unexpected comparison of '%s' and '%s'", this, other));
    }

    default public boolean isZero() {
        return SMGZeroValue.INSTANCE == this;
    }

    default public boolean isUnknown() {
        return SMGUnknownValue.INSTANCE == this;
    }

    public String asDotId();
}

