/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import org.sosy_lab.common.collect.PersistentMap;
import org.sosy_lab.cpachecker.cfa.types.c.CVoidType;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;
import org.sosy_lab.cpachecker.util.statistics.ThreadSafeTimerContainer;

public class SMGIsLessOrEqual {
    public static final ThreadSafeTimerContainer isLEQTimer = new ThreadSafeTimerContainer("Time for joining SMGs");
    public static final ThreadSafeTimerContainer globalsTimer = new ThreadSafeTimerContainer("Time for joining globals");
    public static final ThreadSafeTimerContainer stackTimer = new ThreadSafeTimerContainer("Time for joining stacks");
    public static final ThreadSafeTimerContainer heapTimer = new ThreadSafeTimerContainer("Time for joining heaps");

    private SMGIsLessOrEqual() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLessOrEqual(UnmodifiableCLangSMG pSMG1, UnmodifiableCLangSMG pSMG2) {
        ThreadSafeTimerContainer.TimerWrapper timer = isLEQTimer.getNewTimer();
        timer.start();
        try {
            if (pSMG1 == pSMG2) {
                boolean bl = true;
                return bl;
            }
            if (pSMG1.getHeapObjects().size() != pSMG2.getHeapObjects().size()) {
                boolean bl = false;
                return bl;
            }
            if (pSMG1.getStackFrames().size() != pSMG2.getStackFrames().size()) {
                boolean bl = false;
                return bl;
            }
            ThreadSafeTimerContainer.TimerWrapper gt = globalsTimer.getNewTimer();
            gt.start();
            try {
                if (!SMGIsLessOrEqual.maybeGlobalsLessOrEqual(pSMG1, pSMG2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                gt.stop();
            }
            ThreadSafeTimerContainer.TimerWrapper st = stackTimer.getNewTimer();
            st.start();
            try {
                if (!SMGIsLessOrEqual.maybeStackLessOrEqual(pSMG1, pSMG2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                st.stop();
            }
            ThreadSafeTimerContainer.TimerWrapper ht = heapTimer.getNewTimer();
            ht.start();
            try {
                if (!SMGIsLessOrEqual.maybeHeapLessOrEqual(pSMG1, pSMG2)) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                ht.stop();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            timer.stop();
        }
    }

    private static boolean maybeGlobalsLessOrEqual(UnmodifiableCLangSMG pSMG1, UnmodifiableCLangSMG pSMG2) {
        PersistentMap<String, SMGRegion> globals_in_smg1 = pSMG1.getGlobalObjects();
        PersistentMap<String, SMGRegion> globals_in_smg2 = pSMG2.getGlobalObjects();
        if (globals_in_smg1.size() > globals_in_smg2.size()) {
            return false;
        }
        for (Map.Entry entry : globals_in_smg1.entrySet()) {
            SMGObject globalInSMG1 = (SMGObject)entry.getValue();
            String globalVar = (String)entry.getKey();
            if (!globals_in_smg2.containsKey(globalVar)) {
                return false;
            }
            SMGObject globalInSMG2 = (SMGObject)globals_in_smg2.get(entry.getKey());
            if (SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, globalInSMG1, globalInSMG2)) continue;
            return false;
        }
        return true;
    }

    private static boolean maybeStackLessOrEqual(UnmodifiableCLangSMG pSMG1, UnmodifiableCLangSMG pSMG2) {
        Iterator<CLangStackFrame> smg1stackIterator = pSMG1.getStackFrames().iterator();
        Iterator<CLangStackFrame> smg2stackIterator = pSMG2.getStackFrames().iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            CLangStackFrame frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame frameInSMG2 = smg2stackIterator.next();
            if (!frameInSMG1.getFunctionDeclaration().getOrigName().equals(frameInSMG2.getFunctionDeclaration().getOrigName())) {
                return false;
            }
            if (frameInSMG1.getAllObjects().size() > frameInSMG2.getAllObjects().size()) {
                return false;
            }
            if (!(frameInSMG1.getFunctionDeclaration().getType().getReturnType().getCanonicalType() instanceof CVoidType) && !SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, frameInSMG1.getReturnObject(), frameInSMG2.getReturnObject())) {
                return false;
            }
            for (String localVar : frameInSMG1.getVariables().keySet()) {
                SMGRegion localInSMG2;
                if (!frameInSMG2.containsVariable(localVar)) {
                    return false;
                }
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                if (SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, localInSMG1, localInSMG2 = frameInSMG2.getVariable(localVar))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean maybeHeapLessOrEqual(UnmodifiableCLangSMG pSMG1, UnmodifiableCLangSMG pSMG2) {
        PersistentSet<SMGObject> heap_in_smg1 = pSMG1.getHeapObjects();
        PersistentSet<SMGObject> heap_in_smg2 = pSMG2.getHeapObjects();
        for (SMGObject object_in_smg1 : heap_in_smg1) {
            if (!heap_in_smg2.contains(object_in_smg1)) {
                return false;
            }
            if (!SMGIsLessOrEqual.isLessOrEqualFields(pSMG1, pSMG2, object_in_smg1, object_in_smg1)) {
                return false;
            }
            if (pSMG1.isObjectValid(object_in_smg1) == pSMG2.isObjectValid(object_in_smg1)) continue;
            return false;
        }
        return true;
    }

    private static boolean isLessOrEqualFields(UnmodifiableCLangSMG pSMG1, UnmodifiableCLangSMG pSMG2, SMGObject pSMGObject1, SMGObject pSMGObject2) {
        Preconditions.checkArgument((pSMGObject1.getSize() == pSMGObject2.getSize() ? 1 : 0) != 0, (Object)"SMGJoinFields object arguments need to have identical size");
        Preconditions.checkArgument((pSMG1.getObjects().contains(pSMGObject1) && pSMG2.getObjects().contains(pSMGObject2) ? 1 : 0) != 0, (Object)"SMGJoinFields object arguments need to be included in parameter SMGs");
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterForSMG1 = SMGEdgeHasValueFilter.objectFilter(pSMGObject1);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterForSMG2 = SMGEdgeHasValueFilter.objectFilter(pSMGObject2);
        SMGHasValueEdges HVE2 = pSMG2.getHVEdges(filterForSMG2);
        for (SMGEdgeHasValue edge1 : pSMG1.getHVEdges(filterForSMG1)) {
            long offset2;
            if (!HVE2.filter(filterForSMG2.filterAtOffset(edge1.getOffset()).filterBySize(edge1.getSizeInBits()).filterHavingValue(edge1.getValue())).iterator().hasNext()) {
                return false;
            }
            SMGValue value = edge1.getValue();
            if (!pSMG1.isPointer(value)) continue;
            if (!pSMG2.isPointer(value)) {
                return false;
            }
            SMGEdgePointsTo ptE1 = pSMG1.getPointer(value);
            SMGEdgePointsTo ptE2 = pSMG2.getPointer(value);
            String label1 = ptE1.getObject().getLabel();
            String label2 = ptE2.getObject().getLabel();
            long offset1 = ptE1.getOffset();
            if (offset1 == (offset2 = ptE2.getOffset()) && label1.equals(label2)) continue;
            return false;
        }
        return true;
    }
}

