/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGs;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentStack;

public final class SMGJoin {
    private boolean defined = false;
    private SMGJoinStatus status = SMGJoinStatus.EQUAL;
    private final CLangSMG smg;
    private final SMGNodeMapping mapping1 = new SMGNodeMapping();
    private final SMGNodeMapping mapping2 = new SMGNodeMapping();
    final SMGLevelMapping levelMap = SMGLevelMapping.createDefaultLevelMap();
    private PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> mergedExplicitValues = PersistentBiMap.of();

    public SMGJoin(UnmodifiableCLangSMG opSMG1, UnmodifiableCLangSMG opSMG2, UnmodifiableSMGState pStateOfSmg1, UnmodifiableSMGState pStateOfSmg2) throws SMGInconsistentException {
        this.smg = new CLangSMG(opSMG1.getMachineModel());
        SMGJoinStatus tmpStatus1 = this.joinGlobalVariables((Map<String, SMGRegion>)opSMG1.getGlobalObjects(), (Map<String, SMGRegion>)opSMG2.getGlobalObjects());
        this.status = this.status.updateWith(tmpStatus1);
        SMGJoinStatus tmpStatus2 = this.joinStackVariables(opSMG1.getStackFrames(), opSMG2.getStackFrames());
        this.status = this.status.updateWith(tmpStatus2);
        for (Map.Entry entry : this.smg.getGlobalObjects().entrySet()) {
            SMGObject globalInSMG1 = (SMGObject)opSMG1.getGlobalObjects().get(entry.getKey());
            SMGObject globalInSMG2 = (SMGObject)opSMG2.getGlobalObjects().get(entry.getKey());
            SMGObject destinationGlobal = this.mapping1.get(globalInSMG1);
            SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, this.mapping1, this.mapping2, this.levelMap, globalInSMG1, globalInSMG2, destinationGlobal, 0, false, pStateOfSmg1, pStateOfSmg2);
            this.status = jss.getStatus();
            if (jss.isDefined()) continue;
            return;
        }
        Iterator<CLangStackFrame> smg1stackIterator = opSMG1.getStackFrames().iterator();
        Iterator<CLangStackFrame> smg2stackIterator = opSMG2.getStackFrames().iterator();
        Iterator<CLangStackFrame> destSmgStackIterator = this.smg.getStackFrames().iterator();
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            CLangStackFrame frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame frameInSMG2 = smg2stackIterator.next();
            CLangStackFrame destStackFrame = destSmgStackIterator.next();
            for (String localVar : destStackFrame.getVariables().keySet()) {
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                SMGRegion localInSMG2 = frameInSMG2.getVariable(localVar);
                SMGObject destinationLocal = this.mapping1.get(localInSMG1);
                SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, this.mapping1, this.mapping2, this.levelMap, localInSMG1, localInSMG2, destinationLocal, 0, false, pStateOfSmg1, pStateOfSmg2);
                this.status = jss.getStatus();
                if (jss.isDefined()) continue;
                return;
            }
            if (frameInSMG1.getReturnObject() == null) continue;
            SMGRegion returnObjectInSmg1 = frameInSMG1.getReturnObject();
            SMGRegion returnObjectInSmg2 = frameInSMG2.getReturnObject();
            SMGRegion destinationLocal = destStackFrame.getReturnObject();
            this.mapping1.map(returnObjectInSmg1, destinationLocal);
            this.mapping2.map(returnObjectInSmg2, destinationLocal);
            SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, opSMG1, opSMG2, this.smg, this.mapping1, this.mapping2, this.levelMap, returnObjectInSmg1, returnObjectInSmg2, destinationLocal, 0, false, pStateOfSmg1, pStateOfSmg2);
            this.status = jss.getStatus();
            if (jss.isDefined()) continue;
            return;
        }
        this.defined = true;
        for (Map.Entry<SMGKnownSymbolicValue, SMGKnownExpValue> entry : pStateOfSmg1.getExplicitValues()) {
            SMGKnownSymbolicValue value1 = (SMGKnownSymbolicValue)this.mapping1.get(entry.getKey());
            if (value1 != null) {
                this.mergedExplicitValues = this.mergedExplicitValues.putAndCopy(value1, entry.getValue());
                continue;
            }
            this.mergedExplicitValues = this.mergedExplicitValues.putAndCopy(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<SMGKnownSymbolicValue, SMGKnownExpValue> entry : pStateOfSmg2.getExplicitValues()) {
            SMGKnownSymbolicValue value1;
            SMGKnownSymbolicValue value2 = (SMGKnownSymbolicValue)this.mapping2.get(entry.getKey());
            if (value2 == null) {
                value2 = entry.getKey();
            }
            if ((value1 = this.mergedExplicitValues.inverse().get(entry.getValue())) != null && !value1.equals(value2)) {
                this.mergedExplicitValues = this.mergedExplicitValues.removeAndCopy(value1);
                continue;
            }
            if (this.mergedExplicitValues.containsKey(value2) && !this.mergedExplicitValues.get(value2).equals(entry.getValue())) {
                this.mergedExplicitValues = this.mergedExplicitValues.removeAndCopy(value2);
                continue;
            }
            this.mergedExplicitValues = this.mergedExplicitValues.putAndCopy(value2, entry.getValue());
        }
    }

    private SMGJoinStatus joinGlobalVariables(Map<String, SMGRegion> globals_in_smg1, Map<String, SMGRegion> globals_in_smg2) {
        Set<String> globals1 = globals_in_smg1.keySet();
        Set<String> globals2 = globals_in_smg2.keySet();
        for (String globalVar : Sets.intersection(globals1, globals2)) {
            SMGRegion globalInSMG1 = globals_in_smg1.get(globalVar);
            SMGRegion globalInSMG2 = globals_in_smg2.get(globalVar);
            this.smg.addGlobalObject(globalInSMG1);
            this.mapping1.map(globalInSMG1, globalInSMG1);
            this.mapping2.map(globalInSMG2, globalInSMG1);
        }
        return SMGJoin.getFlag(globals1.containsAll(globals2), globals2.containsAll(globals1));
    }

    private static SMGJoinStatus getFlag(boolean oneInTwo, boolean twoInOne) {
        if (oneInTwo) {
            return twoInOne ? SMGJoinStatus.EQUAL : SMGJoinStatus.LEFT_ENTAIL;
        }
        return twoInOne ? SMGJoinStatus.RIGHT_ENTAIL : SMGJoinStatus.INCOMPARABLE;
    }

    private SMGJoinStatus joinStackVariables(PersistentStack<CLangStackFrame> stack1, PersistentStack<CLangStackFrame> stack2) {
        Iterator<CLangStackFrame> smg1stackIterator = stack1.iterator();
        Iterator<CLangStackFrame> smg2stackIterator = stack2.iterator();
        SMGJoinStatus result = SMGJoinStatus.EQUAL;
        while (smg1stackIterator.hasNext() && smg2stackIterator.hasNext()) {
            CLangStackFrame frameInSMG1 = smg1stackIterator.next();
            CLangStackFrame frameInSMG2 = smg2stackIterator.next();
            if (!frameInSMG1.getFunctionDeclaration().equals(frameInSMG2.getFunctionDeclaration())) {
                return SMGJoinStatus.INCOMPARABLE;
            }
            this.smg.addStackFrame(frameInSMG1.getFunctionDeclaration());
            Set<String> locals1 = frameInSMG1.getVariables().keySet();
            Set<String> locals2 = frameInSMG2.getVariables().keySet();
            for (String localVar : Sets.intersection(locals1, locals2)) {
                SMGRegion localInSMG1 = frameInSMG1.getVariable(localVar);
                SMGRegion localInSMG2 = frameInSMG2.getVariable(localVar);
                this.smg.addStackObject(localInSMG1);
                this.mapping1.map(localInSMG1, localInSMG1);
                this.mapping2.map(localInSMG2, localInSMG1);
            }
            result = this.status.updateWith(SMGJoin.getFlag(locals1.containsAll(locals2), locals2.containsAll(locals1)));
        }
        return result;
    }

    public boolean isDefined() {
        if (!this.defined) {
            Preconditions.checkState((this.status == SMGJoinStatus.INCOMPARABLE ? 1 : 0) != 0, (String)"Join of SMGs not defined, but status is %s", (Object)((Object)this.status));
        }
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public CLangSMG getJointSMG() {
        return this.smg;
    }

    public PersistentBiMap<SMGKnownSymbolicValue, SMGKnownExpValue> getMergedExplicitValues() {
        return this.mergedExplicitValues;
    }
}

