/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidateTemplate;
import org.sosy_lab.cpachecker.util.Pair;
import org.sosy_lab.cpachecker.util.Triple;

public class SMGJoinAbstractionManager {
    private final MachineModel machineModel;
    private final SMGObject smgObject1;
    private final SMGObject smgObject2;
    private final SMGObject destObject;
    private final UnmodifiableSMG inputSMG1;
    private final UnmodifiableSMG inputSMG2;
    private final UnmodifiableSMG destSMG;

    public SMGJoinAbstractionManager(MachineModel pMachineModel, SMGObject pRootInSMG1, SMGObject pRootInSMG2, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, SMGObject pDestObject, UnmodifiableSMG pDestSMG) {
        this.machineModel = pMachineModel;
        this.smgObject1 = pRootInSMG1;
        this.smgObject2 = pRootInSMG2;
        this.inputSMG1 = pInputSMG1;
        this.inputSMG2 = pInputSMG2;
        this.destObject = pDestObject;
        this.destSMG = pDestSMG;
    }

    public List<SMGAbstractionCandidate> calculateCandidates() {
        ImmutableMap empty = ImmutableMap.of();
        return this.calculateCandidates((Map<Integer, List<SMGAbstractionCandidate>>)empty);
    }

    public List<SMGAbstractionCandidate> calculateCandidates(Map<Integer, List<SMGAbstractionCandidate>> alreadyFoundCandidates) {
        Optional<GenericAbstractionCandidateTemplate> templateAbstraction = this.calculateTemplateAbstraction(alreadyFoundCandidates);
        if (!templateAbstraction.isPresent()) {
            return ImmutableList.of();
        }
        return ImmutableList.of();
    }

    private Optional<GenericAbstractionCandidateTemplate> calculateTemplateAbstraction(Map<Integer, List<SMGAbstractionCandidate>> pAlreadyFoundCandidates) {
        if (this.destObject instanceof GenericAbstraction) {
            GenericAbstractionCandidateTemplate template = ((GenericAbstraction)this.destObject).createCandidateTemplate(this.machineModel);
            return Optional.of(template);
        }
        if (pAlreadyFoundCandidates.isEmpty()) {
            return this.calculateSimpleTemplateAbstractionFromObject();
        }
        return this.calculateTemplateAbstractionFromAlreadyFoundAbstractions(pAlreadyFoundCandidates);
    }

    private Optional<GenericAbstractionCandidateTemplate> calculateSimpleTemplateAbstractionFromObject() {
        if (!(this.destObject instanceof SMGRegion)) {
            return Optional.empty();
        }
        SMGRegion root = (SMGRegion)this.destObject;
        SMGHasValueEdges fieldsOfObject1 = SMGUtils.getFieldsOfObject(this.smgObject1, this.inputSMG1);
        SMGHasValueEdges fieldsOfObject2 = SMGUtils.getFieldsOfObject(this.smgObject2, this.inputSMG2);
        Triple<Set<Pair<SMGEdgeHasValue, SMGEdgeHasValue>>, Set<SMGEdgeHasValue>, Set<SMGEdgeHasValue>> sharedPnonSharedPsharedNP = this.assignToSharedPPointerAndNonSharedOPointerAndSharedNonPointer(fieldsOfObject1, fieldsOfObject2);
        Set<SMGEdgePointsTo> inboundPointers1 = SMGUtils.getPointerToThisObject(this.smgObject1, this.inputSMG1);
        Set<SMGEdgePointsTo> inboundPointers2 = SMGUtils.getPointerToThisObject(this.smgObject2, this.inputSMG2);
        Pair<Set<Pair<SMGEdgePointsTo, SMGEdgePointsTo>>, Set<SMGEdgePointsTo>> sharedIPointerNonSharedIP = this.assignToSharedIPointerAndNonSharedIPointer(inboundPointers1, inboundPointers2);
        Set<SMGEdgeHasValue> sharedFields = sharedPnonSharedPsharedNP.getThird();
        Set<Pair<SMGEdgeHasValue, SMGEdgeHasValue>> sharedOPointer = sharedPnonSharedPsharedNP.getFirst();
        Set<SMGEdgeHasValue> nonSharedOPointer = sharedPnonSharedPsharedNP.getSecond();
        Set<Pair<SMGEdgePointsTo, SMGEdgePointsTo>> sharedIPointer = sharedIPointerNonSharedIP.getFirst();
        Set<SMGEdgePointsTo> nonSharedIPointer = sharedIPointerNonSharedIP.getSecond();
        if (!nonSharedIPointer.isEmpty()) {
            return Optional.empty();
        }
        GenericAbstractionCandidateTemplate result = GenericAbstractionCandidateTemplate.createSimpleInductiveGenericAbstractionTemplate(this.machineModel, sharedFields, sharedIPointer, sharedOPointer, nonSharedOPointer, root);
        return Optional.of(result);
    }

    private Pair<Set<Pair<SMGEdgePointsTo, SMGEdgePointsTo>>, Set<SMGEdgePointsTo>> assignToSharedIPointerAndNonSharedIPointer(Set<SMGEdgePointsTo> pInboundPointers1, Set<SMGEdgePointsTo> pInboundPointers2) {
        ImmutableMap offsetToPte1Map = Maps.uniqueIndex(pInboundPointers1, SMGEdge::getOffset);
        ImmutableMap offsetToPte2Map = Maps.uniqueIndex(pInboundPointers2, SMGEdge::getOffset);
        HashSet offsets = new HashSet(offsetToPte1Map.keySet());
        offsets.addAll(offsetToPte2Map.keySet());
        HashSet<Pair<SMGEdgePointsTo, SMGEdgePointsTo>> sharedIPointer = new HashSet<Pair<SMGEdgePointsTo, SMGEdgePointsTo>>();
        HashSet<SMGEdgePointsTo> nonSharedIPointer = new HashSet<SMGEdgePointsTo>();
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            SMGEdgePointsTo pte1;
            long offset = (Long)iterator.next();
            if (offsetToPte1Map.containsKey(offset) && offsetToPte2Map.containsKey(offset)) {
                pte1 = (SMGEdgePointsTo)offsetToPte1Map.get(offset);
                SMGEdgePointsTo pte2 = (SMGEdgePointsTo)offsetToPte2Map.get(offset);
                sharedIPointer.add(Pair.of(pte1, pte2));
                continue;
            }
            if (offsetToPte1Map.containsKey(offset)) {
                pte1 = (SMGEdgePointsTo)offsetToPte1Map.get(offset);
                nonSharedIPointer.add(pte1);
                continue;
            }
            SMGEdgePointsTo pte2 = (SMGEdgePointsTo)offsetToPte2Map.get(offset);
            nonSharedIPointer.add(pte2);
        }
        return Pair.of(sharedIPointer, nonSharedIPointer);
    }

    private Triple<Set<Pair<SMGEdgeHasValue, SMGEdgeHasValue>>, Set<SMGEdgeHasValue>, Set<SMGEdgeHasValue>> assignToSharedPPointerAndNonSharedOPointerAndSharedNonPointer(SMGHasValueEdges pFieldsOfObject1, SMGHasValueEdges pFieldsOfObject2) {
        HashSet<Pair<SMGEdgeHasValue, SMGEdgeHasValue>> sharedOPointer = new HashSet<Pair<SMGEdgeHasValue, SMGEdgeHasValue>>();
        HashSet<SMGEdgeHasValue> nonSharedOPointer = new HashSet<SMGEdgeHasValue>();
        HashSet<SMGEdgeHasValue> sharedNonPointer = new HashSet<SMGEdgeHasValue>();
        ImmutableMap offsetToHve1Map = Maps.uniqueIndex((Iterable)pFieldsOfObject1, SMGEdge::getOffset);
        ImmutableMap offsetToHve2Map = Maps.uniqueIndex((Iterable)pFieldsOfObject2, SMGEdge::getOffset);
        HashSet offsets = new HashSet(offsetToHve1Map.keySet());
        offsets.addAll(offsetToHve2Map.keySet());
        Iterator iterator = offsets.iterator();
        while (iterator.hasNext()) {
            SMGEdgeHasValue hve;
            long offset = (Long)iterator.next();
            if (offsetToHve1Map.containsKey(offset) && offsetToHve2Map.containsKey(offset)) {
                SMGEdgeHasValue hve1 = (SMGEdgeHasValue)offsetToHve1Map.get(offset);
                SMGEdgeHasValue hve2 = (SMGEdgeHasValue)offsetToHve2Map.get(offset);
                if (this.inputSMG1.isPointer(hve1.getValue()) && this.inputSMG2.isPointer(hve2.getValue())) {
                    sharedOPointer.add(Pair.of(hve1, hve2));
                    continue;
                }
                if (this.inputSMG1.isPointer(hve1.getValue())) {
                    nonSharedOPointer.add(hve1);
                    continue;
                }
                if (this.inputSMG2.isPointer(hve2.getValue())) {
                    nonSharedOPointer.add(hve2);
                    continue;
                }
                sharedNonPointer.add(hve1);
                continue;
            }
            if (offsetToHve1Map.containsKey(offset)) {
                hve = (SMGEdgeHasValue)offsetToHve1Map.get(offset);
                if (!this.inputSMG1.isPointer(hve.getValue())) continue;
                nonSharedOPointer.add(hve);
                continue;
            }
            hve = (SMGEdgeHasValue)offsetToHve2Map.get(offset);
            if (!this.inputSMG2.isPointer(hve.getValue())) continue;
            nonSharedOPointer.add(hve);
        }
        return Triple.of(sharedOPointer, nonSharedOPointer, sharedNonPointer);
    }

    private Optional<GenericAbstractionCandidateTemplate> calculateTemplateAbstractionFromAlreadyFoundAbstractions(Map<Integer, List<SMGAbstractionCandidate>> pAlreadyFoundCandidates) {
        SMGAbstractionCandidate template = pAlreadyFoundCandidates.values().iterator().next().iterator().next();
        if (template instanceof GenericAbstractionCandidate) {
            return Optional.of(((GenericAbstractionCandidate)((Object)template)).createTemplate(this.machineModel));
        }
        return Optional.empty();
    }
}

