/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdgeSet;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;

class SMGJoinFields {
    private final SMG newSMG1;
    private final SMG newSMG2;
    private SMGJoinStatus status = SMGJoinStatus.EQUAL;

    public SMGJoinFields(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) {
        Preconditions.checkArgument((pObj1.getSize() == pObj2.getSize() ? 1 : 0) != 0, (Object)"SMGJoinFields object arguments need to have identical size");
        Preconditions.checkArgument((pSMG1.getObjects().contains(pObj1) && pSMG2.getObjects().contains(pObj2) ? 1 : 0) != 0, (Object)"SMGJoinFields object arguments need to be included in parameter SMGs");
        this.newSMG1 = pSMG1.copyOf();
        this.newSMG2 = pSMG2.copyOf();
        SMGJoinFields.setCompatibleHVEdgesToSMG(this.newSMG1, pSMG2, pObj1, pObj2);
        SMGJoinFields.setCompatibleHVEdgesToSMG(this.newSMG2, pSMG1, pObj2, pObj1);
        this.joinFieldsRelaxStatus(pSMG1, this.newSMG1, SMGJoinStatus.LEFT_ENTAIL, pObj1);
        this.joinFieldsRelaxStatus(pSMG2, this.newSMG2, SMGJoinStatus.RIGHT_ENTAIL, pObj2);
        SMGHasValueEdges smg2Extension = SMGJoinFields.mergeNonNullHasValueEdges(pSMG1, this.newSMG2, pObj1, pObj2);
        SMGHasValueEdges smg1Extension = SMGJoinFields.mergeNonNullHasValueEdges(pSMG2, this.newSMG1, pObj2, pObj1);
        for (SMGEdgeHasValue edge : smg1Extension) {
            this.newSMG1.addValue(edge.getValue());
            this.newSMG1.addHasValueEdge(edge);
        }
        for (SMGEdgeHasValue edge : smg2Extension) {
            this.newSMG2.addValue(edge.getValue());
            this.newSMG2.addHasValueEdge(edge);
        }
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public UnmodifiableSMG getSMG1() {
        return this.newSMG1;
    }

    public UnmodifiableSMG getSMG2() {
        return this.newSMG2;
    }

    @VisibleForTesting
    public static SMGHasValueEdges mergeNonNullHasValueEdges(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) {
        SMGHasValueEdges returnSet = new SMGHasValueEdgeSet();
        if (pSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1)).equals(pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2)))) {
            return returnSet;
        }
        SMGEdgeHasValueFilter filterForSMG1 = SMGEdgeHasValueFilter.objectFilter(pObj1).filterNotHavingValue(SMGZeroValue.INSTANCE);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterForSMG2 = SMGEdgeHasValueFilter.objectFilter(pObj2);
        for (SMGEdgeHasValue edge : pSMG1.getHVEdges(filterForSMG1)) {
            if (pSMG2.getHVEdges(filterForSMG2.overlapsWith(new SMGEdgeHasValue(edge.getSizeInBits(), edge.getOffset(), pObj2, edge.getValue()))).iterator().hasNext()) continue;
            returnSet = returnSet.addEdgeAndCopy(new SMGEdgeHasValue(edge.getSizeInBits(), edge.getOffset(), pObj2, (SMGValue)SMGKnownSymValue.of()));
        }
        return returnSet;
    }

    @VisibleForTesting
    void joinFieldsRelaxStatus(UnmodifiableSMG pOrigSMG, UnmodifiableSMG pNewSMG, SMGJoinStatus pNewStatus, SMGObject pObject) {
        TreeMap<Long, Long> origNullBlocks = pOrigSMG.getNullEdgesMapOffsetToSizeForObject(pObject);
        TreeMap<Long, Long> newNullBlocks = pNewSMG.getNullEdgesMapOffsetToSizeForObject(pObject);
        for (Map.Entry<Long, Long> origEdge : origNullBlocks.entrySet()) {
            Long newNullBlock = newNullBlocks.get(origEdge.getKey());
            if (newNullBlock != null && newNullBlock.longValue() == origEdge.getValue().longValue()) continue;
            Preconditions.checkState((newNullBlock == null || newNullBlock < origEdge.getValue() ? 1 : 0) != 0);
            this.status = this.status.updateWith(pNewStatus);
        }
    }

    @VisibleForTesting
    static void setCompatibleHVEdgesToSMG(SMG pSMG, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) {
        if (pSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1)).equals(pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2)))) {
            return;
        }
        SMGEdgeHasValueFilter nullValueFilter = SMGEdgeHasValueFilter.objectFilter(pObj1).filterHavingValue(SMGZeroValue.INSTANCE).filterWithoutSize();
        Iterable<SMGEdgeHasValue> edgesToRemove = pSMG.getHVEdges(nullValueFilter);
        Set<SMGEdgeHasValue> edgesToAdd1 = SMGJoinFields.getHVSetOfCommonNullValues(pSMG, pSMG2, pObj1, pObj2);
        Set<SMGEdgeHasValue> edgesToAdd2 = SMGJoinFields.getHVSetOfMissingNullValues(pSMG, pSMG2, pObj1, pObj2);
        for (SMGEdgeHasValue edge : edgesToRemove) {
            pSMG.removeHasValueEdge(edge);
        }
        for (SMGEdgeHasValue edge : edgesToAdd1) {
            pSMG.addHasValueEdge(edge);
        }
        for (SMGEdgeHasValue edge : edgesToAdd2) {
            pSMG.addHasValueEdge(edge);
        }
    }

    @VisibleForTesting
    static Set<SMGEdgeHasValue> getHVSetOfMissingNullValues(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) {
        LinkedHashSet<SMGEdgeHasValue> retset = new LinkedHashSet<SMGEdgeHasValue>();
        SMGEdgeHasValueFilter nonNullPtrInSmg2 = SMGEdgeHasValueFilter.objectFilter(pObj2).filterNotHavingValue(SMGZeroValue.INSTANCE);
        SMGEdgeHasValueFilter nonNullPtrInSmg1 = SMGEdgeHasValueFilter.objectFilter(pObj1).filterNotHavingValue(SMGZeroValue.INSTANCE);
        for (SMGEdgeHasValue edge : pSMG2.getHVEdges(nonNullPtrInSmg2)) {
            if (pSMG1.getHVEdges(nonNullPtrInSmg1 = nonNullPtrInSmg1.filterAtOffset(edge.getOffset())).iterator().hasNext()) continue;
            TreeMap<Long, Long> newNullEdgesOffsetToSize = pSMG1.getNullEdgesMapOffsetToSizeForObject(pObj1);
            long min = edge.getOffset();
            long max = edge.getOffset() + edge.getSizeInBits();
            Map.Entry<Long, Long> floorEntry = newNullEdgesOffsetToSize.floorEntry(min);
            if (floorEntry == null || floorEntry.getValue() + floorEntry.getKey() < max) continue;
            retset.add(new SMGEdgeHasValue(edge.getSizeInBits(), edge.getOffset(), pObj1, (SMGValue)SMGZeroValue.INSTANCE));
        }
        return retset;
    }

    private static SMGEdgeHasValue getNullEdgesIntersection(Map.Entry<Long, Long> first, Map.Entry<Long, Long> next, SMGObject pObj1) {
        long resultOffset = Long.max(first.getKey(), next.getKey());
        long resultSize = Long.min(first.getValue() + first.getKey(), next.getValue() + next.getKey()) - resultOffset;
        return new SMGEdgeHasValue(resultSize, resultOffset, pObj1, (SMGValue)SMGZeroValue.INSTANCE);
    }

    @VisibleForTesting
    static Set<SMGEdgeHasValue> getHVSetOfCommonNullValues(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) {
        NavigableMap<Long, Long> subMap;
        LinkedHashSet<SMGEdgeHasValue> retset = new LinkedHashSet<SMGEdgeHasValue>();
        TreeMap<Long, Long> map1 = pSMG1.getNullEdgesMapOffsetToSizeForObject(pObj1);
        TreeMap<Long, Long> map2 = pSMG2.getNullEdgesMapOffsetToSizeForObject(pObj2);
        for (Map.Entry<Long, Long> entry1 : map1.entrySet()) {
            subMap = map2.subMap(entry1.getKey(), true, entry1.getKey() + entry1.getValue(), false);
            for (Map.Entry<Long, Long> entry : subMap.entrySet()) {
                retset.add(SMGJoinFields.getNullEdgesIntersection(entry1, entry, pObj1));
            }
        }
        for (Map.Entry<Long, Long> entry2 : map2.entrySet()) {
            subMap = map1.subMap(entry2.getKey(), false, entry2.getKey() + entry2.getValue(), false);
            for (Map.Entry<Long, Long> entry : subMap.entrySet()) {
                retset.add(SMGJoinFields.getNullEdgesIntersection(entry2, entry, pObj1));
            }
        }
        return retset;
    }

    private static void checkResultConsistencySingleSide(UnmodifiableSMG pSMG1, SMGEdgeHasValueFilter nullEdges1, UnmodifiableSMG pSMG2, SMGObject pObj2, TreeMap<Long, Long> nullEdgesInSMG2) throws SMGInconsistentException {
        for (SMGEdgeHasValue edgeInSMG1 : pSMG1.getHVEdges(nullEdges1)) {
            long nextNotNullBit;
            long start = edgeInSMG1.getOffset();
            long byte_after_end = start + edgeInSMG1.getSizeInBits();
            SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(pObj2).filterAtOffset(edgeInSMG1.getOffset()).filterBySize(edgeInSMG1.getSizeInBits());
            Iterable<SMGEdgeHasValue> hvInSMG2Set = pSMG2.getHVEdges(filter);
            SMGEdgeHasValue hvInSMG2 = hvInSMG2Set.iterator().hasNext() ? (SMGEdgeHasValue)Iterables.getOnlyElement(hvInSMG2Set) : null;
            Map.Entry<Long, Long> floorEntry = nullEdgesInSMG2.floorEntry(start);
            long l = nextNotNullBit = floorEntry == null ? start : Long.max(start, floorEntry.getKey() + floorEntry.getValue());
            if (hvInSMG2 != null && (nextNotNullBit >= byte_after_end || pSMG2.isPointer(hvInSMG2.getValue()))) continue;
            throw new SMGInconsistentException("SMGJoinFields output assertions do not hold");
        }
    }

    public static void checkResultConsistency(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGObject pObj1, SMGObject pObj2) throws SMGInconsistentException {
        SMGEdgeHasValueFilter nullEdges1 = SMGEdgeHasValueFilter.objectFilter(pObj1).filterHavingValue(SMGZeroValue.INSTANCE).filterWithoutSize();
        SMGEdgeHasValueFilter nullEdges2 = SMGEdgeHasValueFilter.objectFilter(pObj2).filterHavingValue(SMGZeroValue.INSTANCE).filterWithoutSize();
        TreeMap<Long, Long> nullEdgesInSMG1 = pSMG1.getNullEdgesMapOffsetToSizeForObject(pObj1);
        TreeMap<Long, Long> nullEdgesInSMG2 = pSMG2.getNullEdgesMapOffsetToSizeForObject(pObj2);
        if (Iterables.size(pSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1).filterNotHavingValue(SMGZeroValue.INSTANCE))) != Iterables.size(pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2).filterNotHavingValue(SMGZeroValue.INSTANCE)))) {
            throw new SMGInconsistentException("SMGJoinFields output assertion does not hold: the objects do not have identical sets of fields");
        }
        SMGJoinFields.checkResultConsistencySingleSide(pSMG1, nullEdges1, pSMG2, pObj2, nullEdgesInSMG2);
        SMGJoinFields.checkResultConsistencySingleSide(pSMG2, nullEdges2, pSMG1, pObj1, nullEdgesInSMG1);
    }
}

