/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.Sets;
import com.google.common.truth.Truth;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinFields;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.Pair;

public class SMGJoinFieldsTest {
    private static final int mockType4bSize = 32;
    private static final int mockType8bSize = 64;
    private SMG smg1;
    private SMG smg2;
    private final SMGValue value1 = SMGKnownSymValue.of();
    private final SMGValue value2 = SMGKnownSymValue.of();

    @Before
    public void setUp() {
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.smg2 = new SMG(MachineModel.LINUX64);
    }

    @Test
    public void joinNulliefiedAndUndefinedFieldsTest() {
        SMGRegion obj1 = new SMGRegion(128L, "obj1");
        SMGRegion obj2 = new SMGRegion(128L, "obj2");
        SMGRegion oth1 = new SMGRegion(128L, "oth1");
        SMGRegion oth2 = new SMGRegion(128L, "oth2");
        SMGKnownExpValue value100 = SMGKnownExpValue.valueOf(100);
        SMGEdgeHasValue obj1hv1at0 = new SMGEdgeHasValue(40L, 0L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue obj1hv2at7 = new SMGEdgeHasValue(16L, 56L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue obj1hv3at9 = new SMGEdgeHasValue(56L, 72L, (SMGObject)obj1, this.value1);
        SMGEdgeHasValue obj2hv1at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj2, (SMGValue)value100);
        SMGEdgePointsTo obj2pt1to0 = new SMGEdgePointsTo(value100, oth2, 0L);
        SMGEdgeHasValue obj2hv2at4 = new SMGEdgeHasValue(24L, 32L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue obj2hv3at8 = new SMGEdgeHasValue(64L, 64L, (SMGObject)obj2, this.value2);
        SMGEdgeHasValue oth1hv1at0 = new SMGEdgeHasValue(40L, 0L, (SMGObject)oth1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue oth1hv2at7 = new SMGEdgeHasValue(16L, 56L, (SMGObject)oth1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue oth1hv3at9 = new SMGEdgeHasValue(56L, 72L, (SMGObject)oth1, this.value1);
        SMGEdgeHasValue oth2hv1at0 = new SMGEdgeHasValue(32L, 0L, (SMGObject)oth2, (SMGValue)value100);
        SMGEdgeHasValue oth2hv2at4 = new SMGEdgeHasValue(24L, 32L, (SMGObject)oth2, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue oth2hv3at8 = new SMGEdgeHasValue(64L, 64L, (SMGObject)oth2, this.value2);
        this.smg1.addObject(obj1);
        this.smg1.addObject(oth1);
        this.smg2.addObject(obj2);
        this.smg2.addObject(oth2);
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smg2.addValue(value100);
        this.smg1.addHasValueEdge(obj1hv1at0);
        this.smg1.addHasValueEdge(obj1hv2at7);
        this.smg1.addHasValueEdge(obj1hv3at9);
        this.smg1.addHasValueEdge(oth1hv1at0);
        this.smg1.addHasValueEdge(oth1hv2at7);
        this.smg1.addHasValueEdge(oth1hv3at9);
        this.smg2.addHasValueEdge(obj2hv1at0);
        this.smg2.addPointsToEdge(obj2pt1to0);
        this.smg2.addHasValueEdge(obj2hv2at4);
        this.smg2.addHasValueEdge(obj2hv3at8);
        this.smg2.addHasValueEdge(oth2hv1at0);
        this.smg2.addHasValueEdge(oth2hv2at4);
        this.smg2.addHasValueEdge(oth2hv3at8);
        SMGJoinFields join = new SMGJoinFields(this.smg1, this.smg2, obj1, obj2);
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
        HashMap<Long, Pair<SMGValue, Integer>> fieldMap1 = new HashMap<Long, Pair<SMGValue, Integer>>();
        HashMap<Long, Pair<SMGValue, Integer>> fieldMap2 = new HashMap<Long, Pair<SMGValue, Integer>>();
        fieldMap1.put(0L, Pair.of(SMGZeroValue.INSTANCE, 40));
        fieldMap1.put(72L, Pair.of(this.value1, 56));
        fieldMap2.put(0L, Pair.of(value100, 32));
        fieldMap2.put(32L, Pair.of(SMGZeroValue.INSTANCE, 8));
        fieldMap2.put(64L, Pair.of(this.value2, 64));
        this.checkFields(join.getSMG1(), fieldMap1, obj1);
        this.checkFields(join.getSMG2(), fieldMap2, obj2);
    }

    private void checkFields(UnmodifiableSMG pSmg, Map<Long, Pair<SMGValue, Integer>> pFieldMap, SMGObject pObj) {
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterOnSMG = SMGEdgeHasValueFilter.objectFilter(pObj);
        SMGHasValueEdges edges = pSmg.getHVEdges(filterOnSMG);
        Truth.assertThat((Iterable)edges).hasSize(pFieldMap.size());
        for (SMGEdgeHasValue edge : edges) {
            long offset = edge.getOffset();
            Truth.assertThat(pFieldMap).containsKey((Object)offset);
            SMGValue value = edge.getValue();
            long length = edge.getSizeInBits();
            Pair<SMGValue, Integer> expectedValueAndLength = pFieldMap.get(offset);
            SMGValue eValue = expectedValueAndLength.getFirst();
            int eLength = expectedValueAndLength.getSecond();
            if (!eValue.equals(SMGKnownExpValue.valueOf(-1))) {
                Truth.assertThat((Comparable)value).isEqualTo((Object)eValue);
            }
            Truth.assertThat((Long)length).isEqualTo((Object)eLength);
        }
    }

    @Test
    public void getHVSetOfMissingNullValuesTest() {
        SMGRegion obj1 = new SMGRegion(64L, "1");
        SMGRegion obj2 = new SMGRegion(64L, "2");
        this.smg1.addObject(obj1);
        this.smg2.addObject(obj2);
        this.smg2.addValue(this.value2);
        SMGEdgeHasValue nullifyObj1 = new SMGEdgeHasValue(64L, 0L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue nonPointer = new SMGEdgeHasValue(32L, 16L, (SMGObject)obj2, this.value2);
        this.smg1.addHasValueEdge(nullifyObj1);
        this.smg2.addHasValueEdge(nonPointer);
        Set<SMGEdgeHasValue> hvSet1 = SMGJoinFields.getHVSetOfMissingNullValues(this.smg1, this.smg2, obj1, obj2);
        Truth.assertThat(hvSet1).hasSize(1);
        this.smg2.addPointsToEdge(new SMGEdgePointsTo(this.value2, obj2, 0L));
        Set<SMGEdgeHasValue> hvSet2 = SMGJoinFields.getHVSetOfMissingNullValues(this.smg1, this.smg2, obj1, obj2);
        Truth.assertThat(hvSet2).hasSize(1);
        for (SMGEdgeHasValue hv : Sets.union(hvSet1, hvSet2)) {
            Truth.assertThat((Comparable)hv.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
            Truth.assertThat((Comparable)hv.getObject()).isSameInstanceAs((Object)obj1);
            Truth.assertThat((Long)hv.getSizeInBits()).isEqualTo((Object)32);
            Truth.assertThat((Long)hv.getOffset()).isEqualTo((Object)16);
        }
    }

    @Test
    public void getHVSetOfCommonNullValuesTest() {
        SMGRegion obj1 = new SMGRegion(176L, "1");
        SMGEdgeHasValue smg1at4 = new SMGEdgeHasValue(32L, 32L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue smg2at8 = new SMGEdgeHasValue(32L, 64L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue smg1at14 = new SMGEdgeHasValue(32L, 112L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue smg2at12 = new SMGEdgeHasValue(32L, 96L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue smg1at18 = new SMGEdgeHasValue(32L, 144L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue smg2at18 = new SMGEdgeHasValue(32L, 144L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE);
        this.smg1.addHasValueEdge(smg1at18);
        this.smg1.addHasValueEdge(smg1at14);
        this.smg1.addHasValueEdge(smg1at4);
        this.smg2.addHasValueEdge(smg2at18);
        this.smg2.addHasValueEdge(smg2at12);
        this.smg2.addHasValueEdge(smg2at8);
        Set<SMGEdgeHasValue> hvSet = SMGJoinFields.getHVSetOfCommonNullValues(this.smg1, this.smg2, obj1, obj1);
        Truth.assertThat(hvSet).hasSize(2);
        for (SMGEdgeHasValue hv : hvSet) {
            Truth.assertThat((Comparable)hv.getValue()).isEqualTo((Object)SMGZeroValue.INSTANCE);
            Truth.assertThat((Comparable)hv.getObject()).isSameInstanceAs((Object)obj1);
            Truth.assertThat((Long)hv.getOffset()).isAnyOf((Object)112L, (Object)144L, new Object[0]);
            if (hv.getOffset() == 112L) {
                Truth.assertThat((Long)hv.getSizeInBits()).isEqualTo((Object)16);
                continue;
            }
            Truth.assertThat((Long)hv.getSizeInBits()).isEqualTo((Object)32);
        }
    }

    @Test
    public void getCompatibleHVEdgeSetTest() {
        SMGRegion obj = new SMGRegion(256L, "Object");
        SMGRegion differentObject = new SMGRegion(128L, "Different object");
        this.smg1.addObject(obj);
        this.smg2.addObject(obj);
        this.smg1.addObject(differentObject);
        this.smg2.addValue(this.value1);
        SMGEdgeHasValue hv0for4at0in1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at0in2 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at5in1 = new SMGEdgeHasValue(32L, 40L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at7in2 = new SMGEdgeHasValue(32L, 56L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at12in1 = new SMGEdgeHasValue(32L, 96L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at16in2 = new SMGEdgeHasValue(32L, 128L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv0for4at20in1 = new SMGEdgeHasValue(32L, 160L, (SMGObject)obj, (SMGValue)SMGZeroValue.INSTANCE);
        SMGEdgeHasValue hv666for4at20in2 = new SMGEdgeHasValue(32L, 160L, (SMGObject)obj, this.value1);
        SMGEdgeHasValue hv666for4at28in2 = new SMGEdgeHasValue(32L, 224L, (SMGObject)obj, this.value1);
        SMGEdgeHasValue diffObjectNullValue = new SMGEdgeHasValue(32L, 0L, (SMGObject)differentObject, (SMGValue)SMGZeroValue.INSTANCE);
        this.smg1.addHasValueEdge(hv0for4at0in1);
        this.smg1.addHasValueEdge(hv0for4at5in1);
        this.smg1.addHasValueEdge(hv0for4at12in1);
        this.smg1.addHasValueEdge(hv0for4at20in1);
        this.smg1.addHasValueEdge(diffObjectNullValue);
        this.smg2.addHasValueEdge(hv0for4at0in2);
        this.smg2.addHasValueEdge(hv0for4at7in2);
        this.smg2.addHasValueEdge(hv0for4at16in2);
        this.smg2.addHasValueEdge(hv666for4at20in2);
        this.smg2.addPointsToEdge(new SMGEdgePointsTo(this.value1, obj, 160L));
        this.smg2.addHasValueEdge(hv666for4at28in2);
        SMGJoinFields.setCompatibleHVEdgesToSMG(this.smg1, this.smg2, obj, obj);
        Truth.assertThat((Iterable)this.smg1.getHVEdges()).hasSize(4);
        SMGJoinFields.setCompatibleHVEdgesToSMG(this.smg2, this.smg1, obj, obj);
        Truth.assertThat((Iterable)this.smg1.getHVEdges()).hasSize(4);
    }

    @Test
    public void mergeNonNullHVEdgesTest() {
        HashSet<SMGValue> values = new HashSet<SMGValue>();
        values.add(this.value1);
        values.add(this.value2);
        SMGRegion object = new SMGRegion(128L, "Object");
        SMGEdgeHasValue smg1_4bFrom0ToV1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)object, this.value1);
        SMGEdgeHasValue smg1_4bFrom4ToV2 = new SMGEdgeHasValue(32L, 32L, (SMGObject)object, this.value2);
        SMGEdgeHasValue smg1_4bFrom8ToNull = new SMGEdgeHasValue(32L, 64L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE);
        this.smg1.addObject(object);
        this.smg1.addValue(this.value1);
        this.smg1.addValue(this.value2);
        this.smg1.addHasValueEdge(smg1_4bFrom8ToNull);
        this.smg1.addHasValueEdge(smg1_4bFrom4ToV2);
        this.smg1.addHasValueEdge(smg1_4bFrom0ToV1);
        this.smg2.addObject(object);
        SMGHasValueEdges hvSet = SMGJoinFields.mergeNonNullHasValueEdges(this.smg1, this.smg2, object, object);
        Truth.assertThat((Iterable)hvSet).hasSize(2);
        boolean seenZero = false;
        boolean seenTwo = false;
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filter = SMGEdgeHasValueFilter.objectFilter(object);
        for (SMGEdgeHasValue edge : filter.filter(hvSet)) {
            if (edge.getOffset() == 0L) {
                seenZero = true;
            } else if (edge.getOffset() == 32L) {
                seenTwo = true;
            }
            Truth.assertThat((Long)edge.getOffset()).isAnyOf((Object)0L, (Object)32L, new Object[0]);
            Truth.assertThat((Long)edge.getSizeInBits()).isEqualTo((Object)32);
            Truth.assertThat(values).doesNotContain((Object)edge.getValue());
            values.add(edge.getValue());
        }
        Truth.assertThat((Boolean)seenZero).isTrue();
        Truth.assertThat((Boolean)seenTwo).isTrue();
        this.smg2.addValue(this.value1);
        this.smg2.addHasValueEdge(smg1_4bFrom0ToV1);
        hvSet = SMGJoinFields.mergeNonNullHasValueEdges(this.smg1, this.smg2, object, object);
        Truth.assertThat((Iterable)hvSet).hasSize(1);
    }

    @Test
    public void mergeNonNullAplliedTest() {
        SMGRegion obj1 = new SMGRegion(64L, "Object 1");
        SMGRegion obj2 = new SMGRegion(64L, "Object 2");
        this.smg1.addObject(obj1);
        this.smg2.addObject(obj2);
        SMGKnownSymbolicValue value3 = SMGKnownSymValue.of();
        this.smg1.addValue(value3);
        this.smg1.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)value3));
        SMGJoinFields jf = new SMGJoinFields(this.smg1.copyOf(), this.smg2.copyOf(), obj1, obj2);
        UnmodifiableSMG resultSMG = jf.getSMG2();
        SMGHasValueEdges edges = resultSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2));
        Truth.assertThat((Boolean)edges.isEmpty()).isFalse();
        jf = new SMGJoinFields(this.smg2.copyOf(), this.smg1.copyOf(), obj2, obj1);
        resultSMG = jf.getSMG1();
        edges = resultSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2));
        Truth.assertThat((Boolean)edges.isEmpty()).isFalse();
    }

    @Test
    public void joinFieldsRelaxStatusTest() {
        SMGRegion object = new SMGRegion(64L, "Object");
        this.smg1.addObject(object);
        SMG smg0_0B_4B = this.smg1.copyOf();
        SMG smg0_2B_6B = this.smg1.copyOf();
        SMG smg0_4B_8B = this.smg1.copyOf();
        SMG smg0_0B_8B = this.smg1.copyOf();
        smg0_0B_4B.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE));
        smg0_2B_6B.addHasValueEdge(new SMGEdgeHasValue(32L, 16L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE));
        smg0_4B_8B.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE));
        smg0_0B_8B.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE));
        smg0_0B_8B.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)object, (SMGValue)SMGZeroValue.INSTANCE));
        this.checkStatusAfterRelax(SMGJoinStatus.EQUAL, smg0_0B_8B, smg0_0B_8B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_0B_4B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_4B_8B, object);
        this.checkStatusAfterRelax(SMGJoinStatus.INCOMPARABLE, smg0_0B_8B, smg0_2B_6B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.EQUAL, smg0_0B_8B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_0B_4B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_2B_6B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.LEFT_ENTAIL, smg0_0B_8B, smg0_4B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_0B_4B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_2B_6B, smg0_0B_8B, object);
        this.checkStatusAfterJoinFields(SMGJoinStatus.RIGHT_ENTAIL, smg0_4B_8B, smg0_0B_8B, object);
    }

    private void checkStatusAfterRelax(SMGJoinStatus expected, SMG a, SMG b, SMGRegion object) {
        SMGJoinFields js = new SMGJoinFields(a, a, object, object);
        js.joinFieldsRelaxStatus(a, b, SMGJoinStatus.INCOMPARABLE, object);
        Truth.assertThat((Comparable)((Object)js.getStatus())).isEqualTo((Object)expected);
    }

    private void checkStatusAfterJoinFields(SMGJoinStatus expected, SMG a, SMG b, SMGRegion object) {
        SMGJoinFields js = new SMGJoinFields(a, b, object, object);
        Truth.assertThat((Comparable)((Object)js.getStatus())).isEqualTo((Object)expected);
    }

    @Test(expected=IllegalArgumentException.class)
    public void differentSizeCheckTest() {
        SMGRegion obj1 = new SMGRegion(64L, "Object 1");
        SMGRegion obj2 = new SMGRegion(96L, "Object 2");
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX64);
        smg3.addObject(obj1);
        smg4.addObject(obj2);
        new SMGJoinFields(smg3, smg4, obj1, obj2);
    }

    @Test
    public void consistencyCheckTest() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        SMGKnownSymbolicValue value3 = SMGKnownSymValue.of();
        SMGKnownSymbolicValue value4 = SMGKnownSymValue.of();
        smg3.addObject(obj1);
        smg4.addObject(obj2);
        smg3.addValue(value3);
        smg4.addValue(value4);
        SMGEdgeHasValue hvAt0in1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)value3);
        SMGEdgeHasValue hvAt0in2 = new SMGEdgeHasValue(32L, 0L, (SMGObject)obj2, (SMGValue)value4);
        smg3.addHasValueEdge(hvAt0in1);
        smg4.addHasValueEdge(hvAt0in2);
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
        smg3.addHasValueEdge(new SMGEdgeHasValue(64L, 64L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(64L, 64L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 128L, (SMGObject)obj1, (SMGValue)value3));
        smg3.addPointsToEdge(new SMGEdgePointsTo(value3, obj1, 0L));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 128L, (SMGObject)obj2, (SMGValue)value4));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest1() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        SMGKnownSymbolicValue value3 = SMGKnownSymValue.of();
        smg3.addValue(value3);
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)value3));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest2() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(64L, 0L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest3() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 64L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(64L, 0L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest4() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(32L, "Object 1");
        SMGRegion obj2 = new SMGRegion(32L, "Object 2");
        SMGKnownSymbolicValue value = SMGKnownSymValue.of();
        smg3.addValue(value);
        smg4.addValue(value);
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)value));
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(64L, 0L, (SMGObject)obj2, (SMGValue)value));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 64L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 96L, (SMGObject)obj2, (SMGValue)SMGZeroValue.INSTANCE));
        smg3.addHasValueEdge(new SMGEdgeHasValue(64L, 64L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=SMGInconsistentException.class)
    public void consistencyCheckNegativeTest5() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        SMGKnownSymbolicValue value4 = SMGKnownSymValue.of();
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)SMGZeroValue.INSTANCE));
        smg4.addValue(value4);
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj2, (SMGValue)value4));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test
    public void consistencyCheckPositiveTest1() throws SMGInconsistentException {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        SMGRegion obj3 = new SMGRegion(256L, "Object 3");
        SMGKnownSymbolicValue value3 = SMGKnownSymValue.of();
        SMGKnownSymbolicValue value4 = SMGKnownSymValue.of();
        smg3.addValue(value3);
        smg4.addValue(value4);
        smg3.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj1, (SMGValue)value3));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj2, (SMGValue)value4));
        smg4.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)obj3, (SMGValue)value4));
        SMGJoinFields.checkResultConsistency(smg3, smg4, obj1, obj2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectTest1() {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        smg4.addObject(obj2);
        new SMGJoinFields(smg3, smg4, obj1, obj2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectTest2() {
        SMG smg3 = new SMG(MachineModel.LINUX64);
        SMG smg4 = new SMG(MachineModel.LINUX32);
        SMGRegion obj1 = new SMGRegion(256L, "Object 1");
        SMGRegion obj2 = new SMGRegion(256L, "Object 2");
        smg3.addObject(obj1);
        new SMGJoinFields(smg3, smg4, obj1, obj2);
    }
}

