/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

final class SMGJoinMapTargetAddress {
    private final SMG smg;
    @VisibleForTesting
    final SMGNodeMapping mapping1;
    @VisibleForTesting
    final SMGNodeMapping mapping2;
    private final SMGValue value;

    public SMGJoinMapTargetAddress(UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMG destSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGValue pAddress1, SMGValue pAddress2) {
        this.smg = destSMG;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        SMGObject target = SMGNullObject.INSTANCE;
        SMGEdgePointsTo pt = pSMG1.getPointer(pAddress1);
        SMGEdgePointsTo pt2 = pSMG2.getPointer(pAddress2);
        if (pt.getObject() != SMGNullObject.INSTANCE) {
            target = pMapping1.get(pt.getObject());
        }
        SMGTargetSpecifier tg = pt.getObject().isAbstract() && pt.getObject().getKind() != SMGObjectKind.OPTIONAL || pt2 == null || pt2.getObject().getKind() == SMGObjectKind.OPTIONAL ? pt.getTargetSpecifier() : pt2.getTargetSpecifier();
        Set<SMGEdgePointsTo> edges = this.smg.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(target).filterAtTargetOffset(pt.getOffset()).filterByTargetSpecifier(tg));
        if (!edges.isEmpty()) {
            this.value = ((SMGEdgePointsTo)Iterables.getOnlyElement(edges)).getValue();
            return;
        }
        this.value = pAddress1.equals(pAddress2) ? pAddress1 : SMGKnownSymValue.of();
        this.smg.addValue(this.value);
        SMGEdgePointsTo nPtEdge = new SMGEdgePointsTo(this.value, target, pt.getOffset(), tg);
        this.smg.addPointsToEdge(nPtEdge);
        this.mapping1.map(pAddress1, this.value);
        this.mapping2.map(pAddress2, this.value);
    }

    public SMG getSMG() {
        return this.smg;
    }

    public SMGValue getValue() {
        return this.value;
    }
}

