/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMapTargetAddress;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

public class SMGJoinMapTargetAddressTest {
    private SMG smg1;
    private SMG destSMG;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    final SMGRegion obj1 = new SMGRegion(64L, "ze label");
    final SMGValue value1 = SMGKnownSymValue.of();
    final SMGEdgePointsTo edge1 = new SMGEdgePointsTo(this.value1, this.obj1, 0L);
    final SMGValue value2 = SMGKnownSymValue.of();
    final SMGObject destObj = new SMGRegion(64L, "destination");
    final SMGValue destValue = SMGKnownSymValue.of();

    @Before
    public void setUp() {
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.destSMG = new SMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void mapTargetAddressExistingNull() {
        SMG origDestSMG = this.destSMG.copyOf();
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping1, SMGZeroValue.INSTANCE, SMGZeroValue.INSTANCE);
        Truth.assertThat((Object)mta.getSMG()).isEqualTo((Object)origDestSMG);
        Truth.assertThat((Object)mta.mapping1).isEqualTo((Object)origMapping1);
        Truth.assertThat((Comparable)mta.getValue()).isSameInstanceAs((Object)SMGZeroValue.INSTANCE);
    }

    @Test
    public void mapTargetAddressExisting() {
        SMGEdgePointsTo destEdge = new SMGEdgePointsTo(this.destValue, this.destObj, 0L);
        this.smg1.addValue(this.value1);
        this.smg1.addObject(this.obj1);
        this.smg1.addPointsToEdge(this.edge1);
        this.destSMG.addValue(this.destValue);
        this.destSMG.addObject(this.destObj);
        this.destSMG.addPointsToEdge(destEdge);
        this.mapping1.map(this.obj1, this.destObj);
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        SMG origDestSMG = this.destSMG.copyOf();
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping1, this.value1, this.value1);
        Truth.assertThat((Object)mta.getSMG()).isEqualTo((Object)origDestSMG);
        Truth.assertThat((Object)mta.mapping1).isEqualTo((Object)origMapping1);
        Truth.assertThat((Comparable)mta.getValue()).isSameInstanceAs((Object)this.destValue);
    }

    @Test
    public void mapTargetAddressNew() {
        this.smg1.addValue(this.value1);
        this.smg1.addObject(this.obj1);
        this.smg1.addPointsToEdge(this.edge1);
        this.destSMG.addObject(this.destObj);
        this.mapping1.map(this.obj1, this.destObj);
        SMGNodeMapping origMapping1 = new SMGNodeMapping(this.mapping1);
        SMGNodeMapping origMapping2 = new SMGNodeMapping(this.mapping2);
        SMG origDestSMG = this.destSMG.copyOf();
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1, this.smg1, this.destSMG, this.mapping1, this.mapping2, this.value1, this.value2);
        Truth.assertThat((Object)mta.getSMG()).isNotEqualTo((Object)origDestSMG);
        Truth.assertThat((Object)mta.mapping1).isNotEqualTo((Object)origMapping1);
        Truth.assertThat((Object)mta.mapping2).isNotEqualTo((Object)origMapping2);
        Truth.assertThat((Boolean)origDestSMG.getValues().contains(mta.getValue())).isFalse();
        SMGEdgePointsTo newEdge = this.destSMG.getPointer(mta.getValue());
        Truth.assertThat((Comparable)newEdge.getObject()).isSameInstanceAs((Object)this.destObj);
        Truth.assertThat((Long)newEdge.getOffset()).isEqualTo((Object)0);
        Truth.assertThat((Comparable)mta.mapping1.get(this.value1)).isSameInstanceAs((Object)mta.getValue());
        Truth.assertThat((Comparable)mta.mapping2.get(this.value2)).isSameInstanceAs((Object)mta.getValue());
    }
}

