/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.base.Preconditions;
import java.util.Iterator;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGAbstractObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

final class SMGJoinMatchObjects {
    private boolean defined = false;
    private SMGJoinStatus status;

    private static boolean checkNull(SMGObject pObj1, SMGObject pObj2) {
        return pObj1 == SMGNullObject.INSTANCE || pObj2 == SMGNullObject.INSTANCE;
    }

    private static boolean checkMatchingMapping(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2) {
        return pMapping1.containsKey(pObj1) && pMapping2.containsKey(pObj2) && pMapping1.get(pObj1) != pMapping2.get(pObj2);
    }

    private static boolean checkConsistentMapping(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2) {
        return pMapping1.containsKey(pObj1) && pMapping2.containsValue(pMapping1.get(pObj1)) || pMapping2.containsKey(pObj2) && pMapping1.containsValue(pMapping2.get(pObj2));
    }

    private static boolean checkConsistentObjects(SMGObject pObj1, SMGObject pObj2, UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2) {
        return pObj1.getSize() != pObj2.getSize() || pSMG1.isObjectValid(pObj1) != pSMG2.isObjectValid(pObj2);
    }

    private static boolean checkConsistentShape(SMGObject pObj1, SMGObject pObj2) {
        return pObj1.getKind() == pObj2.getKind() && pObj1.isAbstract() && pObj2.isAbstract() && !((SMGAbstractObject)((Object)pObj1)).matchSpecificShape((SMGAbstractObject)((Object)pObj2));
    }

    private static boolean checkConsistentFields(SMGObject pObj1, SMGObject pObj2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2) {
        SMGHasValueEdges edges1 = pSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj1));
        SMGHasValueEdges edges2 = pSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObj2));
        Iterator iterator2 = edges2.iterator();
        SMGEdgeHasValue hv2 = iterator2.hasNext() ? (SMGEdgeHasValue)iterator2.next() : null;
        for (SMGEdgeHasValue hv1 : edges1) {
            while (hv2 != null && hv2.getOffset() < hv1.getOffset()) {
                hv2 = iterator2.hasNext() ? (SMGEdgeHasValue)iterator2.next() : null;
            }
            if (hv2 == null || hv1.getOffset() != hv2.getOffset() || hv1.getSizeInBits() != hv2.getSizeInBits()) continue;
            SMGValue v1 = hv1.getValue();
            SMGValue v2 = hv2.getValue();
            if (!pMapping1.containsKey(v1) || !pMapping2.containsKey(v2) || pMapping1.get(v1).equals(pMapping2.get(v2))) continue;
            return true;
        }
        return false;
    }

    private static boolean checkMatchingAbstractions(SMGObject pObj1, SMGObject pObj2) {
        SMGAbstractObject pAbstract2;
        SMGAbstractObject pAbstract1;
        if (pObj1.isAbstract() && pObj2.isAbstract() && (!(pAbstract1 = (SMGAbstractObject)((Object)pObj1)).matchGenericShape(pAbstract2 = (SMGAbstractObject)((Object)pObj2)) || !pAbstract1.matchSpecificShape(pAbstract2))) {
            if (pObj1.getSize() != pObj2.getSize()) {
                return true;
            }
            return pObj1.getKind().isContainedIn(pObj2.getKind());
        }
        return false;
    }

    public SMGJoinMatchObjects(SMGJoinStatus pStatus, UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGObject pObj1, SMGObject pObj2) {
        Preconditions.checkArgument((pSMG1.getObjects().contains(pObj1) && pSMG2.getObjects().contains(pObj2) ? 1 : 0) != 0);
        if (SMGJoinMatchObjects.checkNull(pObj1, pObj2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkMatchingMapping(pObj1, pObj2, pMapping1, pMapping2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentMapping(pObj1, pObj2, pMapping1, pMapping2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentObjects(pObj1, pObj2, pSMG1, pSMG2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentShape(pObj1, pObj2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkMatchingAbstractions(pObj1, pObj2)) {
            return;
        }
        if (SMGJoinMatchObjects.checkConsistentFields(pObj1, pObj2, pMapping1, pMapping2, pSMG1, pSMG2)) {
            return;
        }
        this.status = SMGJoinMatchObjects.updateStatusForAbstractions(pObj1, pObj2, pStatus);
        this.defined = true;
    }

    private static SMGJoinStatus updateStatusForAbstractions(SMGObject pObj1, SMGObject pObj2, SMGJoinStatus pStatus) {
        SMGJoinStatus result = pStatus;
        if (pObj1.join(pObj2, pObj1.getLevel()).isMoreGeneral(pObj2)) {
            result = result.updateWith(SMGJoinStatus.LEFT_ENTAIL);
        }
        if (pObj2.join(pObj1, pObj2.getLevel()).isMoreGeneral(pObj1)) {
            result = result.updateWith(SMGJoinStatus.RIGHT_ENTAIL);
        }
        return result;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public boolean isDefined() {
        return this.defined;
    }
}

