/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.DummyAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMatchObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

public class SMGJoinMatchObjectsTest {
    private SMG smg1;
    private SMG smg2;
    private final SMGObject srcObj1 = new SMGRegion(64L, "Source object 1");
    private final SMGObject destObj1 = new SMGRegion(64L, "Destination object 1");
    private final SMGObject srcObj2 = new SMGRegion(64L, "Source object 2");
    private final SMGObject destObj2 = new SMGRegion(64L, "Destination object 2");
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;

    @Before
    public void setUp() {
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.smg2 = new SMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void nullObjectTest() {
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, SMGNullObject.INSTANCE, SMGNullObject.INSTANCE);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        this.smg1.addObject(this.srcObj1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, SMGNullObject.INSTANCE);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectsTestObj1() {
        this.smg2.addObject(this.srcObj2);
        new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, this.srcObj2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void nonMemberObjectsTestObj2() {
        this.smg1.addObject(this.srcObj1);
        new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, this.srcObj1, this.srcObj2);
    }

    @Test
    public void inconsistentMappingTest() {
        this.mapping1.map(this.srcObj1, this.destObj1);
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(this.srcObj2);
        this.mapping2.map(this.srcObj2, this.destObj1);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void inconsistentMappingViceVersaTest() {
        this.mapping2.map(this.srcObj2, this.destObj2);
        this.smg2.addObject(this.srcObj2);
        this.smg1.addObject(this.srcObj1);
        this.mapping1.map(this.srcObj1, this.destObj2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void inconsistentObjectsTest() {
        SMGRegion diffSizeObject = new SMGRegion(128L, "Object with different size");
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(diffSizeObject);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, diffSizeObject);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        this.smg2.addObject(this.srcObj2, false, false);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void nonMatchingMappingTest() {
        this.smg1.addObject(this.srcObj1);
        this.smg1.addObject(this.destObj1);
        this.mapping1.map(this.srcObj1, this.destObj1);
        this.smg2.addObject(this.srcObj2);
        this.smg2.addObject(this.destObj2);
        this.mapping2.map(this.srcObj2, this.destObj2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void fieldInconsistencyTest() {
        this.smg1.addObject(this.srcObj1);
        this.smg2.addObject(this.srcObj2);
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(2L, 0L, this.srcObj1, (SMGValue)SMGKnownSymValue.of());
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(2L, 2L, this.srcObj2, (SMGValue)SMGKnownSymValue.of());
        SMGEdgeHasValue hvMatching1 = new SMGEdgeHasValue(2L, 4L, this.srcObj1, (SMGValue)SMGKnownSymValue.of());
        SMGEdgeHasValue hvMatching2 = new SMGEdgeHasValue(2L, 4L, this.srcObj2, (SMGValue)SMGKnownSymValue.of());
        this.smg1.addValue(hv1.getValue());
        this.smg1.addHasValueEdge(hv1);
        this.smg2.addValue(hv2.getValue());
        this.smg2.addHasValueEdge(hv2);
        this.smg1.addValue(hvMatching1.getValue());
        this.smg1.addHasValueEdge(hvMatching1);
        this.smg2.addValue(hvMatching2.getValue());
        this.smg2.addHasValueEdge(hvMatching2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping1.map(hvMatching1.getValue(), SMGKnownSymValue.of());
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping2.map(hvMatching2.getValue(), this.mapping1.get(hvMatching1.getValue()));
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        this.mapping2.map(hvMatching2.getValue(), SMGKnownSymValue.of());
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.srcObj1, this.srcObj2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void sameAbstractionMatchTest() {
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(128L, 0L, 8L, 7, 0);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(128L, 0L, 0L, 7, 0);
        this.smg1.addObject(sll1);
        this.smg2.addObject(sll2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void differentAbstractionMatch() {
        SMGRegion prototype = new SMGRegion(128L, "prototype");
        SMGSingleLinkedList sll = new SMGSingleLinkedList(128L, 0L, 8L, 3, 0);
        DummyAbstraction dummy = new DummyAbstraction(prototype);
        this.smg1.addObject(sll);
        this.smg2.addObject(dummy);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll, dummy);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
    }

    @Test
    public void twoAbstractionsTest() {
        SMGSingleLinkedList sll1 = new SMGSingleLinkedList(128L, 0L, 8L, 2, 0);
        SMGSingleLinkedList sll2 = new SMGSingleLinkedList(128L, 0L, 8L, 4, 0);
        this.smg1.addObject(sll1);
        this.smg2.addObject(sll2);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.LEFT_ENTAIL);
        sll1 = new SMGSingleLinkedList(128L, 0L, 8L, 4, 0);
        this.smg1.addObject(sll1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        sll1 = new SMGSingleLinkedList(128L, 0L, 8L, 8, 0);
        this.smg1.addObject(sll1);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll1, sll2);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.RIGHT_ENTAIL);
    }

    @Test
    public void oneAbstractionTest() {
        SMGRegion prototype = new SMGRegion(128L, "prototype");
        SMGSingleLinkedList sll = new SMGSingleLinkedList(128L, 0L, 8L, 8, 0);
        this.smg1.addObject(sll);
        this.smg2.addObject(sll);
        this.smg1.addObject(prototype);
        this.smg2.addObject(prototype);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll, prototype);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, prototype, sll);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
        sll = new SMGSingleLinkedList(128L, 0L, 8L, 0, 0);
        this.smg1.addObject(sll);
        this.smg2.addObject(sll);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, sll, prototype);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.LEFT_ENTAIL);
        mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, prototype, sll);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.RIGHT_ENTAIL);
    }

    @Test
    public void noAbstractionTest() {
        SMGRegion object = new SMGRegion(128L, "prototype");
        this.smg1.addObject(object);
        this.smg2.addObject(object);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, object, object);
        Truth.assertThat((Boolean)mo.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)mo.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
    }
}

