/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashMap;
import java.util.List;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGGenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinFields;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinLevel;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinValues;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

final class SMGJoinSubSMGs {
    private static boolean performChecks = false;
    private SMGJoinStatus status;
    private boolean defined = false;
    private UnmodifiableSMG inputSMG1;
    private UnmodifiableSMG inputSMG2;
    private SMG destSMG;
    private final SMGNodeMapping mapping1;
    private final SMGNodeMapping mapping2;
    private final List<SMGGenericAbstractionCandidate> subSmgAbstractionCandidates;

    public SMGJoinSubSMGs(SMGJoinStatus initialStatus, UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGLevelMapping pLevelMap, SMGObject pObj1, SMGObject pObj2, SMGObject pNewObject, int pLDiff, boolean identicalInputSmg, UnmodifiableSMGState pSmgState1, UnmodifiableSMGState pSmgState2) throws SMGInconsistentException {
        SMGJoinFields joinFields = new SMGJoinFields(pSMG1, pSMG2, pObj1, pObj2);
        this.inputSMG1 = joinFields.getSMG1();
        this.inputSMG2 = joinFields.getSMG2();
        this.status = initialStatus.updateWith(joinFields.getStatus());
        this.subSmgAbstractionCandidates = ImmutableList.of();
        this.destSMG = pDestSMG;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        if (performChecks) {
            SMGJoinFields.checkResultConsistency(this.inputSMG1, this.inputSMG2, pObj1, pObj2);
        }
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterOnSMG1 = SMGEdgeHasValueFilter.objectFilter(pObj1);
        SMGEdgeHasValueFilter.SMGEdgeHasValueFilterByObject filterOnSMG2 = SMGEdgeHasValueFilter.objectFilter(pObj2);
        HashMap<SMGValue, List<SMGGenericAbstractionCandidate>> valueAbstractionCandidates = new HashMap<SMGValue, List<SMGGenericAbstractionCandidate>>();
        boolean allValuesDefined = true;
        int prevLevel = (Integer)pLevelMap.get(SMGJoinLevel.valueOf(pObj1.getLevel(), pObj2.getLevel()));
        SMGHasValueEdges hvEdgesIn1 = this.inputSMG1.getHVEdges(filterOnSMG1);
        SMGHasValueEdges hvEdgesIn2 = this.inputSMG2.getHVEdges(filterOnSMG2);
        boolean edgesAreAdded = false;
        if (!hvEdgesIn1.isEmpty() && hvEdgesIn1.equals(hvEdgesIn2) && pObj1.equals(pNewObject)) {
            this.destSMG.addHasValueEdges(hvEdgesIn1);
            edgesAreAdded = true;
        }
        for (SMGEdgeHasValue hvIn1 : hvEdgesIn1) {
            Iterable<SMGEdgeHasValue> hvEdges2 = hvEdgesIn2.filter(new SMGEdgeHasValueFilter().filterAtOffset(hvIn1.getOffset()).filterWithoutSize());
            if (Iterables.size(hvEdges2) != 1) {
                this.defined = false;
                this.status = SMGJoinStatus.INCOMPARABLE;
                return;
            }
            SMGEdgeHasValue hvIn2 = (SMGEdgeHasValue)Iterables.getOnlyElement(hvEdges2);
            int value1Level = this.getValueLevel(pObj1, hvIn1.getValue(), this.inputSMG1);
            int value2Level = this.getValueLevel(pObj2, hvIn2.getValue(), this.inputSMG2);
            int levelDiff1 = value1Level - pObj1.getLevel();
            int levelDiff2 = value2Level - pObj2.getLevel();
            int lDiff = pLDiff + (levelDiff1 - levelDiff2);
            SMGLevelMapping levelMap = this.updateLevelMap(value1Level, value2Level, pLevelMap, pObj1.getLevel(), pObj2.getLevel());
            if (levelMap == null) {
                this.defined = false;
                this.status = SMGJoinStatus.INCOMPARABLE;
                return;
            }
            SMGJoinValues joinValues = new SMGJoinValues(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, levelMap, hvIn1.getValue(), hvIn2.getValue(), lDiff, identicalInputSmg, value1Level, value2Level, prevLevel, pSmgState1, pSmgState2);
            this.status = joinValues.getStatus();
            if (!joinValues.isDefined() && !joinValues.isRecoverable()) {
                this.status = SMGJoinStatus.INCOMPARABLE;
                return;
            }
            this.inputSMG1 = joinValues.getInputSMG1();
            this.inputSMG2 = joinValues.getInputSMG2();
            this.destSMG = joinValues.getDestinationSMG();
            if (joinValues.isDefined()) {
                if (hvIn1.getObject().equals(pNewObject) && joinValues.getValue().equals(hvIn1.getValue())) {
                    if (!edgesAreAdded) {
                        this.destSMG.addHasValueEdge(hvIn1);
                    }
                } else {
                    SMGEdgeHasValue newHV = new SMGEdgeHasValue(hvIn1.getSizeInBits(), hvIn1.getOffset(), pNewObject, joinValues.getValue());
                    if (edgesAreAdded) {
                        this.destSMG.removeHasValueEdge(hvIn1);
                    }
                    this.destSMG.addHasValueEdge(newHV);
                }
                if (!joinValues.subSmgHasAbstractionsCandidates()) continue;
                valueAbstractionCandidates.put(joinValues.getValue(), joinValues.getAbstractionCandidates());
                continue;
            }
            allValuesDefined = false;
        }
        if (allValuesDefined && valueAbstractionCandidates.isEmpty()) {
            this.defined = true;
            return;
        }
        if (!allValuesDefined) {
            this.status = SMGJoinStatus.INCOMPARABLE;
            this.defined = false;
            return;
        }
        for (List abstractionCandidates : valueAbstractionCandidates.values()) {
            ((SMGGenericAbstractionCandidate)abstractionCandidates.iterator().next()).execute(this.destSMG);
        }
        this.defined = true;
    }

    private SMGLevelMapping updateLevelMap(int pValue1Level, int pValue2Level, SMGLevelMapping pLevelMap, int pObjectLevel, int pObjectLevel2) {
        SMGJoinLevel joinLevel = SMGJoinLevel.valueOf(pValue1Level, pValue2Level);
        if (pLevelMap.containsKey(joinLevel)) {
            return pLevelMap;
        }
        int oldLevel = (Integer)pLevelMap.get(SMGJoinLevel.valueOf(pObjectLevel, pObjectLevel2));
        if (pValue1Level == pObjectLevel + 1 || pValue2Level == pObjectLevel2 + 1) {
            int result = oldLevel + 1;
            SMGLevelMapping newLevelMap = new SMGLevelMapping();
            newLevelMap.putAll(pLevelMap);
            newLevelMap.put(joinLevel, result);
            return newLevelMap;
        }
        if (pValue1Level == pObjectLevel && pValue2Level == pObjectLevel) {
            pLevelMap.put(joinLevel, oldLevel);
            SMGLevelMapping newLevelMap = new SMGLevelMapping();
            newLevelMap.putAll(pLevelMap);
            newLevelMap.put(joinLevel, oldLevel);
            return newLevelMap;
        }
        if (pValue1Level == pObjectLevel - 1 && pValue2Level == pObjectLevel2 - 1) {
            int result = oldLevel - 1;
            SMGLevelMapping newLevelMap = new SMGLevelMapping();
            newLevelMap.putAll(pLevelMap);
            newLevelMap.put(joinLevel, result);
            return newLevelMap;
        }
        return null;
    }

    private int getValueLevel(SMGObject pObject, SMGValue pValue, UnmodifiableSMG pInputSMG1) {
        if (pInputSMG1.isPointer(pValue)) {
            SMGEdgePointsTo pointer = pInputSMG1.getPointer(pValue);
            if (pointer.getTargetSpecifier() == SMGTargetSpecifier.ALL) {
                return pObject.getLevel() + 1;
            }
            SMGObject targetObject = pointer.getObject();
            return targetObject.getLevel();
        }
        return 0;
    }

    public boolean isDefined() {
        if (!this.defined) {
            Preconditions.checkState((this.status == SMGJoinStatus.INCOMPARABLE ? 1 : 0) != 0, (String)"Join of SubSMGs not defined, but status is %s", (Object)((Object)this.status));
        }
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public UnmodifiableSMG getSMG1() {
        return this.inputSMG1;
    }

    public UnmodifiableSMG getSMG2() {
        return this.inputSMG2;
    }

    public UnmodifiableSMG getDestSMG() {
        return this.destSMG;
    }

    public List<SMGGenericAbstractionCandidate> getSubSmgAbstractionCandidates() {
        return this.subSmgAbstractionCandidates;
    }
}

