/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinLevel;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGs;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

public final class SMGJoinSubSMGsForAbstraction {
    private final SMGJoinStatus status;
    private final UnmodifiableCLangSMG resultSMG;
    private final SMGObject newAbstractObject;
    private final Set<SMGValue> nonSharedValuesFromSMG1;
    private final Set<SMGValue> nonSharedValuesFromSMG2;
    private final Set<SMGObject> nonSharedObjectsFromSMG1;
    private final Set<SMGObject> nonSharedObjectsFromSMG2;
    private final boolean defined;

    public SMGJoinSubSMGsForAbstraction(CLangSMG smg, SMGObject obj1, SMGObject obj2, SMGListCandidate<?> pListCandidate, UnmodifiableSMGState pStateOfSmg) throws SMGInconsistentException {
        int length;
        int lengthObj2;
        int lengthObj1;
        long hfo;
        long nfo;
        PersistentSet<SMGObject> origObjects = smg.getObjects();
        PersistentSet<SMGValue> origValues = smg.getValues();
        SMGEdgeHasValue prevObj1hve = null;
        SMGEdgeHasValue nextObj1hve = null;
        SMGEdgeHasValue prevObj2hve = null;
        SMGEdgeHasValue nextObj2hve = null;
        if (pListCandidate instanceof SMGDoublyLinkedListCandidate) {
            SMGDoublyLinkedListCandidate dllc = (SMGDoublyLinkedListCandidate)pListCandidate;
            nfo = ((SMGDoublyLinkedListShape)dllc.getShape()).getNfo();
            long pfo = ((SMGDoublyLinkedListShape)dllc.getShape()).getPfo();
            hfo = ((SMGDoublyLinkedListShape)dllc.getShape()).getHfo();
            lengthObj1 = this.getMinLength(obj1);
            lengthObj2 = this.getMinLength(obj2);
            length = lengthObj1 + lengthObj2;
            SMGDoublyLinkedList dll = new SMGDoublyLinkedList(obj1.getSize(), hfo, nfo, pfo, length, obj1.getLevel());
            smg.addHeapObject(dll);
            this.newAbstractObject = dll;
            prevObj1hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj1).filterAtOffset(pfo).filterBySize(smg.getSizeofPtrInBits())));
            nextObj1hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj1).filterAtOffset(nfo).filterBySize(smg.getSizeofPtrInBits())));
            prevObj2hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2).filterAtOffset(pfo).filterBySize(smg.getSizeofPtrInBits())));
            nextObj2hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2).filterAtOffset(nfo).filterBySize(smg.getSizeofPtrInBits())));
            smg.removeHasValueEdge(prevObj1hve);
            smg.removeHasValueEdge(nextObj1hve);
            smg.removeHasValueEdge(prevObj2hve);
            smg.removeHasValueEdge(nextObj2hve);
        } else {
            SMGSingleLinkedListCandidate sllc = (SMGSingleLinkedListCandidate)pListCandidate;
            hfo = ((SMGSingleLinkedListShape)sllc.getShape()).getHfo();
            nfo = ((SMGSingleLinkedListShape)sllc.getShape()).getNfo();
            lengthObj1 = this.getMinLength(obj1);
            lengthObj2 = this.getMinLength(obj2);
            length = lengthObj1 + lengthObj2;
            SMGSingleLinkedList sll = new SMGSingleLinkedList(obj1.getSize(), hfo, nfo, length, obj1.getLevel());
            smg.addHeapObject(sll);
            this.newAbstractObject = sll;
            nextObj1hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj1).filterAtOffset(nfo).filterBySize(smg.getSizeofPtrInBits())));
            nextObj2hve = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(obj2).filterAtOffset(nfo).filterBySize(smg.getSizeofPtrInBits())));
            smg.removeHasValueEdge(nextObj1hve);
            smg.removeHasValueEdge(nextObj2hve);
        }
        int lDiff = 0;
        SMGNodeMapping mapping1 = new SMGNodeMapping();
        SMGNodeMapping mapping2 = new SMGNodeMapping();
        mapping1.map(obj1, this.newAbstractObject);
        mapping2.map(obj2, this.newAbstractObject);
        int destLevel = obj1.getLevel();
        if (this.shouldAbstractionIncreaseLevel(obj1, obj2)) {
            ++destLevel;
        }
        CLangSMG inputSMG = smg.copyOf();
        SMGLevelMapping levelMap = new SMGLevelMapping();
        levelMap.put(SMGJoinLevel.valueOf(obj1.getLevel(), obj2.getLevel()), destLevel);
        SMGJoinSubSMGs jss = new SMGJoinSubSMGs(SMGJoinStatus.EQUAL, inputSMG, inputSMG, smg, mapping1, mapping2, levelMap, obj1, obj2, this.newAbstractObject, lDiff, true, pStateOfSmg, pStateOfSmg);
        if (!jss.isDefined()) {
            this.status = SMGJoinStatus.INCOMPARABLE;
            this.defined = false;
            this.resultSMG = null;
            this.nonSharedObjectsFromSMG1 = null;
            this.nonSharedObjectsFromSMG2 = null;
            this.nonSharedValuesFromSMG1 = null;
            this.nonSharedValuesFromSMG2 = null;
            return;
        }
        SMGJoinStatus s = jss.getStatus();
        boolean bothObjectsAreRegOrOpt = this.shouldAbstractionIncreaseLevel(obj1, obj2);
        if (bothObjectsAreRegOrOpt) {
            for (SMGEdgePointsTo sMGEdgePointsTo : SMGUtils.getPointerToThisObject(this.newAbstractObject, smg)) {
                smg.removePointsToEdge(sMGEdgePointsTo.getValue());
                smg.addPointsToEdge(new SMGEdgePointsTo(sMGEdgePointsTo.getValue(), sMGEdgePointsTo.getObject(), sMGEdgePointsTo.getOffset(), SMGTargetSpecifier.ALL));
            }
        }
        if (this.newAbstractObject.getKind() == SMGObjectKind.DLL) {
            smg.addHasValueEdge(prevObj1hve);
            smg.addHasValueEdge(prevObj2hve);
        }
        smg.addHasValueEdge(nextObj1hve);
        smg.addHasValueEdge(nextObj2hve);
        this.defined = true;
        this.status = s;
        this.resultSMG = smg;
        this.nonSharedObjectsFromSMG1 = new HashSet<SMGObject>();
        this.nonSharedObjectsFromSMG2 = new HashSet<SMGObject>();
        this.nonSharedValuesFromSMG1 = new HashSet<SMGValue>();
        this.nonSharedValuesFromSMG2 = new HashSet<SMGValue>();
        for (Map.Entry entry : mapping1.getObject_mapEntrySet()) {
            if (!origObjects.contains(entry.getKey())) continue;
            this.nonSharedObjectsFromSMG1.add((SMGObject)entry.getKey());
        }
        for (Map.Entry entry : mapping2.getObject_mapEntrySet()) {
            if (!origObjects.contains(entry.getKey())) continue;
            this.nonSharedObjectsFromSMG2.add((SMGObject)entry.getKey());
        }
        for (Map.Entry entry : mapping1.getValue_mapEntrySet()) {
            if (!origValues.contains(entry.getKey())) continue;
            this.nonSharedValuesFromSMG1.add((SMGValue)entry.getKey());
        }
        for (Map.Entry entry : mapping2.getValue_mapEntrySet()) {
            if (!origValues.contains(entry.getKey())) continue;
            if (this.nonSharedValuesFromSMG1.contains(entry.getKey())) {
                this.nonSharedValuesFromSMG1.remove(entry.getKey());
                continue;
            }
            this.nonSharedValuesFromSMG2.add((SMGValue)entry.getKey());
        }
        this.nonSharedValuesFromSMG1.remove(SMGZeroValue.INSTANCE);
        this.nonSharedValuesFromSMG2.remove(SMGZeroValue.INSTANCE);
    }

    private boolean shouldAbstractionIncreaseLevel(SMGObject pObj1, SMGObject pObj2) {
        switch (pObj1.getKind()) {
            case REG: 
            case OPTIONAL: {
                switch (pObj2.getKind()) {
                    case REG: 
                    case OPTIONAL: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    private int getMinLength(SMGObject pObj) {
        switch (pObj.getKind()) {
            case REG: {
                return 1;
            }
            case DLL: {
                return ((SMGDoublyLinkedList)pObj).getMinimumLength();
            }
            case SLL: {
                return ((SMGSingleLinkedList)pObj).getMinimumLength();
            }
            case OPTIONAL: {
                return 0;
            }
        }
        throw new AssertionError();
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public UnmodifiableCLangSMG getResultSMG() {
        return this.resultSMG;
    }

    public SMGObject getNewAbstractObject() {
        return this.newAbstractObject;
    }

    public Set<SMGObject> getNonSharedObjectsFromSMG2() {
        return this.nonSharedObjectsFromSMG2;
    }

    public Set<SMGObject> getNonSharedObjectsFromSMG1() {
        return this.nonSharedObjectsFromSMG1;
    }

    public Set<SMGValue> getNonSharedValuesFromSMG1() {
        return this.nonSharedValuesFromSMG1;
    }

    public Set<SMGValue> getNonSharedValuesFromSMG2() {
        return this.nonSharedValuesFromSMG2;
    }
}

