/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedListShape;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.TestHelpers;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGsForAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentBiMap;
import org.sosy_lab.cpachecker.cpa.smg.util.PersistentSet;

public class SMGJoinSubSMGsForAbstractionTest {
    private static final LogManager logger = LogManager.createTestLogManager();

    @Test
    public void testJoinFirstTwoElementsOfSimpleList() throws SMGInconsistentException, InvalidConfigurationException {
        CLangSMG smg = new CLangSMG(MachineModel.LINUX64);
        SMGState smgState = new SMGState(logger, new SMGOptions(Configuration.defaultConfiguration()), smg, 0, PersistentBiMap.of());
        int NODE_SIZE = 64;
        int SEGMENT_LENGTH = 4;
        int OFFSET = 0;
        SMGEdgeHasValue root = TestHelpers.createGlobalList(smg, SEGMENT_LENGTH, NODE_SIZE, OFFSET, "pointer");
        SMGObject firstObject = smg.getPointer(root.getValue()).getObject();
        Truth.assertThat((Comparable)((Object)firstObject.getKind())).isSameInstanceAs((Object)SMGObjectKind.REG);
        SMGSingleLinkedListCandidate candidate = new SMGSingleLinkedListCandidate(firstObject, OFFSET, 0L, smg.getMachineModel().getSizeofInBits(CPointerType.POINTER_TO_VOID).longValueExact(), MachineModel.LINUX32);
        long nfo = ((SMGSingleLinkedListShape)candidate.getShape()).getNfo();
        SMGEdgeHasValue nextEdge = (SMGEdgeHasValue)Iterables.getOnlyElement(smg.getHVEdges(SMGEdgeHasValueFilter.objectFilter(firstObject).filterAtOffset(nfo).filterWithoutSize()));
        SMGObject secondObject = smg.getObjectPointedBy(nextEdge.getValue());
        Truth.assertThat((Comparable)((Object)secondObject.getKind())).isSameInstanceAs((Object)SMGObjectKind.REG);
        SMGJoinSubSMGsForAbstraction join = new SMGJoinSubSMGsForAbstraction(smg, firstObject, secondObject, candidate, smgState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isSameInstanceAs((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat(join.getNonSharedObjectsFromSMG1()).contains((Object)firstObject);
        Truth.assertThat(join.getNonSharedObjectsFromSMG1()).doesNotContain((Object)secondObject);
        Truth.assertThat(join.getNonSharedObjectsFromSMG2()).contains((Object)secondObject);
        Truth.assertThat(join.getNonSharedObjectsFromSMG2()).doesNotContain((Object)firstObject);
        SMGObject joinResult = join.getNewAbstractObject();
        Truth.assertThat((Boolean)joinResult.isAbstract()).isTrue();
        Truth.assertThat((Comparable)((Object)joinResult.getKind())).isSameInstanceAs((Object)SMGObjectKind.SLL);
        SMGSingleLinkedList resultSll = (SMGSingleLinkedList)joinResult;
        Truth.assertThat((Integer)resultSll.getMinimumLength()).isEqualTo((Object)2);
        UnmodifiableCLangSMG resultSMG = join.getResultSMG();
        PersistentSet<SMGObject> resultHeapObjects = resultSMG.getHeapObjects();
        Truth.assertThat((Boolean)resultHeapObjects.contains(joinResult)).isTrue();
        Truth.assertThat((Boolean)resultHeapObjects.contains(firstObject)).isTrue();
        Truth.assertThat((Boolean)resultHeapObjects.contains(secondObject)).isTrue();
        Truth.assertThat(SMGUtils.getPointerToThisObject(resultSll, resultSMG)).isEmpty();
    }
}

