/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdge;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstraction;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.GenericAbstractionCandidateTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.MaterlisationStep;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeHasValueTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeHasValueTemplateWithConcreteValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgePointsToTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGEdgeTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGObjectTemplate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

public class SMGJoinSubSMGsIntoGenericAbstraction {
    private final MachineModel machineModel;
    private final GenericAbstractionCandidateTemplate template;
    private final UnmodifiableSMG inputSMG1;
    private final UnmodifiableSMG inputSMG2;
    private final SMGObject rootObject1;
    private final SMGObject rootObject2;
    private final SMGNodeMapping mapping1;
    private final SMGNodeMapping mapping2;
    private final Map<SMGValue, List<GenericAbstractionCandidate>> previouslyMatched;

    public SMGJoinSubSMGsIntoGenericAbstraction(MachineModel pMachineModel, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, GenericAbstractionCandidateTemplate pTemplate, SMGObject pRootObject1, SMGObject pRootObject2, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, Map<SMGValue, List<GenericAbstractionCandidate>> pValueAbstractionCandidates) {
        this.machineModel = pMachineModel;
        this.template = pTemplate;
        this.inputSMG1 = pInputSMG1;
        this.inputSMG2 = pInputSMG2;
        this.rootObject1 = pRootObject1;
        this.rootObject2 = pRootObject2;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.previouslyMatched = pValueAbstractionCandidates;
    }

    public Optional<GenericAbstractionCandidate> joinSubSmgsIntoGenericAbstractionCandidate() {
        MatchResult matchResult = this.subSMGmatchSpecificShape(this.inputSMG1, this.rootObject1, this.mapping1, this.template, new HashSet<SMGObject>());
        if (!matchResult.isMatch()) {
            return Optional.empty();
        }
        MatchResult matchResult2 = this.subSMGmatchSpecificShape(this.inputSMG2, this.rootObject2, this.mapping2, this.template, new HashSet<SMGObject>());
        if (!matchResult.isMatch()) {
            return Optional.empty();
        }
        return this.createGenericAbstractionCandidate(matchResult, matchResult2);
    }

    private Optional<GenericAbstractionCandidate> createGenericAbstractionCandidate(MatchResult pMatchResult, MatchResult pMatchResult2) {
        MatchResultBuilder builder = new MatchResultBuilder(this.template);
        builder.getAbstractToConcretePointerMap().putAll(pMatchResult.getAbstractToConcretePointerMap());
        for (Map.Entry<SMGValue, SMGValue> entry : pMatchResult.getAbstractToConcretePointerMapInputSMG().entrySet()) {
            SMGValue absVal = entry.getKey();
            SMGValue val = entry.getValue();
            if (this.mapping1.containsKey(val)) {
                builder.putAbstractToConcretePointerMap(absVal, this.mapping1.get(val));
                continue;
            }
            return Optional.empty();
        }
        builder.getObjectsToBeRemovedForAbstraction().addAll(pMatchResult.getObjectsToBeRemovedForAbstraction());
        for (SMGObject obj : pMatchResult.getObjectsToBeRemovedForAbstractionInputSMG()) {
            if (!this.mapping1.containsKey(obj)) continue;
            builder.addObjectsToBeRemovedForAbstraction(this.mapping1.get(obj));
        }
        for (SMGObject obj : pMatchResult2.getObjectsToBeRemovedForAbstractionInputSMG()) {
            if (!this.mapping2.containsKey(obj) || builder.getObjectsToBeRemovedForAbstraction().contains(this.mapping2.get(obj))) continue;
            return Optional.empty();
        }
        int score = Math.max(pMatchResult.getScore(), pMatchResult2.getScore());
        MatchResult destres = builder.build();
        return Optional.of(GenericAbstractionCandidate.valueOf(this.machineModel, destres.getObjectsToBeRemovedForAbstraction(), destres.getAbstractToConcretePointerMap(), this.template.getMaterlisationStepMap(), score));
    }

    private MatchResult subSMGmatchSpecificShape(UnmodifiableSMG pInputSMG, SMGObject pRootObject, SMGNodeMapping pMapping, GenericAbstractionCandidateTemplate pTemplate, Set<SMGObject> pAlreadyVisited) {
        if (pRootObject instanceof GenericAbstraction) {
            return this.subSMGmatchSpecificShape((GenericAbstraction)pRootObject, pTemplate, pAlreadyVisited);
        }
        if (pRootObject instanceof SMGRegion) {
            return this.subSMGmatchSpecificShape(pInputSMG, pRootObject, pMapping, pTemplate, pAlreadyVisited);
        }
        return MatchResult.getUnknownInstance();
    }

    private MatchResult subSMGmatchSpecificShape(GenericAbstraction pRootObject, GenericAbstractionCandidateTemplate pTemplate, Set<SMGObject> pAlreadyVisited) {
        GenericAbstractionCandidateTemplate rootObjectTemaplate = pRootObject.createCandidateTemplate(this.machineModel);
        if (rootObjectTemaplate.isSpecificShape(pTemplate)) {
            return MatchResult.valueOf(this.machineModel, pRootObject);
        }
        return MatchResult.getUnknownInstance();
    }

    private MatchResult subSMGmatchSpecificShape(UnmodifiableSMG pInputSMG, SMGRegion pRootObject, SMGNodeMapping pMapping, GenericAbstractionCandidateTemplate pTemplate, Set<SMGObject> pAlreadyVisited) {
        MatchResult matchedPreviously = this.wasMatchedPreviously(pInputSMG, pRootObject, pTemplate, pMapping);
        if (matchedPreviously.isMatch()) {
            return matchedPreviously;
        }
        Set<MaterlisationStep> toBeChecked = pTemplate.getMaterlisationSteps();
        HashSet<MaterlisationStep> stopStep = new HashSet<MaterlisationStep>();
        MatchResult result = MatchResult.getUnknownInstance();
        for (MaterlisationStep matStep : toBeChecked) {
            if (!matStep.isStopStep()) {
                result = this.subSMGmatchStep(matStep, pInputSMG, pRootObject, pMapping, pAlreadyVisited, pTemplate);
                if (!result.isMatch()) continue;
                return result;
            }
            stopStep.add(matStep);
        }
        for (MaterlisationStep matStep : stopStep) {
            result = this.subSMGmatchStep(matStep, pInputSMG, pRootObject, pMapping, pAlreadyVisited, pTemplate);
            if (!result.isMatch()) continue;
            return result;
        }
        return result;
    }

    private MatchResult subSMGmatchStep(MaterlisationStep pMatStep, UnmodifiableSMG pInputSMG, SMGRegion pRootObject, SMGNodeMapping pMapping, Set<SMGObject> pAlreadyVisited, GenericAbstractionCandidateTemplate pTemplate) {
        Set<SMGRegion> entryRegions = pMatStep.getEntryRegions();
        HashSet<SMGObject> alreadyVisited = new HashSet<SMGObject>(pAlreadyVisited);
        for (SMGObjectTemplate sMGObjectTemplate : entryRegions) {
            MatchResult result = this.subSMGmatchStep(pMatStep, pInputSMG, pRootObject, sMGObjectTemplate, pMapping, alreadyVisited, pTemplate);
            if (!result.isMatch()) continue;
            return result;
        }
        return MatchResult.getUnknownInstance();
    }

    private MatchResult subSMGmatchStep(MaterlisationStep pMatStep, UnmodifiableSMG pInputSMG, SMGRegion pRootObject, SMGObjectTemplate pEntryRegion, SMGNodeMapping pMapping, Set<SMGObject> pAlreadyVisited, GenericAbstractionCandidateTemplate pTemplate) {
        if (pEntryRegion instanceof GenericAbstractionCandidateTemplate) {
            return MatchResult.getUnknownInstance();
        }
        MaterilisationStepToSubSMGMap templateToInputSmgMapping = new MaterilisationStepToSubSMGMap();
        templateToInputSmgMapping.put(pEntryRegion, pRootObject);
        pAlreadyVisited.add(pRootObject);
        HashSet<SMGNodeTemplateAndNode> toBeMatchedLater = new HashSet<SMGNodeTemplateAndNode>();
        toBeMatchedLater.add(new SMGNodeTemplateAndNode(new SMGNodeTemplate(pEntryRegion), new SMGNode(pRootObject)));
        while (!toBeMatchedLater.isEmpty()) {
            ImmutableSet toBeMatched = ImmutableSet.copyOf(toBeMatchedLater);
            toBeMatchedLater = new HashSet();
            for (SMGNodeTemplateAndNode templateNodeAndConcreteNode : toBeMatched) {
                SMGNodeTemplate nodeTemplate;
                SMGNode node = templateNodeAndConcreteNode.getNode();
                boolean match = this.matchNodeTemplateWithNode(node, nodeTemplate = templateNodeAndConcreteNode.getNodeTemplate(), pMatStep, templateToInputSmgMapping, pInputSMG, toBeMatchedLater, pAlreadyVisited, pMapping);
                if (match) continue;
                return MatchResult.getUnknownInstance();
            }
        }
        MatchResult result = this.constructAbstraction(pTemplate, templateToInputSmgMapping, pMatStep);
        return result;
    }

    private MatchResult constructAbstraction(GenericAbstractionCandidateTemplate pTemplate, MaterilisationStepToSubSMGMap pTemplateToInputSmgMapping, MaterlisationStep pMatStep) {
        MatchResultBuilder matchResultBuilder = new MatchResultBuilder(pTemplate);
        matchResultBuilder.setMatchTrue();
        for (SMGObject sMGObject : pTemplateToInputSmgMapping.objectTemplateToObject.values()) {
            matchResultBuilder.addObjectsToBeRemovedForAbstractionInputSMG(sMGObject);
        }
        for (Map.Entry entry : pTemplateToInputSmgMapping.getValueTemplateToValue().entrySet()) {
            SMGValue absVal = (SMGValue)entry.getKey();
            SMGValue conVal = (SMGValue)entry.getValue();
            if (!pMatStep.abstractInterfaceContains(absVal)) continue;
            matchResultBuilder.putAbstractToConcretePointerMapInputSMG(absVal, conVal);
        }
        int score = 0;
        for (MatchResult prevAbs : pTemplateToInputSmgMapping.getAbstractionToMatchMap().values()) {
            matchResultBuilder.getObjectsToBeRemovedForAbstraction().addAll(prevAbs.getObjectsToBeRemovedForAbstraction());
            matchResultBuilder.getObjectsToBeRemovedForAbstractionInputSMG().addAll(prevAbs.getObjectsToBeRemovedForAbstractionInputSMG());
            if (prevAbs.getScore() <= score) continue;
            score = prevAbs.getScore();
        }
        matchResultBuilder.setScore(++score);
        return matchResultBuilder.build();
    }

    private boolean matchNodeTemplateWithNode(SMGNode pNode, SMGNodeTemplate pNodeTemplate, MaterlisationStep pMatStep, MaterilisationStepToSubSMGMap pTemplateToInputSmgMapping, UnmodifiableSMG pInputSMG, Set<SMGNodeTemplateAndNode> pToBeMatchedLater, Set<SMGObject> pAlreadyVisited, SMGNodeMapping pMapping) {
        if (pNode.isValue() && pNodeTemplate.isValueTemplate()) {
            return this.matchValueTemplateWithValue(pNode.getValue(), pNodeTemplate.getValueTemplate(), pMatStep, pTemplateToInputSmgMapping, pInputSMG, pToBeMatchedLater, pAlreadyVisited, pMapping);
        }
        if (pNode.isObject() && pNodeTemplate.isObjectTemplate()) {
            SMGObject object = pNode.getObject();
            SMGObjectTemplate objectTemplate = pNodeTemplate.getObjectTemplate();
            if (objectTemplate instanceof GenericAbstractionCandidateTemplate) {
                GenericAbstractionCandidateTemplate genAbsTmp = (GenericAbstractionCandidateTemplate)objectTemplate;
                return this.matchGenericAbstractionTemplateWithGenericAbstraction(genAbsTmp, pInputSMG, pToBeMatchedLater, pTemplateToInputSmgMapping, pMatStep);
            }
            if (objectTemplate instanceof SMGRegion) {
                SMGRegion regionTemplate = (SMGRegion)objectTemplate;
                return this.matchRegionTemplateWithObject(regionTemplate, object, pInputSMG, pToBeMatchedLater, pTemplateToInputSmgMapping, pMatStep);
            }
        }
        return false;
    }

    private boolean matchGenericAbstractionTemplateWithGenericAbstraction(GenericAbstractionCandidateTemplate pGenAbsTmp, UnmodifiableSMG pInputSMG, Set<SMGNodeTemplateAndNode> pToBeMatchedLater, MaterilisationStepToSubSMGMap pTemplateToInputSmgMapping, MaterlisationStep pMatStep) {
        if (!pTemplateToInputSmgMapping.containsAbstraction(pGenAbsTmp)) {
            return false;
        }
        MatchResult genAbsMatchResult = pTemplateToInputSmgMapping.getAbstraction(pGenAbsTmp);
        if (!genAbsMatchResult.isMatch()) {
            return false;
        }
        Set<SMGEdgePointsTo> pointerToAbstraction = this.getPointerToThisAbstraction(genAbsMatchResult, pInputSMG);
        Set<SMGEdgePointsToTemplate> pointerToRegionTemplate = pMatStep.getPointerToThisTemplate(pGenAbsTmp);
        if (pointerToAbstraction.size() != pointerToRegionTemplate.size()) {
            return false;
        }
        ImmutableMap pointerToRegionMap = Maps.uniqueIndex(pointerToAbstraction, SMGEdge::getOffset);
        ImmutableMap pointerToRegionTemplateMap = Maps.uniqueIndex(pointerToRegionTemplate, SMGEdgeTemplate::getOffset);
        for (Map.Entry ptEntry : pointerToRegionTemplateMap.entrySet()) {
            long offset = (Long)ptEntry.getKey();
            SMGEdgePointsToTemplate pointerTemplateEdge = (SMGEdgePointsToTemplate)ptEntry.getValue();
            if (!pointerToRegionMap.containsKey(offset)) {
                return false;
            }
            SMGValue pointerTemplate = pointerTemplateEdge.getAbstractValue();
            SMGValue pointer = ((SMGEdgePointsTo)pointerToRegionMap.get(offset)).getValue();
            if (pTemplateToInputSmgMapping.contains(pointerTemplate)) {
                if (pTemplateToInputSmgMapping.get(pointerTemplate).equals(pointer)) continue;
                return false;
            }
            pTemplateToInputSmgMapping.put(pointerTemplate, pointer);
            if (!pMatStep.getAbstractPointers().contains(pointerTemplateEdge)) continue;
            pToBeMatchedLater.add(new SMGNodeTemplateAndNode(pointerTemplate, pointer));
        }
        Set<SMGEdgeHasValue> fieldsOfRegion = this.getFieldsOfGenAbs(genAbsMatchResult, pInputSMG);
        MaterlisationStep.FieldsOfTemplate fieldsOfTemplate = pMatStep.getFieldsOfThisTemplate(pGenAbsTmp);
        if (fieldsOfRegion.size() != fieldsOfTemplate.size()) {
            return false;
        }
        ImmutableMap fieldsOfRegionMap = Maps.uniqueIndex(fieldsOfRegion, SMGEdge::getOffset);
        HashSet<SMGEdgeHasValueTemplate> fieldsOfTemplateSet = new HashSet<SMGEdgeHasValueTemplate>(fieldsOfTemplate.getFieldTemplateContainingPointer());
        fieldsOfTemplateSet.addAll(fieldsOfTemplate.getFieldTemplateContainingPointerTemplate());
        ImmutableMap fieldsOfRegionTemplateMap = Maps.uniqueIndex(fieldsOfTemplateSet, SMGEdgeTemplate::getOffset);
        ImmutableMap fieldsOfRegionTemplateCVMap = Maps.uniqueIndex(fieldsOfTemplate.getFieldTemplateContainingValue(), SMGEdgeHasValueTemplateWithConcreteValue::getOffset);
        for (Map.Entry hveEntry : fieldsOfRegionMap.entrySet()) {
            long offset = (Long)hveEntry.getKey();
            SMGEdgeHasValue hve = (SMGEdgeHasValue)hveEntry.getValue();
            if (fieldsOfRegionTemplateMap.containsKey(offset)) {
                SMGValue pointerTemplate = ((SMGEdgeHasValueTemplate)fieldsOfRegionTemplateMap.get(offset)).getAbstractValue();
                SMGValue pointer = hve.getValue();
                if (pTemplateToInputSmgMapping.contains(pointerTemplate)) {
                    if (pTemplateToInputSmgMapping.get(pointerTemplate) == pointer) continue;
                    return false;
                }
                pTemplateToInputSmgMapping.put(pointerTemplate, pointer);
                if (!pMatStep.getAbstractFieldsToIPointer().contains(fieldsOfRegionTemplateMap.get(offset))) continue;
                pToBeMatchedLater.add(new SMGNodeTemplateAndNode(pointerTemplate, pointer));
                continue;
            }
            if (fieldsOfRegionTemplateCVMap.containsKey(offset)) {
                SMGValue valueInTemplate;
                SMGValue value = hve.getValue();
                if (value == (valueInTemplate = ((SMGEdgeHasValueTemplateWithConcreteValue)fieldsOfRegionTemplateCVMap.get(offset)).getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private Set<SMGEdgeHasValue> getFieldsOfGenAbs(MatchResult pGenAbsMatchResult, UnmodifiableSMG pInputSMG) {
        GenericAbstractionCandidateTemplate abstractionTemplate = pGenAbsMatchResult.getGenAbsTemplate();
        Map<SMGValue, SMGValue> abstractToConcreteMap = pGenAbsMatchResult.getAbstractToConcretePointerMapInputSMG();
        Set<SMGEdgeHasValueTemplate> pointerToThisAbstraction = abstractionTemplate.getMaterlisationSteps().iterator().next().getAbstractFieldsToOPointer();
        HashSet<SMGEdgeHasValue> result = new HashSet<SMGEdgeHasValue>();
        for (SMGEdgeHasValueTemplate fieldTmp : pointerToThisAbstraction) {
            SMGValue absVal = fieldTmp.getAbstractValue();
            SMGValue concreteValue = abstractToConcreteMap.get(absVal);
            Iterables.addAll(result, SMGUtils.getFieldsofThisValue(concreteValue, pInputSMG));
        }
        return result;
    }

    private Set<SMGEdgePointsTo> getPointerToThisAbstraction(MatchResult pGenAbsMatchResult, UnmodifiableSMG pInputSMG) {
        GenericAbstractionCandidateTemplate abstractionTemplate = pGenAbsMatchResult.getGenAbsTemplate();
        Map<SMGValue, SMGValue> abstractToConcreteMap = pGenAbsMatchResult.getAbstractToConcretePointerMapInputSMG();
        Set<SMGEdgePointsToTemplate> pointerToThisAbstraction = abstractionTemplate.getMaterlisationSteps().iterator().next().getAbstractAdressesToOPointer();
        HashSet<SMGEdgePointsTo> result = new HashSet<SMGEdgePointsTo>();
        for (SMGEdgePointsToTemplate pointerTmp : pointerToThisAbstraction) {
            SMGValue absVal = pointerTmp.getAbstractValue();
            SMGValue concreteValue = abstractToConcreteMap.get(absVal);
            result.add(pInputSMG.getPointer(concreteValue));
        }
        return result;
    }

    private boolean matchValueTemplateWithValue(SMGValue pValue, SMGValue pValueTemplate, MaterlisationStep pMatStep, MaterilisationStepToSubSMGMap pTemplateToInputSmgMapping, UnmodifiableSMG pInputSMG, Set<SMGNodeTemplateAndNode> pToBeMatchedLater, Set<SMGObject> pAlreadyVisited, SMGNodeMapping pMapping) {
        if (!pTemplateToInputSmgMapping.contains(pValueTemplate) || pTemplateToInputSmgMapping.get(pValueTemplate) != pValue) {
            return false;
        }
        if (pInputSMG.isPointer(pValue)) {
            SMGEdgePointsTo pointerEdge = pInputSMG.getPointer(pValue);
            Optional<SMGEdgePointsToTemplate> pointerEdgeTemplateOpt = pMatStep.getPointer(pValueTemplate);
            if (!pointerEdgeTemplateOpt.isPresent()) {
                return false;
            }
            SMGEdgePointsToTemplate pointerEdgeTemplate = pointerEdgeTemplateOpt.orElseThrow();
            if (pointerEdgeTemplate.getOffset() != pointerEdge.getOffset()) {
                return false;
            }
            SMGObjectTemplate targetTemplate = pointerEdgeTemplate.getObjectTemplate();
            SMGObject target = pointerEdge.getObject();
            if (pTemplateToInputSmgMapping.contains(targetTemplate)) {
                SMGObject mappedTarget = pTemplateToInputSmgMapping.get(targetTemplate);
                if (mappedTarget != target) {
                    return false;
                }
            } else if (targetTemplate instanceof GenericAbstractionCandidateTemplate) {
                MatchResult result;
                GenericAbstractionCandidateTemplate genAbs = (GenericAbstractionCandidateTemplate)targetTemplate;
                if (pTemplateToInputSmgMapping.containsAbstraction(genAbs)) {
                    result = pTemplateToInputSmgMapping.getAbstraction(genAbs);
                } else {
                    result = this.subSMGmatchSpecificShape(pInputSMG, target, pMapping, genAbs, pAlreadyVisited);
                    pTemplateToInputSmgMapping.putAbstraction(genAbs, result);
                    pToBeMatchedLater.add(new SMGNodeTemplateAndNode(targetTemplate, target));
                }
                if (!result.isMatch()) {
                    return false;
                }
            } else {
                pAlreadyVisited.add(target);
                pToBeMatchedLater.add(new SMGNodeTemplateAndNode(targetTemplate, target));
                pTemplateToInputSmgMapping.put(targetTemplate, target);
            }
        } else if (pMatStep.getPointer(pValueTemplate).isPresent()) {
            return false;
        }
        Iterable<SMGEdgeHasValue> fields = SMGUtils.getFieldsofThisValue(pValue, pInputSMG);
        Set<SMGEdgeHasValueTemplate> fieldsTemplate = pMatStep.getFieldsOfValue(pValueTemplate);
        if (Iterables.size(fields) != fieldsTemplate.size()) {
            return false;
        }
        ImmutableMap fieldOffsetMap = Maps.uniqueIndex(fields, SMGEdge::getOffset);
        ImmutableMap fieldOffsetTemplateMap = Maps.uniqueIndex(fieldsTemplate, SMGEdgeTemplate::getOffset);
        for (Map.Entry hveTmpEntry : fieldOffsetTemplateMap.entrySet()) {
            long offset = (Long)hveTmpEntry.getKey();
            SMGEdgeHasValueTemplate pointerEdgeTemplate = (SMGEdgeHasValueTemplate)hveTmpEntry.getValue();
            if (!fieldOffsetMap.containsKey(offset)) {
                return false;
            }
            SMGEdgeHasValue pointerEdge = (SMGEdgeHasValue)fieldOffsetMap.get(offset);
            SMGObjectTemplate targetTemplate = pointerEdgeTemplate.getObjectTemplate();
            SMGObject target = pointerEdge.getObject();
            if (pTemplateToInputSmgMapping.contains(targetTemplate)) {
                SMGObject mappedTarget = pTemplateToInputSmgMapping.get(targetTemplate);
                if (mappedTarget == target) continue;
                return false;
            }
            if (targetTemplate instanceof GenericAbstractionCandidateTemplate) {
                MatchResult result;
                GenericAbstractionCandidateTemplate genAbs = (GenericAbstractionCandidateTemplate)targetTemplate;
                if (pTemplateToInputSmgMapping.containsAbstraction(genAbs)) {
                    result = pTemplateToInputSmgMapping.getAbstraction(genAbs);
                } else {
                    result = this.subSMGmatchSpecificShape(pInputSMG, target, pMapping, genAbs, pAlreadyVisited);
                    pTemplateToInputSmgMapping.putAbstraction(genAbs, result);
                    pToBeMatchedLater.add(new SMGNodeTemplateAndNode(targetTemplate, target));
                }
                if (result.isMatch()) continue;
                return false;
            }
            pAlreadyVisited.add(target);
            pToBeMatchedLater.add(new SMGNodeTemplateAndNode(targetTemplate, target));
            pTemplateToInputSmgMapping.put(targetTemplate, target);
        }
        return true;
    }

    private boolean matchRegionTemplateWithObject(SMGRegion pTemplate, SMGObject pObject, UnmodifiableSMG pInputSMG, Set<SMGNodeTemplateAndNode> pToBeMatchedLater, MaterilisationStepToSubSMGMap pMatStepToSubSMGMapping, MaterlisationStep matStep) {
        if (!(pObject instanceof SMGRegion)) {
            return false;
        }
        SMGRegion region = (SMGRegion)pObject;
        if (region.getSize() != pTemplate.getSize()) {
            return false;
        }
        Set<SMGEdgePointsTo> pointerToRegion = SMGUtils.getPointerToThisObject(region, pInputSMG);
        Set<SMGEdgePointsToTemplate> pointerToRegionTemplate = matStep.getPointerToThisTemplate(pTemplate);
        if (pointerToRegion.size() != pointerToRegionTemplate.size()) {
            return false;
        }
        ImmutableMap pointerToRegionMap = Maps.uniqueIndex(pointerToRegion, SMGEdge::getOffset);
        ImmutableMap pointerToRegionTemplateMap = Maps.uniqueIndex(pointerToRegionTemplate, SMGEdgeTemplate::getOffset);
        for (Map.Entry pteTmp : pointerToRegionTemplateMap.entrySet()) {
            long offset = (Long)pteTmp.getKey();
            SMGEdgePointsToTemplate ptTmp = (SMGEdgePointsToTemplate)pteTmp.getValue();
            if (!pointerToRegionMap.containsKey(offset)) {
                return false;
            }
            SMGValue pointerTemplate = ptTmp.getAbstractValue();
            SMGValue pointer = ((SMGEdgePointsTo)pointerToRegionMap.get(offset)).getValue();
            if (pMatStepToSubSMGMapping.contains(pointerTemplate)) {
                if (pMatStepToSubSMGMapping.get(pointerTemplate).equals(pointer)) continue;
                return false;
            }
            pMatStepToSubSMGMapping.put(pointerTemplate, pointer);
            if (!matStep.getAbstractPointers().contains(ptTmp)) continue;
            pToBeMatchedLater.add(new SMGNodeTemplateAndNode(pointerTemplate, pointer));
        }
        SMGHasValueEdges fieldsOfRegion = SMGUtils.getFieldsOfObject(region, pInputSMG);
        MaterlisationStep.FieldsOfTemplate fieldsOfTemplate = matStep.getFieldsOfThisTemplate(pTemplate);
        if (fieldsOfRegion.size() != fieldsOfTemplate.size()) {
            return false;
        }
        ImmutableMap fieldsOfRegionMap = Maps.uniqueIndex((Iterable)fieldsOfRegion, SMGEdge::getOffset);
        HashSet<SMGEdgeHasValueTemplate> fieldsOfTemplateSet = new HashSet<SMGEdgeHasValueTemplate>(fieldsOfTemplate.getFieldTemplateContainingPointer());
        fieldsOfTemplateSet.addAll(fieldsOfTemplate.getFieldTemplateContainingPointerTemplate());
        ImmutableMap fieldsOfRegionTemplateMap = Maps.uniqueIndex(fieldsOfTemplateSet, SMGEdgeTemplate::getOffset);
        ImmutableMap fieldsOfRegionTemplateCVMap = Maps.uniqueIndex(fieldsOfTemplate.getFieldTemplateContainingValue(), SMGEdgeHasValueTemplateWithConcreteValue::getOffset);
        for (Map.Entry hveEntry : fieldsOfRegionMap.entrySet()) {
            long offset = (Long)hveEntry.getKey();
            SMGEdgeHasValue hve = (SMGEdgeHasValue)hveEntry.getValue();
            if (fieldsOfRegionTemplateMap.containsKey(offset)) {
                SMGValue pointerTemplate = ((SMGEdgeHasValueTemplate)fieldsOfRegionTemplateMap.get(offset)).getAbstractValue();
                SMGValue pointer = hve.getValue();
                if (pMatStepToSubSMGMapping.contains(pointerTemplate)) {
                    if (pMatStepToSubSMGMapping.get(pointerTemplate).equals(pointer)) continue;
                    return false;
                }
                pMatStepToSubSMGMapping.put(pointerTemplate, pointer);
                if (!matStep.getAbstractFieldsToIPointer().contains(fieldsOfRegionTemplateMap.get(offset))) continue;
                pToBeMatchedLater.add(new SMGNodeTemplateAndNode(pointerTemplate, pointer));
                continue;
            }
            if (fieldsOfRegionTemplateCVMap.containsKey(offset)) {
                SMGValue valueInTemplate;
                SMGValue value = hve.getValue();
                if (value == (valueInTemplate = ((SMGEdgeHasValueTemplateWithConcreteValue)fieldsOfRegionTemplateCVMap.get(offset)).getValue())) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private MatchResult wasMatchedPreviously(UnmodifiableSMG pInputSMG, SMGObject pRootObject, GenericAbstractionCandidateTemplate pTemplate, SMGNodeMapping pMapping) {
        Set<SMGEdgePointsTo> pointsToThisObject = SMGUtils.getPointerToThisObject(pRootObject, pInputSMG);
        for (SMGEdgePointsTo pointer : pointsToThisObject) {
            SMGValue destPointerValue;
            if (!pMapping.containsKey(pointer.getValue()) || !this.previouslyMatched.containsKey(destPointerValue = pMapping.get(pointer.getValue()))) continue;
            for (GenericAbstractionCandidate abstractionCandidate : this.previouslyMatched.get(destPointerValue)) {
                if (!pTemplate.equals(abstractionCandidate.createTemplate(this.machineModel))) continue;
                return MatchResult.valueOf(this.machineModel, abstractionCandidate);
            }
        }
        return MatchResult.getUnknownInstance();
    }

    private static class MaterilisationStepToSubSMGMap {
        private final Map<SMGObjectTemplate, SMGObject> objectTemplateToObject = new HashMap<SMGObjectTemplate, SMGObject>();
        private final Map<SMGValue, SMGValue> valueTemplateToValue = new HashMap<SMGValue, SMGValue>();
        private final Map<GenericAbstractionCandidateTemplate, MatchResult> abstractionToMatchMap = new HashMap<GenericAbstractionCandidateTemplate, MatchResult>();

        public void putAbstraction(GenericAbstractionCandidateTemplate pGenAbs, MatchResult pResult) {
            this.getAbstractionToMatchMap().put(pGenAbs, pResult);
        }

        public void put(SMGObjectTemplate objectTemplate, SMGObject object) {
            this.getObjectTemplateToObject().put(objectTemplate, object);
        }

        public void put(SMGValue abstractValue, SMGValue value) {
            this.getValueTemplateToValue().put(abstractValue, value);
        }

        public boolean contains(SMGObjectTemplate object) {
            return this.getObjectTemplateToObject().containsKey(object);
        }

        public boolean contains(SMGValue abstractValue) {
            return this.getValueTemplateToValue().containsKey(abstractValue);
        }

        public boolean containsAbstraction(GenericAbstractionCandidateTemplate abstractionTemplate) {
            return this.getAbstractionToMatchMap().containsKey(abstractionTemplate);
        }

        public MatchResult getAbstraction(GenericAbstractionCandidateTemplate template) {
            return this.getAbstractionToMatchMap().get(template);
        }

        public SMGObject get(SMGObjectTemplate object) {
            return this.getObjectTemplateToObject().get(object);
        }

        public SMGValue get(SMGValue abstractValue) {
            return this.getValueTemplateToValue().get(abstractValue);
        }

        public Map<SMGObjectTemplate, SMGObject> getObjectTemplateToObject() {
            return this.objectTemplateToObject;
        }

        public Map<SMGValue, SMGValue> getValueTemplateToValue() {
            return this.valueTemplateToValue;
        }

        public Map<GenericAbstractionCandidateTemplate, MatchResult> getAbstractionToMatchMap() {
            return this.abstractionToMatchMap;
        }
    }

    private static class SMGNodeTemplate {
        private final @Nullable SMGValue valueTemplate;
        private final SMGObjectTemplate objectTemplate;

        public SMGNodeTemplate(SMGValue pValueTemplate) {
            this.valueTemplate = (SMGValue)Preconditions.checkNotNull((Object)pValueTemplate);
            this.objectTemplate = null;
        }

        public SMGNodeTemplate(SMGObjectTemplate pObject) {
            this.valueTemplate = null;
            this.objectTemplate = (SMGObjectTemplate)Preconditions.checkNotNull((Object)pObject);
        }

        public boolean isValueTemplate() {
            return this.valueTemplate != null;
        }

        public SMGValue getValueTemplate() {
            return this.valueTemplate;
        }

        public boolean isObjectTemplate() {
            return this.objectTemplate != null;
        }

        public SMGObjectTemplate getObjectTemplate() {
            return this.objectTemplate;
        }
    }

    private static class SMGNode {
        private final @Nullable SMGValue value;
        private final SMGObject object;

        public SMGNode(SMGValue pValue) {
            this.value = (SMGValue)Preconditions.checkNotNull((Object)pValue);
            this.object = null;
        }

        public SMGNode(SMGObject pObject) {
            this.value = null;
            this.object = (SMGObject)Preconditions.checkNotNull((Object)pObject);
        }

        public boolean isValue() {
            return this.value != null;
        }

        public SMGValue getValue() {
            return this.value;
        }

        public boolean isObject() {
            return this.object != null;
        }

        public SMGObject getObject() {
            return this.object;
        }
    }

    private static class SMGNodeTemplateAndNode {
        private final SMGNode node;
        private final SMGNodeTemplate nodeTemplate;

        public SMGNodeTemplateAndNode(SMGNodeTemplate pNodeTemplate, SMGNode pNode) {
            this.node = pNode;
            this.nodeTemplate = pNodeTemplate;
        }

        public SMGNodeTemplateAndNode(SMGValue pointerTemplate, SMGValue pointer) {
            this.node = new SMGNode(pointer);
            this.nodeTemplate = new SMGNodeTemplate(pointerTemplate);
        }

        public SMGNodeTemplateAndNode(SMGObjectTemplate objectTemplate, SMGObject object) {
            this.node = new SMGNode(object);
            this.nodeTemplate = new SMGNodeTemplate(objectTemplate);
        }

        public SMGNode getNode() {
            return this.node;
        }

        public SMGNodeTemplate getNodeTemplate() {
            return this.nodeTemplate;
        }
    }

    private static class MatchResult {
        private static final MatchResult UNKNOWN = new MatchResult(false, null, 0, null, null, null, null);
        private final boolean match;
        private final Set<SMGObject> objectsToBeRemovedForAbstraction;
        private final Set<SMGObject> objectsToBeRemovedForAbstractionInputSMG;
        private final int score;
        private final Map<SMGValue, SMGValue> abstractToConcretePointerMap;
        private final Map<SMGValue, SMGValue> abstractToConcretePointerMapInputSMG;
        private final GenericAbstractionCandidateTemplate template;

        public MatchResult(boolean pMatche, Set<SMGObject> pObjectsToBeRemovedForAbstraction, int pScore, Map<SMGValue, SMGValue> pAbstractToConcretePointerMap, Set<SMGObject> pObjectsToBeRemovedForAbstractionInputSMG, Map<SMGValue, SMGValue> pAbstractToConcretePointerMapInputSMG, GenericAbstractionCandidateTemplate pTemplate) {
            this.match = pMatche;
            this.objectsToBeRemovedForAbstraction = pObjectsToBeRemovedForAbstraction;
            this.objectsToBeRemovedForAbstractionInputSMG = pObjectsToBeRemovedForAbstractionInputSMG;
            this.score = pScore;
            this.abstractToConcretePointerMap = pAbstractToConcretePointerMap;
            this.abstractToConcretePointerMapInputSMG = pAbstractToConcretePointerMapInputSMG;
            this.template = pTemplate;
        }

        public GenericAbstractionCandidateTemplate getGenAbsTemplate() {
            return this.template;
        }

        public MatchResult(MatchResultBuilder pMatchResultBuilder) {
            this.match = true;
            this.objectsToBeRemovedForAbstraction = pMatchResultBuilder.getObjectsToBeRemovedForAbstraction();
            this.objectsToBeRemovedForAbstractionInputSMG = pMatchResultBuilder.getObjectsToBeRemovedForAbstractionInputSMG();
            this.score = pMatchResultBuilder.getScore();
            this.abstractToConcretePointerMap = pMatchResultBuilder.getAbstractToConcretePointerMap();
            this.abstractToConcretePointerMapInputSMG = pMatchResultBuilder.getAbstractToConcretePointerMapInputSMG();
            this.template = pMatchResultBuilder.getGenAbsTemplate();
        }

        public static MatchResult valueOf(MachineModel pMachineModel, GenericAbstractionCandidate pAbstractionCandidate) {
            ImmutableMap abstractToConcretePointerMapInputSMG = ImmutableMap.of();
            ImmutableSet objectsToBeRemovedForAbstractionInputSMG = ImmutableSet.of();
            return new MatchResult(true, pAbstractionCandidate.getObjectsToBeRemoved(), pAbstractionCandidate.getScore(), pAbstractionCandidate.getAbstractToConcretePointerMap(), (Set<SMGObject>)objectsToBeRemovedForAbstractionInputSMG, (Map<SMGValue, SMGValue>)abstractToConcretePointerMapInputSMG, pAbstractionCandidate.createTemplate(pMachineModel));
        }

        public static MatchResult valueOf(MachineModel pMachineModel, GenericAbstraction pRootObject) {
            HashSet<SMGObject> toBeRemoved = new HashSet<SMGObject>();
            toBeRemoved.add(pRootObject);
            ImmutableSet emptySet = ImmutableSet.of();
            ImmutableMap emptyMap = ImmutableMap.of();
            return new MatchResult(true, (Set<SMGObject>)emptySet, 100, (Map<SMGValue, SMGValue>)emptyMap, (Set<SMGObject>)toBeRemoved, (Map<SMGValue, SMGValue>)pRootObject.getAbstractToConcretePointerMap(), pRootObject.createCandidateTemplate(pMachineModel));
        }

        public static MatchResult getUnknownInstance() {
            return UNKNOWN;
        }

        public Map<SMGValue, SMGValue> getAbstractToConcretePointerMap() {
            return this.abstractToConcretePointerMap;
        }

        public Set<SMGObject> getObjectsToBeRemovedForAbstraction() {
            return this.objectsToBeRemovedForAbstraction;
        }

        public Map<SMGValue, SMGValue> getAbstractToConcretePointerMapInputSMG() {
            return this.abstractToConcretePointerMapInputSMG;
        }

        public Set<SMGObject> getObjectsToBeRemovedForAbstractionInputSMG() {
            return this.objectsToBeRemovedForAbstractionInputSMG;
        }

        public boolean isMatch() {
            return this.match;
        }

        public int getScore() {
            return this.score;
        }
    }

    private static class MatchResultBuilder {
        private boolean match = false;
        private Set<SMGObject> objectsToBeRemovedForAbstraction = new HashSet<SMGObject>();
        private Set<SMGObject> objectsToBeRemovedForAbstractionInputSMG = new HashSet<SMGObject>();
        private int score = 0;
        private Map<SMGValue, SMGValue> abstractToConcretePointerMap = new HashMap<SMGValue, SMGValue>();
        private Map<SMGValue, SMGValue> abstractToConcretePointerMapInputSMG = new HashMap<SMGValue, SMGValue>();
        private final GenericAbstractionCandidateTemplate template;

        public MatchResultBuilder(GenericAbstractionCandidateTemplate pTemplate) {
            this.template = pTemplate;
        }

        public Set<SMGObject> getObjectsToBeRemovedForAbstraction() {
            return this.objectsToBeRemovedForAbstraction;
        }

        public void addObjectsToBeRemovedForAbstraction(SMGObject object) {
            this.objectsToBeRemovedForAbstraction.add(object);
        }

        public void setMatchTrue() {
            this.match = true;
        }

        public Set<SMGObject> getObjectsToBeRemovedForAbstractionInputSMG() {
            return this.objectsToBeRemovedForAbstractionInputSMG;
        }

        public void addObjectsToBeRemovedForAbstractionInputSMG(SMGObject object) {
            this.objectsToBeRemovedForAbstractionInputSMG.add(object);
        }

        public int getScore() {
            return this.score;
        }

        public void setScore(int pScore) {
            this.score = pScore;
        }

        public Map<SMGValue, SMGValue> getAbstractToConcretePointerMap() {
            return this.abstractToConcretePointerMap;
        }

        public void putAbstractToConcretePointerMap(SMGValue abstractValue, SMGValue concreteValue) {
            this.abstractToConcretePointerMap.put(abstractValue, concreteValue);
        }

        public Map<SMGValue, SMGValue> getAbstractToConcretePointerMapInputSMG() {
            return this.abstractToConcretePointerMapInputSMG;
        }

        public void putAbstractToConcretePointerMapInputSMG(SMGValue abstractValue, SMGValue concreteValue) {
            this.abstractToConcretePointerMapInputSMG.put(abstractValue, concreteValue);
        }

        public MatchResult build() {
            assert (this.match);
            return new MatchResult(this);
        }

        public GenericAbstractionCandidateTemplate getGenAbsTemplate() {
            return this.template;
        }
    }
}

