/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGGenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinLevel;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMapTargetAddress;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMatchObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinSubSMGs;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

final class SMGJoinTargetObjects {
    private SMGJoinStatus status;
    private boolean defined = false;
    private boolean recoverable = false;
    private final UnmodifiableSMG inputSMG1;
    private final UnmodifiableSMG inputSMG2;
    private SMG destSMG;
    private SMGValue value;
    @VisibleForTesting
    final SMGNodeMapping mapping1;
    @VisibleForTesting
    final SMGNodeMapping mapping2;
    private List<SMGGenericAbstractionCandidate> abstractionCandidates;

    private boolean matchOffsets(SMGEdgePointsTo pt1, SMGEdgePointsTo pt2) {
        if (pt1.getOffset() != pt2.getOffset()) {
            this.defined = false;
            this.recoverable = true;
            return true;
        }
        return false;
    }

    private boolean checkAlreadyJoined(SMGObject pObj1, SMGObject pObj2, SMGValue pAddress1, SMGValue pAddress2) {
        if (pObj1 == SMGNullObject.INSTANCE && pObj2 == SMGNullObject.INSTANCE || this.mapping1.containsKey(pObj1) && this.mapping2.containsKey(pObj2) && this.mapping1.get(pObj1) == this.mapping2.get(pObj2)) {
            SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pAddress1, pAddress2);
            this.defined = true;
            this.destSMG = mta.getSMG();
            this.value = mta.getValue();
            return true;
        }
        return false;
    }

    private boolean checkObjectMatch(SMGObject pObj1, SMGObject pObj2) {
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(this.status, this.inputSMG1, this.inputSMG2, this.mapping1, this.mapping2, pObj1, pObj2);
        if (!mo.isDefined()) {
            this.defined = false;
            this.recoverable = true;
            return true;
        }
        this.status = mo.getStatus();
        return false;
    }

    public SMGJoinTargetObjects(SMGJoinStatus pStatus, UnmodifiableSMG pSMG1, UnmodifiableSMG pSMG2, SMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGLevelMapping pLevelMapping, SMGValue pAddress1, SMGValue pAddress2, int pLevel1, int pLevel2, int ldiff, boolean identicalInputSmgs, UnmodifiableSMGState pSmgState1, UnmodifiableSMGState pSmgState2) throws SMGInconsistentException {
        SMGObject target2;
        this.inputSMG1 = pSMG1;
        this.inputSMG2 = pSMG2;
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.destSMG = pDestSMG;
        this.status = pStatus;
        SMGEdgePointsTo pt1 = this.inputSMG1.getPointer(pAddress1);
        SMGEdgePointsTo pt2 = this.inputSMG2.getPointer(pAddress2);
        if (pLevel1 - pLevel2 != ldiff) {
            this.defined = false;
            this.recoverable = true;
            return;
        }
        if (this.matchOffsets(pt1, pt2)) {
            this.abstractionCandidates = ImmutableList.of();
            return;
        }
        SMGObject target1 = pt1.getObject();
        if (this.checkAlreadyJoined(target1, target2 = pt2.getObject(), pAddress1, pAddress2)) {
            this.abstractionCandidates = ImmutableList.of();
            return;
        }
        if (target1.getKind() != target2.getKind() && this.mapping1.containsKey(target1) && this.mapping2.containsKey(target2) && !this.mapping1.get(target1).equals(this.mapping2.get(target2))) {
            this.recoverable = true;
            this.defined = false;
            return;
        }
        if (target1.getKind() == target2.getKind() && pt1.getTargetSpecifier() != pt2.getTargetSpecifier()) {
            this.recoverable = true;
            this.defined = false;
            return;
        }
        if (this.checkObjectMatch(target1, target2)) {
            this.abstractionCandidates = ImmutableList.of();
            return;
        }
        SMGObject newObject = target1.join(target2, (Integer)pLevelMapping.get(SMGJoinLevel.valueOf(pLevel1, pLevel2)));
        if (this.destSMG instanceof CLangSMG) {
            ((CLangSMG)this.destSMG).addHeapObject(newObject);
        } else {
            this.destSMG.addObject(newObject);
        }
        this.destSMG.setValidity(newObject, this.inputSMG1.isObjectValid(target1));
        this.delayedJoin(target1, target2, newObject);
        this.mapping1.map(target1, newObject);
        this.mapping2.map(target2, newObject);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pAddress1, pAddress2);
        this.destSMG = mta.getSMG();
        this.value = mta.getValue();
        SMGJoinSubSMGs jss = new SMGJoinSubSMGs(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pLevelMapping, target1, target2, newObject, ldiff, identicalInputSmgs, pSmgState1, pSmgState2);
        if (jss.isDefined()) {
            this.defined = true;
            this.status = jss.getStatus();
            this.abstractionCandidates = jss.getSubSmgAbstractionCandidates();
        }
        this.abstractionCandidates = ImmutableList.of();
    }

    private void delayedJoin(SMGObject pTarget1, SMGObject pTarget2, SMGObject targetObject) {
        Set<SMGEdgePointsTo> pointer;
        SMGObject oldTarget;
        if (this.mapping1.containsKey(pTarget1)) {
            oldTarget = this.mapping1.get(pTarget1);
            pointer = SMGUtils.getPointerToThisObject(oldTarget, this.destSMG);
            this.removeSubSmgAndMappping(oldTarget, this.mapping1);
            for (SMGEdgePointsTo ptE : pointer) {
                this.destSMG.addPointsToEdge(new SMGEdgePointsTo(ptE.getValue(), targetObject, ptE.getOffset(), ptE.getTargetSpecifier()));
            }
        }
        if (this.mapping2.containsKey(pTarget2)) {
            oldTarget = this.mapping2.get(pTarget2);
            pointer = SMGUtils.getPointerToThisObject(oldTarget, this.destSMG);
            this.removeSubSmgAndMappping(oldTarget, this.mapping2);
            for (SMGEdgePointsTo ptE : pointer) {
                this.destSMG.addPointsToEdge(new SMGEdgePointsTo(ptE.getValue(), targetObject, ptE.getOffset(), ptE.getTargetSpecifier()));
            }
        }
    }

    private void removeSubSmgAndMappping(SMGObject targetObject, SMGNodeMapping pMapping) {
        HashSet<SMGObject> toBeChecked = new HashSet<SMGObject>();
        HashSet<SMGObject> reached = new HashSet<SMGObject>();
        reached.add(targetObject);
        HashSet<SMGObject> toCheck = new HashSet<SMGObject>();
        pMapping.removeValue(targetObject);
        SMGHasValueEdges hves = this.destSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(targetObject));
        this.destSMG.markObjectDeletedAndRemoveEdges(targetObject);
        HashSet<Long> restricted = new HashSet<Long>();
        switch (targetObject.getKind()) {
            case DLL: {
                restricted.add(((SMGDoublyLinkedList)targetObject).getNfo());
                restricted.add(((SMGDoublyLinkedList)targetObject).getPfo());
                break;
            }
            case SLL: {
                restricted.add(((SMGSingleLinkedList)targetObject).getNfo());
                break;
            }
            default: {
                return;
            }
        }
        for (SMGEdgeHasValue hve : hves) {
            SMGValue val = hve.getValue();
            if (restricted.contains(hve.getOffset()) || val.isZero()) continue;
            if (this.destSMG.isPointer(val)) {
                SMGObject reachedObject = this.destSMG.getPointer(val).getObject();
                if (reached.contains(reachedObject) || reachedObject.getLevel() > targetObject.getLevel()) continue;
                toBeChecked.add(reachedObject);
                reached.add(reachedObject);
                pMapping.removeValue(val);
                continue;
            }
            pMapping.removeValue(val);
        }
        while (!toBeChecked.isEmpty()) {
            toCheck.clear();
            toCheck.addAll(toBeChecked);
            toBeChecked.clear();
            for (SMGObject objToCheck : toCheck) {
                this.removeObjectAndNodesFromDestSMG(objToCheck, reached, toBeChecked, targetObject.getLevel(), pMapping);
            }
        }
    }

    private void removeObjectAndNodesFromDestSMG(SMGObject pObjToCheck, Set<SMGObject> pReached, Set<SMGObject> pToBeChecked, int pLevel, SMGNodeMapping pMapping) {
        pMapping.removeValue(pObjToCheck);
        for (SMGEdgeHasValue hve : this.destSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObjToCheck))) {
            SMGValue val = hve.getValue();
            if (val.isZero()) continue;
            if (this.destSMG.isPointer(val)) {
                SMGObject reachedObject = this.destSMG.getPointer(val).getObject();
                if (pReached.contains(reachedObject) || reachedObject.getLevel() > pLevel) continue;
                pToBeChecked.add(reachedObject);
                pReached.add(reachedObject);
                pMapping.removeValue(val);
                continue;
            }
            pMapping.removeValue(val);
        }
        this.destSMG.markObjectDeletedAndRemoveEdges(pObjToCheck);
    }

    public boolean isDefined() {
        return this.defined;
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public UnmodifiableSMG getInputSMG1() {
        return this.inputSMG1;
    }

    public SMG getDestinationSMG() {
        return this.destSMG;
    }

    public SMGValue getValue() {
        return this.value;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public UnmodifiableSMG getInputSMG2() {
        return this.inputSMG2;
    }

    public List<SMGGenericAbstractionCandidate> getAbstractionCandidates() {
        return this.abstractionCandidates;
    }
}

