/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMapTargetAddress;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinMatchObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinTargetObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

public class SMGJoinTargetObjectsTest {
    private SMG smg1;
    private SMG smg2;
    private SMG destSMG;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private final SMGObject obj1 = new SMGRegion(64L, "ze label");
    private final SMGSymbolicValue value1 = SMGKnownSymValue.of();
    private final SMGEdgePointsTo pt1 = new SMGEdgePointsTo(this.value1, this.obj1, 0L);
    private final SMGObject obj2 = new SMGRegion(64L, "ze label");
    private final SMGSymbolicValue value2 = SMGKnownSymValue.of();
    private final SMGEdgePointsTo pt2 = new SMGEdgePointsTo(this.value2, this.obj2, 0L);
    private final SMGObject destObj = new SMGRegion(64L, "destination");

    @Before
    public void setUp() {
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.smg2 = new SMG(MachineModel.LINUX64);
        this.destSMG = new SMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void matchingObjectsWithoutMappingTest() throws SMGInconsistentException {
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(this.pt1);
        this.smg2.addObject(this.obj2);
        this.smg2.addValue(this.value2);
        this.smg2.addPointsToEdge(this.pt2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, 0, 0, false, null, null);
        Truth.assertThat((Comparable)jto.mapping2.get(this.obj2)).isSameInstanceAs((Object)jto.mapping1.get(this.obj1));
        Truth.assertThat((String)this.obj1.getLabel()).isEqualTo((Object)jto.mapping1.get(this.obj1).getLabel());
        Truth.assertThat((Long)this.obj1.getSize()).isEqualTo((Object)jto.mapping1.get(this.obj1).getSize());
    }

    @Test
    public void nonMatchingObjectsTest() throws SMGInconsistentException {
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(this.pt1);
        SMGJoinMatchObjects mo = new SMGJoinMatchObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.mapping1, this.mapping2, this.obj1, SMGNullObject.INSTANCE);
        Truth.assertThat((Boolean)mo.isDefined()).isFalse();
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, SMGZeroValue.INSTANCE, 0, 0, 0, false, null, null);
        Truth.assertThat((Boolean)jto.isDefined()).isFalse();
        Truth.assertThat((Boolean)jto.isRecoverable()).isTrue();
    }

    @Test
    public void joinTargetObjectsDifferentOffsets() throws SMGInconsistentException {
        SMGEdgePointsTo pt1null = new SMGEdgePointsTo(this.value1, SMGNullObject.INSTANCE, 2L);
        SMGEdgePointsTo pt2null = new SMGEdgePointsTo(this.value2, SMGNullObject.INSTANCE, 1L);
        this.smg1.addObject(this.obj1);
        this.smg1.addValue(this.value1);
        this.smg1.addPointsToEdge(pt1null);
        this.smg2.addObject(this.obj2);
        this.smg2.addValue(this.value2);
        this.smg2.addPointsToEdge(pt2null);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, null, null, null, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, 0, 0, false, null, null);
        Truth.assertThat((Boolean)jto.isDefined()).isFalse();
        Truth.assertThat((Boolean)jto.isRecoverable()).isTrue();
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNull() throws SMGInconsistentException {
        SMGEdgePointsTo pt1null = new SMGEdgePointsTo(this.value1, SMGNullObject.INSTANCE, 0L);
        SMGEdgePointsTo pt2null = new SMGEdgePointsTo(this.value2, SMGNullObject.INSTANCE, 0L);
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smg1.addPointsToEdge(pt1null);
        this.smg2.addPointsToEdge(pt2null);
        SMGJoinMapTargetAddress mta = new SMGJoinMapTargetAddress(this.smg1.copyOf(), this.smg2.copyOf(), this.destSMG.copyOf(), new SMGNodeMapping(this.mapping1), new SMGNodeMapping(this.mapping2), this.value1, this.value2);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, 0, 0, false, null, null);
        Truth.assertThat((Boolean)jto.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jto.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jto.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jto.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jto.getDestinationSMG()).isEqualTo((Object)mta.getSMG());
        Truth.assertThat((Object)jto.mapping1).isEqualTo((Object)mta.mapping1);
        Truth.assertThat((Object)jto.mapping2).isEqualTo((Object)mta.mapping2);
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)mta.getValue());
    }

    @Test
    public void joinTargetObjectsAlreadyJoinedNonNull() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smg1.addObject(this.obj1);
        this.smg2.addObject(this.obj2);
        this.destSMG.addObject(this.destObj);
        this.smg1.addPointsToEdge(this.pt1);
        this.smg2.addPointsToEdge(this.pt2);
        this.mapping1.map(this.obj1, this.destObj);
        this.mapping2.map(this.obj2, this.destObj);
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.destSMG, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, 0, 0, false, null, null);
        Truth.assertThat((Boolean)jto.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jto.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jto.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jto.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Boolean)jto.mapping1.containsKey(this.value1)).isTrue();
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)jto.mapping1.get(this.value1));
        Truth.assertThat((Boolean)jto.mapping2.containsKey(this.value2)).isTrue();
        Truth.assertThat((Comparable)jto.getValue()).isEqualTo((Object)jto.mapping2.get(this.value2));
    }
}

