/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.truth.Truth;
import java.util.List;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cfa.types.c.CFunctionType;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.cpa.smg.CLangStackFrame;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableCLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownExpValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoin;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.util.Pair;

public class SMGJoinTest {
    private static final CFunctionType functionType = CFunctionType.functionTypeWithReturnType(CNumericTypes.UNSIGNED_LONG_INT);
    private static final CFunctionDeclaration functionDeclaration = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "foo", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private static final CFunctionDeclaration functionDeclaration2 = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "bar", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private static final CFunctionDeclaration functionDeclaration3 = new CFunctionDeclaration(FileLocation.DUMMY, functionType, "main", (List<CParameterDeclaration>)ImmutableList.of(), (ImmutableSet<CFunctionDeclaration.FunctionAttribute>)ImmutableSet.of());
    private SMGState dummyState;
    private CLangSMG smg1;
    private CLangSMG smg2;

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.dummyState = new SMGState(LogManager.createTestLogManager(), MachineModel.LINUX32, new SMGOptions(Configuration.defaultConfiguration()));
        this.smg1 = new CLangSMG(MachineModel.LINUX64);
        this.smg2 = new CLangSMG(MachineModel.LINUX64);
    }

    private void addGlobalWithoutValueToBoth(String pVarName) {
        SMGRegion global1 = new SMGRegion(64L, pVarName);
        SMGRegion global2 = new SMGRegion(64L, pVarName);
        this.smg1.addGlobalObject(global1);
        this.smg2.addGlobalObject(global2);
    }

    private Pair<SMGRegion, SMGRegion> addGlobalWithoutValueToBoth(String pVarName, int size) {
        SMGRegion global1 = new SMGRegion(size, pVarName);
        SMGRegion global2 = new SMGRegion(size, pVarName);
        this.smg1.addGlobalObject(global1);
        this.smg2.addGlobalObject(global2);
        return Pair.of(global1, global2);
    }

    private Pair<SMGRegion, SMGRegion> addLocalWithoutValueToBoth(String pVarName, int size) {
        SMGRegion local1 = new SMGRegion(size, pVarName);
        SMGRegion local2 = new SMGRegion(size, pVarName);
        this.smg1.addStackObject(local1);
        this.smg2.addStackObject(local2);
        return Pair.of(local1, local2);
    }

    private Pair<SMGRegion, SMGRegion> addHeapWithoutValueToBoth(String pVarName, int size) {
        SMGRegion local1 = new SMGRegion(size, pVarName);
        SMGRegion local2 = new SMGRegion(size, pVarName);
        this.smg1.addHeapObject(local1);
        this.smg2.addHeapObject(local2);
        return Pair.of(local1, local2);
    }

    private void addValueToBoth(Pair<? extends SMGObject, ? extends SMGObject> var, long pOffset, int pValue, int pSizeInBits) {
        SMGKnownExpValue value = SMGKnownExpValue.valueOf(pValue);
        this.smg1.addValue(value);
        this.smg2.addValue(value);
        this.smg1.addHasValueEdge(new SMGEdgeHasValue(pSizeInBits, pOffset, var.getFirst(), (SMGValue)value));
        this.smg2.addHasValueEdge(new SMGEdgeHasValue(pSizeInBits, pOffset, var.getSecond(), (SMGValue)value));
    }

    private void addPointerToBoth(Pair<? extends SMGObject, ? extends SMGObject> target, long pOffset, int pValue) {
        SMGKnownExpValue value = SMGKnownExpValue.valueOf(pValue);
        this.smg1.addValue(value);
        this.smg2.addValue(value);
        this.smg1.addPointsToEdge(new SMGEdgePointsTo(value, target.getFirst(), pOffset));
        this.smg2.addPointsToEdge(new SMGEdgePointsTo(value, target.getSecond(), pOffset));
    }

    private void addPointerValueToBoth(Pair<? extends SMGObject, ? extends SMGObject> var, long pOffset, int pValue, int pSize, Pair<? extends SMGObject, ? extends SMGObject> target, long pTargetOffset) {
        this.addValueToBoth(var, pOffset, pValue, pSize);
        this.addPointerToBoth(target, pTargetOffset, pValue);
    }

    private void addLocalWithoutValueToBoth(String pVarName) {
        SMGRegion local1 = new SMGRegion(64L, pVarName);
        SMGRegion local2 = new SMGRegion(64L, pVarName);
        this.smg1.addStackObject(local1);
        this.smg2.addStackObject(local2);
    }

    private void addGlobalWithValueToBoth(String pVarName) {
        SMGRegion global1 = new SMGRegion(64L, pVarName);
        SMGRegion global2 = new SMGRegion(64L, pVarName);
        SMGKnownSymbolicValue value1 = SMGKnownSymValue.of();
        SMGKnownSymbolicValue value2 = SMGKnownSymValue.of();
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)global1, (SMGValue)value1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(32L, 0L, (SMGObject)global2, (SMGValue)value2);
        this.smg1.addGlobalObject(global1);
        this.smg2.addGlobalObject(global2);
        this.smg1.addValue(value1);
        this.smg2.addValue(value2);
        this.smg1.addHasValueEdge(hv1);
        this.smg2.addHasValueEdge(hv2);
    }

    private void addLocalWithValueToBoth(String pVarName) {
        SMGRegion local1 = new SMGRegion(64L, pVarName);
        SMGRegion local2 = new SMGRegion(64L, pVarName);
        SMGKnownSymbolicValue value1 = SMGKnownSymValue.of();
        SMGKnownSymbolicValue value2 = SMGKnownSymValue.of();
        SMGEdgeHasValue hv1 = new SMGEdgeHasValue(32L, 0L, (SMGObject)local1, (SMGValue)value1);
        SMGEdgeHasValue hv2 = new SMGEdgeHasValue(32L, 0L, (SMGObject)local2, (SMGValue)value2);
        this.smg1.addStackObject(local1);
        this.smg2.addStackObject(local2);
        this.smg1.addValue(value1);
        this.smg2.addValue(value2);
        this.smg1.addHasValueEdge(hv1);
        this.smg2.addHasValueEdge(hv2);
    }

    private void assertObjectCounts(UnmodifiableCLangSMG pSMG, int pGlobals, int pHeap, int pFrames) {
        Truth.assertThat(pSMG.getGlobalObjects()).hasSize(pGlobals);
        Truth.assertThat(pSMG.getHeapObjects()).hasSize(pHeap);
        Truth.assertThat(pSMG.getStackFrames()).hasSize(pFrames);
    }

    @Test
    public void simpleGlobalVarJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.addGlobalWithoutValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        CLangSMG resultSMG = join.getJointSMG();
        Truth.assertThat(resultSMG.getGlobalObjects()).containsKey((Object)varName);
        this.assertObjectCounts(resultSMG, 1, 1, 0);
    }

    @Test
    public void simpleLocalVarJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.smg1.addStackFrame(functionDeclaration);
        this.smg2.addStackFrame(functionDeclaration);
        this.addLocalWithoutValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        CLangSMG resultSMG = join.getJointSMG();
        Truth.assertThat((Boolean)((CLangStackFrame)Iterables.get(resultSMG.getStackFrames(), (int)0)).containsVariable(varName)).isTrue();
        this.assertObjectCounts(resultSMG, 0, 1, 1);
    }

    @Test
    public void globalVarWithValueJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.addGlobalWithValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        CLangSMG resultSMG = join.getJointSMG();
        Truth.assertThat(resultSMG.getGlobalObjects()).containsKey((Object)varName);
        this.assertObjectCounts(resultSMG, 1, 1, 0);
        SMGObject global = (SMGObject)resultSMG.getGlobalObjects().get((Object)varName);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(global).filterAtOffset(0L).filterWithoutSize();
        SMGEdgeHasValue edge = (SMGEdgeHasValue)Iterables.getOnlyElement(resultSMG.getHVEdges(filter));
        Truth.assertThat(resultSMG.getValues()).contains((Object)edge.getValue());
    }

    @Test
    public void localVarWithValueJoinTest() throws SMGInconsistentException {
        String varName = "variableName";
        this.smg1.addStackFrame(functionDeclaration);
        this.smg2.addStackFrame(functionDeclaration);
        this.addLocalWithValueToBoth(varName);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        CLangSMG resultSMG = join.getJointSMG();
        Truth.assertThat((Boolean)((CLangStackFrame)Iterables.get(resultSMG.getStackFrames(), (int)0)).containsVariable(varName)).isTrue();
        this.assertObjectCounts(resultSMG, 0, 1, 1);
        SMGRegion global = ((CLangStackFrame)Iterables.get(resultSMG.getStackFrames(), (int)0)).getVariable(varName);
        SMGEdgeHasValueFilter filter = SMGEdgeHasValueFilter.objectFilter(global).filterAtOffset(0L).filterWithoutSize();
        SMGEdgeHasValue edge = (SMGEdgeHasValue)Iterables.getOnlyElement(resultSMG.getHVEdges(filter));
        Truth.assertThat(resultSMG.getValues()).contains((Object)edge.getValue());
    }

    @Test
    public void complexJoinTestNoAbstraction() throws SMGInconsistentException {
        this.smg1.addStackFrame(functionDeclaration3);
        this.smg2.addStackFrame(functionDeclaration3);
        Pair<SMGRegion, SMGRegion> global = this.addGlobalWithoutValueToBoth("global", 64);
        Pair<SMGRegion, SMGRegion> l1 = this.addHeapWithoutValueToBoth("l1", 96);
        Pair<SMGRegion, SMGRegion> l2 = this.addHeapWithoutValueToBoth("l2", 96);
        Pair<SMGRegion, SMGRegion> l3 = this.addHeapWithoutValueToBoth("l3", 96);
        Pair<SMGRegion, SMGRegion> l4 = this.addHeapWithoutValueToBoth("l4", 96);
        this.addPointerValueToBoth(global, 0L, 100, 32, l1, 0L);
        this.addPointerValueToBoth(l1, 0L, 102, 32, l2, 0L);
        this.addPointerValueToBoth(l2, 0L, 103, 32, l3, 0L);
        this.addPointerValueToBoth(l3, 0L, 104, 32, l4, 0L);
        this.addPointerValueToBoth(l4, 0L, 109, 32, global, 0L);
        this.addPointerValueToBoth(global, 32L, 105, 32, l4, 0L);
        this.addPointerValueToBoth(l4, 32L, 106, 32, l3, 0L);
        this.addPointerValueToBoth(l3, 32L, 107, 32, l2, 0L);
        this.addPointerValueToBoth(l2, 32L, 108, 32, l1, 0L);
        this.addPointerValueToBoth(l1, 32L, 110, 32, global, 0L);
        this.addValueToBoth(l1, 64L, 5, 8);
        this.addValueToBoth(l2, 64L, 5, 8);
        this.addValueToBoth(l3, 64L, 5, 8);
        this.addValueToBoth(l4, 64L, 5, 8);
        Pair<SMGRegion, SMGRegion> a1 = this.addLocalWithoutValueToBoth("a", 32);
        this.addValueToBoth(a1, 0L, 5, 32);
        Pair<SMGRegion, SMGRegion> b1 = this.addLocalWithoutValueToBoth("b", 32);
        this.addValueToBoth(b1, 0L, 100, 32);
        this.smg1.addStackFrame(functionDeclaration2);
        this.smg2.addStackFrame(functionDeclaration2);
        Pair<SMGRegion, SMGRegion> b2 = this.addLocalWithoutValueToBoth("b", 32);
        this.addValueToBoth(b2, 0L, 100, 32);
        Pair<SMGRegion, SMGRegion> c2 = this.addLocalWithoutValueToBoth("c", 32);
        this.addValueToBoth(c2, 0L, 104, 32);
        this.smg1.addStackFrame(functionDeclaration);
        this.smg2.addStackFrame(functionDeclaration);
        Pair<SMGRegion, SMGRegion> a3 = this.addLocalWithoutValueToBoth("a", 32);
        this.addValueToBoth(a3, 0L, 5, 32);
        Pair<SMGRegion, SMGRegion> c3 = this.addLocalWithoutValueToBoth("c", 32);
        this.addValueToBoth(c3, 0L, 104, 32);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
    }

    private void joinUpdateUnit(SMGJoinStatus firstOperand, SMGJoinStatus forLe, SMGJoinStatus forRe) {
        Truth.assertThat((Comparable)((Object)firstOperand.updateWith(SMGJoinStatus.EQUAL))).isEqualTo((Object)firstOperand);
        Truth.assertThat((Comparable)((Object)firstOperand.updateWith(SMGJoinStatus.LEFT_ENTAIL))).isEqualTo((Object)forLe);
        Truth.assertThat((Comparable)((Object)firstOperand.updateWith(SMGJoinStatus.RIGHT_ENTAIL))).isEqualTo((Object)forRe);
        Truth.assertThat((Comparable)((Object)firstOperand.updateWith(SMGJoinStatus.INCOMPARABLE))).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
    }

    @Test
    public void joinUpdateTest() {
        this.joinUpdateUnit(SMGJoinStatus.EQUAL, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.RIGHT_ENTAIL);
        this.joinUpdateUnit(SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.LEFT_ENTAIL, SMGJoinStatus.INCOMPARABLE);
        this.joinUpdateUnit(SMGJoinStatus.RIGHT_ENTAIL, SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.RIGHT_ENTAIL);
        this.joinUpdateUnit(SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.INCOMPARABLE, SMGJoinStatus.INCOMPARABLE);
    }

    @Test
    public void nullifiedBlocksJoinTest() throws SMGInconsistentException {
        int mockType4bSize = 32;
        this.smg1.addStackFrame(functionDeclaration3);
        this.smg2.addStackFrame(functionDeclaration3);
        Pair<SMGRegion, SMGRegion> objs = this.addHeapWithoutValueToBoth("Object", 64);
        this.smg1.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)objs.getFirst(), (SMGValue)SMGZeroValue.INSTANCE));
        this.smg2.addHasValueEdge(new SMGEdgeHasValue(32L, 0L, (SMGObject)objs.getSecond(), (SMGValue)SMGZeroValue.INSTANCE));
        this.smg2.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)objs.getSecond(), (SMGValue)SMGZeroValue.INSTANCE));
        Pair<SMGRegion, SMGRegion> global = this.addGlobalWithoutValueToBoth("global", 128);
        this.addPointerValueToBoth(global, 0L, 100, 32, objs, 0L);
        SMGJoin join = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)join.getStatus())).isEqualTo((Object)SMGJoinStatus.RIGHT_ENTAIL);
        SMGKnownSymbolicValue un = SMGKnownSymValue.valueOf(666);
        this.smg1.addValue(un);
        this.smg1.addHasValueEdge(new SMGEdgeHasValue(32L, 32L, (SMGObject)objs.getFirst(), (SMGValue)un));
        SMGJoin join2 = new SMGJoin(this.smg1, this.smg2, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)join2.isDefined()).isFalse();
        Truth.assertThat((Comparable)((Object)join2.getStatus())).isEqualTo((Object)SMGJoinStatus.INCOMPARABLE);
    }
}

