/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGTargetSpecifier;
import org.sosy_lab.cpachecker.cpa.smg.SMGUtils;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.CLangSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMGHasValueEdges;
import org.sosy_lab.cpachecker.cpa.smg.graphs.UnmodifiableSMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValueFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsToFilter;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGNullObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObjectKind;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.dll.SMGDoublyLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.generic.SMGGenericAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.optional.SMGOptionalObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.sll.SMGSingleLinkedList;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymbolicValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGZeroValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinLevel;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinTargetObjects;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;
import org.sosy_lab.cpachecker.util.Pair;

final class SMGJoinValues {
    private SMGJoinStatus status;
    private UnmodifiableSMG inputSMG1;
    private UnmodifiableSMG inputSMG2;
    private SMG destSMG;
    private SMGValue value;
    @VisibleForTesting
    final SMGNodeMapping mapping1;
    @VisibleForTesting
    final SMGNodeMapping mapping2;
    private boolean defined = false;
    private final UnmodifiableSMGState smgState1;
    private final UnmodifiableSMGState smgState2;
    private List<SMGGenericAbstractionCandidate> abstractionCandidates;
    private boolean recoverable;

    private boolean joinValuesIdentical(SMGValue pV1, SMGValue pV2) {
        if (pV1.equals(pV2)) {
            this.value = pV1;
            this.defined = true;
            return true;
        }
        return false;
    }

    private boolean joinValuesAlreadyJoined(SMGValue pV1, SMGValue pV2) {
        if (this.mapping1.containsKey(pV1) && this.mapping2.containsKey(pV2) && this.mapping1.get(pV1).equals(this.mapping2.get(pV2))) {
            this.value = this.mapping1.get(pV1);
            this.defined = true;
            return true;
        }
        return false;
    }

    private boolean joinValuesNonPointers(SMGValue pV1, SMGValue pV2, int pLevelV1, int pLevelV2, int lDiff) {
        if (!this.inputSMG1.isPointer(pV1) && !this.inputSMG2.isPointer(pV2)) {
            SMGValue newValue;
            if (this.mapping1.containsKey(pV1) || this.mapping2.containsKey(pV2)) {
                return true;
            }
            if (pV1.equals(pV2)) {
                newValue = pV1;
            } else {
                newValue = SMGKnownSymValue.of();
                if (this.smgState1 == null || this.smgState2 == null) {
                    this.status = this.status.updateWith(SMGJoinStatus.INCOMPARABLE);
                } else {
                    SMGJoinStatus v1isLessOrEqualV2 = SMGJoinValues.valueIsLessOrEqual((SMGKnownSymbolicValue)pV1, (SMGKnownSymbolicValue)pV2, this.smgState1, this.smgState2);
                    SMGJoinStatus v2isLessOrEqualV1 = SMGJoinValues.valueIsLessOrEqual((SMGKnownSymbolicValue)pV2, (SMGKnownSymbolicValue)pV1, this.smgState2, this.smgState1);
                    this.status = v1isLessOrEqualV2 != SMGJoinStatus.INCOMPARABLE ? this.status.updateWith(v1isLessOrEqualV2) : (v2isLessOrEqualV1 == SMGJoinStatus.RIGHT_ENTAIL ? this.status.updateWith(SMGJoinStatus.LEFT_ENTAIL) : this.status.updateWith(v2isLessOrEqualV1));
                }
            }
            if (pLevelV1 - pLevelV2 < lDiff) {
                this.status = this.status.updateWith(SMGJoinStatus.LEFT_ENTAIL);
            } else if (pLevelV1 - pLevelV2 > lDiff) {
                this.status = this.status.updateWith(SMGJoinStatus.RIGHT_ENTAIL);
            }
            this.destSMG.addValue(newValue);
            this.mapping1.map(pV1, newValue);
            this.mapping2.map(pV2, newValue);
            this.defined = true;
            this.value = newValue;
            return true;
        }
        return false;
    }

    private static SMGJoinStatus valueIsLessOrEqual(SMGKnownSymbolicValue value1, SMGKnownSymbolicValue value2, UnmodifiableSMGState state1, UnmodifiableSMGState state2) {
        if (value1.equals(value2)) {
            return SMGJoinStatus.EQUAL;
        }
        if (state2.isExplicit(value2)) {
            if (!state1.isExplicit(value1)) {
                return SMGJoinStatus.INCOMPARABLE;
            }
            if (!state2.getExplicit(value2).equals(state1.getExplicit(value1))) {
                return SMGJoinStatus.INCOMPARABLE;
            }
            return SMGJoinStatus.EQUAL;
        }
        for (SMGValue neqToVal2 : state2.getHeap().getNeqsForValue(value2)) {
            if (state1.getHeap().haveNeqRelation(value1, neqToVal2)) continue;
            return SMGJoinStatus.INCOMPARABLE;
        }
        if (state1.isExplicit(value1) || !state1.getHeap().getNeqsForValue(value1).isEmpty()) {
            return SMGJoinStatus.RIGHT_ENTAIL;
        }
        return SMGJoinStatus.EQUAL;
    }

    private boolean joinValuesMixedPointers(SMGValue pV1, SMGValue pV2) {
        return !this.inputSMG1.isPointer(pV1) || !this.inputSMG2.isPointer(pV2);
    }

    private boolean joinValuesPointers(SMGValue pV1, SMGValue pV2, int pLevel1, int pLevel2, int ldiff, boolean identicalInputSmg, SMGLevelMapping pLevelMap) throws SMGInconsistentException {
        SMGJoinTargetObjects jto = new SMGJoinTargetObjects(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, this.mapping1, this.mapping2, pLevelMap, pV1, pV2, pLevel1, pLevel2, ldiff, identicalInputSmg, this.smgState1, this.smgState2);
        if (jto.isDefined()) {
            this.status = jto.getStatus();
            this.inputSMG1 = jto.getInputSMG1();
            this.inputSMG2 = jto.getInputSMG2();
            this.destSMG = jto.getDestinationSMG();
            this.value = jto.getValue();
            this.defined = true;
            this.abstractionCandidates = jto.getAbstractionCandidates();
            this.recoverable = jto.isRecoverable();
            return true;
        }
        if (jto.isRecoverable()) {
            this.recoverable = true;
            return true;
        }
        this.defined = false;
        this.recoverable = false;
        this.abstractionCandidates = ImmutableList.of();
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public SMGJoinValues(SMGJoinStatus pStatus, UnmodifiableSMG pNewInputSMG1, UnmodifiableSMG pNewInputSMG2, SMG pDestSMG, SMGNodeMapping pMapping1, SMGNodeMapping pMapping2, SMGLevelMapping pLevelMap, SMGValue pValue1, SMGValue pValue2, int pLDiff, boolean identicalInputSmg, int levelV1, int levelV2, int pPrevDestLevel, UnmodifiableSMGState pStateOfSmg1, UnmodifiableSMGState pStateOfSmg2) throws SMGInconsistentException {
        this.mapping1 = pMapping1;
        this.mapping2 = pMapping2;
        this.status = pStatus;
        this.inputSMG1 = pNewInputSMG1;
        this.inputSMG2 = pNewInputSMG2;
        this.destSMG = pDestSMG;
        this.smgState1 = pStateOfSmg1;
        this.smgState2 = pStateOfSmg2;
        if (identicalInputSmg && this.joinValuesIdentical(pValue1, pValue2)) {
            this.abstractionCandidates = ImmutableList.of();
            this.recoverable = this.defined;
            this.mapping1.map(pValue1, pValue1);
            this.mapping2.map(pValue2, pValue1);
            return;
        }
        if (this.joinValuesAlreadyJoined(pValue1, pValue2)) {
            this.abstractionCandidates = ImmutableList.of();
            this.recoverable = this.defined;
            return;
        }
        if (this.joinValuesNonPointers(pValue1, pValue2, levelV1, levelV2, pLDiff)) {
            this.abstractionCandidates = ImmutableList.of();
            this.recoverable = this.defined;
            return;
        }
        if (this.joinValuesMixedPointers(pValue1, pValue2)) {
            this.abstractionCandidates = ImmutableList.of();
            this.recoverable = true;
            return;
        }
        if (this.joinValuesPointers(pValue1, pValue2, levelV1, levelV2, pLDiff, identicalInputSmg, pLevelMap)) {
            Pair<Boolean, Boolean> result;
            if (this.defined) {
                this.abstractionCandidates = ImmutableList.of();
                this.recoverable = false;
                return;
            }
            if (!this.recoverable) {
                this.recoverable = false;
                return;
            }
            SMGObject target1 = this.inputSMG1.getObjectPointedBy(pValue1);
            SMGObject target2 = this.inputSMG2.getObjectPointedBy(pValue2);
            if (target1.isAbstract() || target2.isAbstract()) {
                if (target1.getKind() == SMGObjectKind.DLL || target1.getKind() == SMGObjectKind.SLL) {
                    result = this.insertLeftListAndJoin(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, pLevelMap, pValue1, pValue2, target1, pLDiff, levelV1, levelV2, identicalInputSmg, pPrevDestLevel);
                    if (!result.getSecond().booleanValue()) {
                        this.recoverable = false;
                        return;
                    }
                    if (result.getFirst().booleanValue()) {
                        return;
                    }
                }
                if (target2.getKind() == SMGObjectKind.DLL || target2.getKind() == SMGObjectKind.SLL) {
                    result = this.insertRightListAndJoin(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, pLevelMap, pValue1, pValue2, target2, pLDiff, levelV1, levelV2, identicalInputSmg, pPrevDestLevel);
                    if (!result.getSecond().booleanValue()) {
                        this.recoverable = false;
                        return;
                    }
                    if (result.getFirst().booleanValue()) {
                        return;
                    }
                }
            }
            if (!(result = this.insertLeftObjectAsOptional(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, pLevelMap, pValue1, pValue2, target1, pLDiff, levelV1, levelV2, identicalInputSmg, pPrevDestLevel)).getSecond().booleanValue()) {
                this.recoverable = false;
                return;
            }
            if (result.getFirst().booleanValue()) {
                return;
            }
            result = this.insertRightObjectAsOptional(this.status, this.inputSMG1, this.inputSMG2, this.destSMG, pLevelMap, pValue1, pValue2, target2, pLDiff, levelV1, levelV2, identicalInputSmg, pPrevDestLevel);
            if (!result.getSecond().booleanValue()) {
                this.recoverable = false;
                return;
            }
            if (result.getFirst().booleanValue()) {
                return;
            }
        }
        this.abstractionCandidates = ImmutableList.of();
        this.recoverable = false;
    }

    private Pair<Boolean, Boolean> insertRightObjectAsOptional(SMGJoinStatus pStatus, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, SMG pDestSMG, SMGLevelMapping pLevelMap, SMGValue pValue1, SMGValue pValue2, SMGObject pTarget, int pLDiff, int pLevelV1, int pLevelV2, boolean pIdenticalInputSmg, int pPrevDestLevel) throws SMGInconsistentException {
        SMGValue newAddressFromOptionalObject;
        SMGObject jointList;
        switch (pTarget.getKind()) {
            case REG: 
            case OPTIONAL: {
                break;
            }
            default: {
                return Pair.of(false, true);
            }
        }
        if (this.mapping2.containsKey(pTarget) && this.mapping1.containsValue(jointList = this.mapping2.get(pTarget))) {
            return Pair.of(false, true);
        }
        Set<SMGEdgePointsTo> pointedToTarget = SMGUtils.getPointerToThisObject(pTarget, pInputSMG2);
        if (pointedToTarget.size() != 1) {
            return Pair.of(false, true);
        }
        SMGEdgePointsTo pointedToTargetEdge = (SMGEdgePointsTo)Iterables.getOnlyElement(pointedToTarget);
        SMGHasValueEdges fieldsOfTarget = pInputSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pTarget));
        if (fieldsOfTarget.isEmpty()) {
            return Pair.of(false, true);
        }
        SMGValue nextPointer = pValue1.isZero() ? SMGZeroValue.INSTANCE : null;
        for (SMGEdgeHasValue field : fieldsOfTarget) {
            SMGValue fieldValue = field.getValue();
            if (!pInputSMG2.isPointer(fieldValue) || fieldValue.isZero()) continue;
            if (nextPointer == null) {
                nextPointer = fieldValue;
                continue;
            }
            if (nextPointer == fieldValue) continue;
            return Pair.of(false, true);
        }
        if (nextPointer == null) {
            return Pair.of(false, true);
        }
        if (this.mapping2.containsKey(pTarget)) {
            if (this.mapping2.containsKey(pValue2)) {
                this.value = this.mapping2.get(pValue2);
                this.defined = true;
                this.inputSMG1 = pInputSMG1;
                this.inputSMG2 = pInputSMG2;
                this.destSMG = pDestSMG;
                this.status = pStatus;
                return Pair.of(true, true);
            }
            return Pair.of(false, true);
        }
        int level = this.getLevelOfOptionalObject(pValue2, pLevelMap, this.inputSMG2, this.mapping2, pLevelV1, pLevelV2);
        SMGLevelMapping newLevelMap = new SMGLevelMapping();
        newLevelMap.putAll(pLevelMap);
        newLevelMap.put(SMGJoinLevel.valueOf(pLevelV1, pLevelV2), level);
        SMGOptionalObject optionalObject = new SMGOptionalObject(pTarget.getSize(), level);
        this.mapping2.map(pTarget, optionalObject);
        ((CLangSMG)pDestSMG).addHeapObject(optionalObject);
        SMGKnownSymbolicValue resultPointer = SMGKnownSymValue.of();
        SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, optionalObject, pointedToTargetEdge.getOffset(), SMGTargetSpecifier.OPT);
        pDestSMG.addValue(resultPointer);
        pDestSMG.addPointsToEdge(newJointPtEdge);
        this.mapping2.map(pValue2, resultPointer);
        pDestSMG.setValidity(optionalObject, pInputSMG2.isObjectValid(pTarget));
        SMGJoinStatus newJoinStatus = pTarget.getKind() == SMGObjectKind.OPTIONAL ? SMGJoinStatus.RIGHT_ENTAIL : SMGJoinStatus.INCOMPARABLE;
        SMGJoinStatus updatedStatus = pStatus.updateWith(newJoinStatus);
        SMGJoinValues jv = new SMGJoinValues(updatedStatus, pInputSMG1, pInputSMG2, pDestSMG, this.mapping1, this.mapping2, newLevelMap, pValue1, nextPointer, pLDiff, pIdenticalInputSmg, pLevelV1, pLevelV2, pPrevDestLevel, this.smgState1, this.smgState2);
        if (jv.isDefined()) {
            newAddressFromOptionalObject = jv.getValue();
            if (pDestSMG.getPointer(newAddressFromOptionalObject).getTargetSpecifier() == SMGTargetSpecifier.OPT) {
                return Pair.of(false, false);
            }
        } else {
            return Pair.of(false, true);
        }
        this.status = jv.getStatus();
        this.inputSMG1 = jv.getInputSMG1();
        this.inputSMG2 = jv.getInputSMG2();
        this.destSMG = jv.getDestinationSMG();
        this.value = resultPointer;
        this.defined = jv.defined;
        for (SMGEdgeHasValue field : fieldsOfTarget) {
            SMGEdgeHasValue newHve;
            if (field.getValue() == nextPointer) {
                newHve = new SMGEdgeHasValue(field.getSizeInBits(), field.getOffset(), (SMGObject)optionalObject, newAddressFromOptionalObject);
            } else {
                SMGValue newVal;
                SMGValue val = field.getValue();
                if (this.mapping1.containsKey(val) || val.isZero()) {
                    newVal = val;
                } else {
                    newVal = SMGKnownSymValue.of();
                    this.mapping2.map(val, newVal);
                    pDestSMG.addValue(newVal);
                }
                newHve = new SMGEdgeHasValue(field.getSizeInBits(), field.getOffset(), (SMGObject)optionalObject, newVal);
            }
            if (!pDestSMG.getValues().contains(newHve.getValue())) {
                pDestSMG.addValue(newHve.getValue());
            }
            if (!this.mapping1.containsKey(field.getValue())) {
                this.mapping1.map(field.getValue(), newHve.getValue());
            }
            pDestSMG.addHasValueEdge(newHve);
        }
        return Pair.of(true, true);
    }

    private int getLevelOfOptionalObject(SMGValue pDisplacedValue, SMGLevelMapping pLevelMap, UnmodifiableSMG pInputSMG1, SMGNodeMapping pDisplacedValueNodeMapping, int pLevelV1, int pLevelV2) {
        if (!pDisplacedValue.isZero()) {
            return (Integer)pLevelMap.get(SMGJoinLevel.valueOf(pLevelV1, pLevelV2));
        }
        Iterable<SMGEdgeHasValue> edges = pInputSMG1.getHVEdges(SMGEdgeHasValueFilter.valueFilter(pDisplacedValue));
        SMGObject sourceObject = edges.iterator().next().getObject();
        for (SMGEdgeHasValue edge : edges) {
            if (edge.getObject() == sourceObject) continue;
            return -1;
        }
        SMGObject destSmgSourceObject = pDisplacedValueNodeMapping.get(sourceObject);
        if (destSmgSourceObject.isAbstract()) {
            long arbitraryOffset = edges.iterator().next().getOffset();
            switch (destSmgSourceObject.getKind()) {
                case DLL: {
                    SMGDoublyLinkedList dll = (SMGDoublyLinkedList)destSmgSourceObject;
                    if (arbitraryOffset != dll.getNfo() && arbitraryOffset != dll.getPfo()) {
                        return destSmgSourceObject.getLevel() + 1;
                    }
                    return destSmgSourceObject.getLevel();
                }
                case SLL: {
                    SMGSingleLinkedList sll = (SMGSingleLinkedList)destSmgSourceObject;
                    if (arbitraryOffset != sll.getNfo()) {
                        return destSmgSourceObject.getLevel() + 1;
                    }
                    return destSmgSourceObject.getLevel();
                }
            }
            return -1;
        }
        return destSmgSourceObject.getLevel();
    }

    private Pair<Boolean, Boolean> insertLeftObjectAsOptional(SMGJoinStatus pStatus, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, SMG pDestSMG, SMGLevelMapping pLevelMapping, SMGValue pValue1, SMGValue pValue2, SMGObject pTarget, int pLDiff, int pLevelV1, int pLevelV2, boolean pIdenticalInputSmg, int pPrevDestLevel) throws SMGInconsistentException {
        SMGValue newAddressFromOptionalObject;
        SMGObject jointObject;
        switch (pTarget.getKind()) {
            case REG: 
            case OPTIONAL: {
                break;
            }
            default: {
                return Pair.of(false, true);
            }
        }
        if (this.mapping1.containsKey(pTarget) && this.mapping2.containsValue(jointObject = this.mapping1.get(pTarget))) {
            return Pair.of(false, true);
        }
        Set<SMGEdgePointsTo> pointedToTarget = SMGUtils.getPointerToThisObject(pTarget, pInputSMG1);
        if (pointedToTarget.size() != 1) {
            return Pair.of(false, true);
        }
        SMGEdgePointsTo pointedToTargetEdge = (SMGEdgePointsTo)Iterables.getOnlyElement(pointedToTarget);
        SMGHasValueEdges fieldsOfTarget = pInputSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pTarget));
        if (fieldsOfTarget.isEmpty()) {
            return Pair.of(false, true);
        }
        SMGValue nextPointer = pValue2.isZero() ? SMGZeroValue.INSTANCE : null;
        for (SMGEdgeHasValue field : fieldsOfTarget) {
            SMGValue fieldValue = field.getValue();
            if (!pInputSMG1.isPointer(fieldValue) || fieldValue.isZero()) continue;
            if (nextPointer == null) {
                nextPointer = fieldValue;
                continue;
            }
            if (((Object)nextPointer).equals(fieldValue)) continue;
            return Pair.of(false, true);
        }
        if (nextPointer == null) {
            return Pair.of(false, true);
        }
        if (this.mapping1.containsKey(pTarget)) {
            if (this.mapping1.containsKey(pValue1)) {
                this.value = this.mapping1.get(pValue1);
                this.defined = true;
                this.inputSMG1 = pInputSMG1;
                this.inputSMG2 = pInputSMG2;
                this.destSMG = pDestSMG;
                this.status = pStatus;
                return Pair.of(true, true);
            }
            return Pair.of(false, true);
        }
        int level = this.getLevelOfOptionalObject(pValue1, pLevelMapping, this.inputSMG1, this.mapping1, pLevelV1, pLevelV2);
        SMGLevelMapping newLevelMap = new SMGLevelMapping();
        newLevelMap.putAll(pLevelMapping);
        newLevelMap.put(SMGJoinLevel.valueOf(pLevelV1, pLevelV2), level);
        SMGOptionalObject optionalObject = new SMGOptionalObject(pTarget.getSize(), level);
        this.mapping1.map(pTarget, optionalObject);
        ((CLangSMG)pDestSMG).addHeapObject(optionalObject);
        pDestSMG.setValidity(optionalObject, pInputSMG1.isObjectValid(pTarget));
        SMGKnownSymbolicValue resultPointer = SMGKnownSymValue.of();
        SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, optionalObject, pointedToTargetEdge.getOffset(), SMGTargetSpecifier.OPT);
        pDestSMG.addValue(resultPointer);
        pDestSMG.addPointsToEdge(newJointPtEdge);
        this.mapping1.map(pValue1, resultPointer);
        SMGJoinStatus newJoinStatus = pTarget.getKind() == SMGObjectKind.OPTIONAL ? SMGJoinStatus.LEFT_ENTAIL : SMGJoinStatus.INCOMPARABLE;
        SMGJoinStatus updatedStatus = pStatus.updateWith(newJoinStatus);
        SMGJoinValues jv = new SMGJoinValues(updatedStatus, pInputSMG1, pInputSMG2, pDestSMG, this.mapping1, this.mapping2, newLevelMap, nextPointer, pValue2, pLDiff, pIdenticalInputSmg, pLevelV1, pLevelV2, pPrevDestLevel, this.smgState1, this.smgState2);
        if (jv.isDefined()) {
            newAddressFromOptionalObject = jv.getValue();
            if (pDestSMG.getPointer(newAddressFromOptionalObject).getTargetSpecifier() == SMGTargetSpecifier.OPT) {
                return Pair.of(false, false);
            }
        } else {
            return Pair.of(false, true);
        }
        this.status = jv.getStatus();
        this.inputSMG1 = jv.getInputSMG1();
        this.inputSMG2 = jv.getInputSMG2();
        this.destSMG = jv.getDestinationSMG();
        this.value = resultPointer;
        this.defined = jv.defined;
        for (SMGEdgeHasValue field : fieldsOfTarget) {
            SMGEdgeHasValue newHve;
            if (field.getValue().equals(nextPointer)) {
                newHve = new SMGEdgeHasValue(field.getSizeInBits(), field.getOffset(), (SMGObject)optionalObject, newAddressFromOptionalObject);
            } else {
                SMGValue newVal;
                SMGValue val = field.getValue();
                if (this.mapping1.containsKey(val) || val.isZero()) {
                    newVal = val;
                } else {
                    newVal = SMGKnownSymValue.of();
                    this.mapping1.map(val, newVal);
                    pDestSMG.addValue(newVal);
                }
                newHve = new SMGEdgeHasValue(field.getSizeInBits(), field.getOffset(), (SMGObject)optionalObject, newVal);
            }
            if (!pDestSMG.getValues().contains(newHve.getValue())) {
                pDestSMG.addValue(newHve.getValue());
            }
            if (!this.mapping1.containsKey(field.getValue())) {
                this.mapping1.map(field.getValue(), newHve.getValue());
            }
            pDestSMG.addHasValueEdge(newHve);
        }
        return Pair.of(true, true);
    }

    private Pair<Boolean, Boolean> insertLeftListAndJoin(SMGJoinStatus pStatus, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, SMG pDestSMG, SMGLevelMapping pLevelMap, SMGValue pointer1, SMGValue pointer2, SMGObject pTarget, int ldiff, int level1, int level2, boolean identicalInputSmg, int pPrevDestLevel) throws SMGInconsistentException {
        SMGEdgeHasValue newHve2;
        SMGJoinValues jv;
        int length;
        long pfo;
        long nfo;
        long hfo;
        long nf;
        SMGEdgePointsTo ptEdge = pInputSMG1.getPointer(pointer1);
        SMGJoinStatus newStatus = pStatus;
        UnmodifiableSMG newInputSMG1 = pInputSMG1;
        UnmodifiableSMG newInputSMG2 = pInputSMG2;
        SMG newDestSMG = pDestSMG;
        switch (ptEdge.getTargetSpecifier()) {
            case FIRST: {
                SMGDoublyLinkedList dll;
                if (pTarget.getKind() == SMGObjectKind.DLL) {
                    dll = (SMGDoublyLinkedList)pTarget;
                    nf = dll.getNfo();
                    hfo = dll.getHfo();
                    nfo = nf;
                    pfo = dll.getPfo();
                    length = dll.getMinimumLength();
                    break;
                }
                SMGSingleLinkedList sll = (SMGSingleLinkedList)pTarget;
                nf = sll.getNfo();
                hfo = sll.getHfo();
                nfo = nf;
                pfo = -1L;
                length = sll.getMinimumLength();
                break;
            }
            case LAST: {
                SMGDoublyLinkedList dll = (SMGDoublyLinkedList)pTarget;
                nf = dll.getPfo();
                hfo = dll.getHfo();
                nfo = dll.getPfo();
                pfo = nf;
                length = dll.getMinimumLength();
                break;
            }
            default: {
                return Pair.of(false, true);
            }
        }
        Iterable<SMGEdgeHasValue> hvesNp = newInputSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pTarget).filterAtOffset(nf).filterBySize(newDestSMG.getSizeofPtrInBits()));
        SMGValue nextPointer = !hvesNp.iterator().hasNext() ? SMGZeroValue.INSTANCE : ((SMGEdgeHasValue)Iterables.getOnlyElement(hvesNp)).getValue();
        if (this.mapping1.containsKey(pTarget)) {
            SMGObject jointList = this.mapping1.get(pTarget);
            if (this.mapping2.containsValue(jointList)) {
                return Pair.of(false, true);
            }
            if (this.mapping1.containsKey(pointer1)) {
                this.value = this.mapping1.get(pointer1);
                this.defined = true;
                this.inputSMG1 = newInputSMG1;
                this.inputSMG2 = newInputSMG2;
                this.destSMG = newDestSMG;
                this.status = newStatus;
                return Pair.of(true, true);
            }
            SMGKnownSymbolicValue resultPointer = SMGKnownSymValue.of();
            SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, jointList, ptEdge.getOffset(), ptEdge.getTargetSpecifier());
            newDestSMG.addValue(resultPointer);
            newDestSMG.addPointsToEdge(newJointPtEdge);
            this.mapping1.map(pointer1, resultPointer);
            SMGJoinValues jv2 = new SMGJoinValues(newStatus, newInputSMG1, newInputSMG2, newDestSMG, this.mapping1, this.mapping2, pLevelMap, nextPointer, pointer2, ldiff, identicalInputSmg, level1, level2, pPrevDestLevel, this.smgState1, this.smgState2);
            if (jv2.isDefined()) {
                newStatus = jv2.getStatus();
                newInputSMG1 = jv2.getInputSMG1();
                newInputSMG2 = jv2.getInputSMG2();
                newDestSMG = jv2.getDestinationSMG();
            } else {
                return Pair.of(false, false);
            }
        }
        if (this.mapping1.containsKey(nextPointer) && this.mapping2.containsKey(pointer2) && !this.mapping2.get(pointer2).equals(this.mapping1.get(nextPointer))) {
            return Pair.of(false, true);
        }
        SMGJoinStatus newJoinStatus = length == 0 ? SMGJoinStatus.LEFT_ENTAIL : SMGJoinStatus.INCOMPARABLE;
        newStatus = newStatus.updateWith(newJoinStatus);
        int lvlDiff = pPrevDestLevel - pTarget.getLevel();
        if (level1 < level2) {
            ++lvlDiff;
        }
        this.copyDlsSubSmgToDestSMG(pTarget, this.mapping1, newInputSMG1, newDestSMG, lvlDiff);
        SMGObject list = this.mapping1.get(pTarget);
        SMGValue resultPointer = null;
        Set<SMGEdgePointsTo> edges = pDestSMG.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(list).filterAtTargetOffset(ptEdge.getOffset()).filterByTargetSpecifier(ptEdge.getTargetSpecifier()));
        if (!edges.isEmpty()) {
            resultPointer = ((SMGEdgePointsTo)Iterables.getOnlyElement(edges)).getValue();
        }
        if (resultPointer == null) {
            resultPointer = SMGKnownSymValue.of();
            SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, list, ptEdge.getOffset(), ptEdge.getTargetSpecifier());
            newDestSMG.addValue(resultPointer);
            newDestSMG.addPointsToEdge(newJointPtEdge);
            this.mapping1.map(pointer1, resultPointer);
        }
        if (!(jv = new SMGJoinValues(newStatus, newInputSMG1, newInputSMG2, newDestSMG, this.mapping1, this.mapping2, pLevelMap, nextPointer, pointer2, ldiff, identicalInputSmg, level1, level2, pPrevDestLevel, this.smgState1, this.smgState2)).isDefined()) {
            return Pair.of(false, false);
        }
        this.status = jv.getStatus();
        this.inputSMG1 = jv.getInputSMG1();
        this.inputSMG2 = jv.getInputSMG2();
        this.destSMG = jv.getDestinationSMG();
        SMGValue newAdressFromDLS = jv.getValue();
        this.value = resultPointer;
        this.defined = jv.defined;
        long nfSize = this.getSize(pTarget, nf, newInputSMG1);
        SMGEdgeHasValue newHve = new SMGEdgeHasValue(nfSize, nf, list, newAdressFromDLS);
        if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve)).iterator().hasNext()) {
            pDestSMG.addHasValueEdge(newHve);
        } else {
            for (SMGEdgeHasValue currentValue : pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve))) {
                if (currentValue.getValue().equals(newAdressFromDLS)) continue;
                return Pair.of(false, false);
            }
        }
        if (this.smgState1.getAddress(pTarget, hfo, SMGTargetSpecifier.FIRST) == null) {
            long nfSize2 = this.getSize(pTarget, nfo, newInputSMG1);
            newHve2 = new SMGEdgeHasValue(nfSize2, nfo, list, newAdressFromDLS);
            if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve2)).iterator().hasNext()) {
                pDestSMG.addHasValueEdge(newHve2);
            }
        }
        if (pTarget.getKind() == SMGObjectKind.DLL && this.smgState1.getAddress(pTarget, hfo, SMGTargetSpecifier.LAST) == null) {
            long nfSize2 = this.getSize(pTarget, pfo, newInputSMG1);
            newHve2 = new SMGEdgeHasValue(nfSize2, pfo, list, newAdressFromDLS);
            if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve2)).iterator().hasNext()) {
                pDestSMG.addHasValueEdge(newHve2);
            }
        }
        return Pair.of(true, true);
    }

    private long getSize(SMGObject pTarget, long pNf, UnmodifiableSMG pInputSMG1) {
        Iterable<SMGEdgeHasValue> oldNfEdge = pInputSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pTarget).filterAtOffset(pNf).filterWithoutSize());
        if (!oldNfEdge.iterator().hasNext()) {
            return new SMGEdgeHasValue(pInputSMG1.getSizeofPtrInBits(), pNf, pTarget, (SMGValue)SMGZeroValue.INSTANCE).getSizeInBits();
        }
        return ((SMGEdgeHasValue)Iterables.getOnlyElement(oldNfEdge)).getSizeInBits();
    }

    private Pair<Boolean, Boolean> insertRightListAndJoin(SMGJoinStatus pStatus, UnmodifiableSMG pInputSMG1, UnmodifiableSMG pInputSMG2, SMG pDestSMG, SMGLevelMapping pLevelMap, SMGValue pointer1, SMGValue pointer2, SMGObject pTarget, int ldiff, int level1, int level2, boolean identicalInputSmg, int pPrevDestLevel) throws SMGInconsistentException {
        SMGEdgeHasValue newHve2;
        SMGJoinValues jv;
        int length;
        long pfo;
        long nfo;
        long hfo;
        long nf;
        SMGEdgePointsTo ptEdge = pInputSMG2.getPointer(pointer2);
        SMGJoinStatus newStatus = pStatus;
        UnmodifiableSMG newInputSMG1 = pInputSMG1;
        UnmodifiableSMG newInputSMG2 = pInputSMG2;
        SMG newDestSMG = pDestSMG;
        switch (ptEdge.getTargetSpecifier()) {
            case FIRST: {
                SMGDoublyLinkedList dll;
                if (pTarget.getKind() == SMGObjectKind.DLL) {
                    dll = (SMGDoublyLinkedList)pTarget;
                    nf = dll.getNfo();
                    hfo = dll.getHfo();
                    nfo = nf;
                    pfo = dll.getPfo();
                    length = dll.getMinimumLength();
                    break;
                }
                SMGSingleLinkedList sll = (SMGSingleLinkedList)pTarget;
                nf = sll.getNfo();
                hfo = sll.getHfo();
                nfo = nf;
                pfo = -1L;
                length = sll.getMinimumLength();
                break;
            }
            case LAST: {
                SMGDoublyLinkedList dll = (SMGDoublyLinkedList)pTarget;
                nf = dll.getPfo();
                hfo = dll.getHfo();
                nfo = dll.getPfo();
                pfo = nf;
                length = dll.getMinimumLength();
                break;
            }
            default: {
                return Pair.of(false, true);
            }
        }
        Iterable<SMGEdgeHasValue> npHves = newInputSMG2.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pTarget).filterAtOffset(nf).filterBySize(newInputSMG2.getSizeofPtrInBits()));
        SMGValue nextPointer = !npHves.iterator().hasNext() ? SMGZeroValue.INSTANCE : ((SMGEdgeHasValue)Iterables.getOnlyElement(npHves)).getValue();
        if (this.mapping2.containsKey(pTarget)) {
            SMGObject jointList = this.mapping2.get(pTarget);
            if (this.mapping1.containsValue(jointList)) {
                return Pair.of(false, true);
            }
            if (this.mapping2.containsKey(pointer2)) {
                this.value = this.mapping2.get(pointer2);
                this.defined = true;
                this.inputSMG1 = newInputSMG1;
                this.inputSMG2 = newInputSMG2;
                this.destSMG = newDestSMG;
                this.status = newStatus;
                return Pair.of(true, true);
            }
            SMGKnownSymbolicValue resultPointer = SMGKnownSymValue.of();
            SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, jointList, ptEdge.getOffset(), ptEdge.getTargetSpecifier());
            newDestSMG.addValue(resultPointer);
            newDestSMG.addPointsToEdge(newJointPtEdge);
            this.mapping2.map(pointer2, resultPointer);
            SMGJoinValues jv2 = new SMGJoinValues(newStatus, newInputSMG1, newInputSMG2, newDestSMG, this.mapping1, this.mapping2, pLevelMap, pointer1, nextPointer, ldiff, identicalInputSmg, level1, level2, pPrevDestLevel, this.smgState1, this.smgState2);
            if (jv2.isDefined()) {
                newStatus = jv2.getStatus();
                newInputSMG1 = jv2.getInputSMG1();
                newInputSMG2 = jv2.getInputSMG2();
                newDestSMG = jv2.getDestinationSMG();
            } else {
                return Pair.of(false, false);
            }
        }
        if (this.mapping2.containsKey(nextPointer) && this.mapping1.containsKey(pointer1) && !this.mapping1.get(pointer1).equals(this.mapping2.get(nextPointer))) {
            return Pair.of(false, true);
        }
        SMGJoinStatus newJoinStatus = length == 0 ? SMGJoinStatus.RIGHT_ENTAIL : SMGJoinStatus.INCOMPARABLE;
        newStatus = newStatus.updateWith(newJoinStatus);
        int levelDiff = pPrevDestLevel - pTarget.getLevel();
        if (level1 > level2) {
            ++levelDiff;
        }
        this.copyDlsSubSmgToDestSMG(pTarget, this.mapping2, newInputSMG2, newDestSMG, levelDiff);
        SMGObject list = this.mapping2.get(pTarget);
        SMGValue resultPointer = null;
        Set<SMGEdgePointsTo> edges = pDestSMG.getPtEdges(SMGEdgePointsToFilter.targetObjectFilter(list).filterAtTargetOffset(ptEdge.getOffset()).filterByTargetSpecifier(ptEdge.getTargetSpecifier()));
        if (!edges.isEmpty()) {
            resultPointer = ((SMGEdgePointsTo)Iterables.getOnlyElement(edges)).getValue();
        }
        if (resultPointer == null) {
            resultPointer = SMGKnownSymValue.of();
            SMGEdgePointsTo newJointPtEdge = new SMGEdgePointsTo(resultPointer, list, ptEdge.getOffset(), ptEdge.getTargetSpecifier());
            newDestSMG.addValue(resultPointer);
            newDestSMG.addPointsToEdge(newJointPtEdge);
            this.mapping2.map(pointer2, resultPointer);
        }
        if (!(jv = new SMGJoinValues(newStatus, newInputSMG1, newInputSMG2, newDestSMG, this.mapping1, this.mapping2, pLevelMap, pointer1, nextPointer, ldiff, identicalInputSmg, level1, level2, pPrevDestLevel, this.smgState1, this.smgState2)).isDefined()) {
            return Pair.of(false, false);
        }
        this.status = jv.getStatus();
        this.inputSMG1 = jv.getInputSMG1();
        this.inputSMG2 = jv.getInputSMG2();
        this.destSMG = jv.getDestinationSMG();
        SMGValue newAdressFromDLS = jv.getValue();
        this.value = resultPointer;
        this.defined = jv.defined;
        long nfSize = this.getSize(pTarget, nf, newInputSMG2);
        SMGEdgeHasValue newHve = new SMGEdgeHasValue(nfSize, nf, list, newAdressFromDLS);
        if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve)).iterator().hasNext()) {
            pDestSMG.addHasValueEdge(newHve);
        } else {
            for (SMGEdgeHasValue currentValue : pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve))) {
                if (currentValue.getValue().equals(newAdressFromDLS)) continue;
                return Pair.of(false, false);
            }
        }
        if (this.smgState2.getAddress(pTarget, hfo, SMGTargetSpecifier.FIRST) == null) {
            long nfSize2 = this.getSize(pTarget, nfo, newInputSMG2);
            newHve2 = new SMGEdgeHasValue(nfSize2, nfo, list, newAdressFromDLS);
            if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve2)).iterator().hasNext()) {
                pDestSMG.addHasValueEdge(newHve2);
            }
        }
        if (pTarget.getKind() == SMGObjectKind.DLL && this.smgState2.getAddress(pTarget, hfo, SMGTargetSpecifier.LAST) == null) {
            long nfSize2 = this.getSize(pTarget, nfo, newInputSMG2);
            newHve2 = new SMGEdgeHasValue(nfSize2, pfo, list, newAdressFromDLS);
            if (!pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(list).overlapsWith(newHve2)).iterator().hasNext()) {
                pDestSMG.addHasValueEdge(newHve2);
            }
        }
        return Pair.of(true, true);
    }

    private void copyDlsSubSmgToDestSMG(SMGObject pList, SMGNodeMapping pMapping, UnmodifiableSMG pInputSMG1, SMG pDestSMG, int pLevelDiff) {
        SMGObject listCopy;
        HashSet<SMGObject> toBeChecked = new HashSet<SMGObject>();
        int listLevel = pList.getLevel() + pLevelDiff;
        long nfo = -1L;
        long pfo = -1L;
        if (pMapping.containsKey(pList)) {
            listCopy = pMapping.get(pList);
        } else {
            switch (pList.getKind()) {
                case DLL: {
                    SMGDoublyLinkedList dll = (SMGDoublyLinkedList)pList;
                    nfo = dll.getNfo();
                    pfo = dll.getPfo();
                    long hfo = dll.getHfo();
                    listCopy = new SMGDoublyLinkedList(pList.getSize(), hfo, nfo, pfo, 0, listLevel);
                    break;
                }
                case SLL: {
                    SMGSingleLinkedList sll = (SMGSingleLinkedList)pList;
                    nfo = sll.getNfo();
                    long hfo = sll.getHfo();
                    listCopy = new SMGSingleLinkedList(pList.getSize(), hfo, nfo, 0, listLevel);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            pMapping.map(pList, listCopy);
            ((CLangSMG)pDestSMG).addHeapObject(listCopy);
        }
        for (SMGEdgeHasValue hve : pInputSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pList))) {
            SMGValue subDlsValue;
            if (hve.getOffset() == pfo || hve.getOffset() == nfo) continue;
            SMGValue newVal = subDlsValue = hve.getValue();
            if (pInputSMG1.isPointer(subDlsValue)) {
                SMGEdgePointsTo reachedObjectSubSmgPTEdge = pInputSMG1.getPointer(subDlsValue);
                SMGObject reachedObjectSubSmg = reachedObjectSubSmgPTEdge.getObject();
                int level = reachedObjectSubSmg.getLevel();
                if (!newVal.isZero()) {
                    SMGObject copyOfReachedObject;
                    if (!pMapping.containsKey(reachedObjectSubSmg)) {
                        int newLevel = level + pLevelDiff;
                        copyOfReachedObject = reachedObjectSubSmg.copy(newLevel);
                        pMapping.map(reachedObjectSubSmg, copyOfReachedObject);
                        ((CLangSMG)pDestSMG).addHeapObject(copyOfReachedObject);
                        pDestSMG.setValidity(copyOfReachedObject, pInputSMG1.isObjectValid(reachedObjectSubSmg));
                        toBeChecked.add(reachedObjectSubSmg);
                    } else {
                        copyOfReachedObject = pMapping.get(reachedObjectSubSmg);
                    }
                    if (pMapping.containsKey(subDlsValue)) {
                        newVal = pMapping.get(subDlsValue);
                    } else {
                        newVal = SMGKnownSymValue.of();
                        pDestSMG.addValue(newVal);
                        pMapping.map(subDlsValue, newVal);
                        SMGTargetSpecifier newTg = copyOfReachedObject instanceof SMGRegion ? SMGTargetSpecifier.REGION : reachedObjectSubSmgPTEdge.getTargetSpecifier();
                        SMGEdgePointsTo newPtEdge = new SMGEdgePointsTo(newVal, copyOfReachedObject, reachedObjectSubSmgPTEdge.getOffset(), newTg);
                        pDestSMG.addPointsToEdge(newPtEdge);
                    }
                }
            }
            SMGEdgeHasValue newEdge = new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), listCopy, newVal);
            if (pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(listCopy).overlapsWith(newEdge)).iterator().hasNext()) continue;
            if (!pDestSMG.getValues().contains(newVal)) {
                pDestSMG.addValue(newVal);
            }
            if (!pMapping.containsKey(subDlsValue)) {
                pMapping.map(subDlsValue, newVal);
            }
            pDestSMG.addHasValueEdge(newEdge);
        }
        HashSet<SMGObject> toCheck = new HashSet<SMGObject>();
        while (!toBeChecked.isEmpty()) {
            toCheck.clear();
            toCheck.addAll(toBeChecked);
            toBeChecked.clear();
            for (SMGObject objToCheck : toCheck) {
                this.copyObjectAndNodesIntoDestSMG(objToCheck, toBeChecked, pMapping, pInputSMG1, pDestSMG, pLevelDiff);
            }
        }
    }

    private void copyObjectAndNodesIntoDestSMG(SMGObject pObjToCheck, Set<SMGObject> pToBeChecked, SMGNodeMapping pMapping, UnmodifiableSMG pInputSMG1, SMG pDestSMG, int pLevelDiff) {
        SMGObject newObj = pMapping.get(pObjToCheck);
        for (SMGEdgeHasValue hve : pInputSMG1.getHVEdges(SMGEdgeHasValueFilter.objectFilter(pObjToCheck))) {
            SMGValue subDlsValue;
            SMGValue newVal = subDlsValue = hve.getValue();
            if (pInputSMG1.isPointer(subDlsValue)) {
                SMGEdgePointsTo reachedObjectSubSmgPTEdge = pInputSMG1.getPointer(subDlsValue);
                SMGObject reachedObjectSubSmg = reachedObjectSubSmgPTEdge.getObject();
                int level = reachedObjectSubSmg.getLevel();
                if (!newVal.isZero()) {
                    SMGObject copyOfReachedObject;
                    if (!pMapping.containsKey(reachedObjectSubSmg)) {
                        int newLevel = level + pLevelDiff;
                        copyOfReachedObject = reachedObjectSubSmg.copy(newLevel);
                        if (!copyOfReachedObject.equals(SMGNullObject.INSTANCE)) {
                            pMapping.map(reachedObjectSubSmg, copyOfReachedObject);
                            ((CLangSMG)pDestSMG).addHeapObject(copyOfReachedObject);
                            pDestSMG.setValidity(copyOfReachedObject, pInputSMG1.isObjectValid(reachedObjectSubSmg));
                        }
                        pToBeChecked.add(reachedObjectSubSmg);
                    } else {
                        copyOfReachedObject = pMapping.get(reachedObjectSubSmg);
                    }
                    if (pMapping.containsKey(subDlsValue)) {
                        newVal = pMapping.get(subDlsValue);
                    } else {
                        newVal = SMGKnownSymValue.of();
                        pDestSMG.addValue(newVal);
                        pMapping.map(subDlsValue, newVal);
                        SMGTargetSpecifier newTg = copyOfReachedObject instanceof SMGRegion ? SMGTargetSpecifier.REGION : reachedObjectSubSmgPTEdge.getTargetSpecifier();
                        SMGEdgePointsTo newPtEdge = new SMGEdgePointsTo(newVal, copyOfReachedObject, reachedObjectSubSmgPTEdge.getOffset(), newTg);
                        pDestSMG.addPointsToEdge(newPtEdge);
                    }
                }
            }
            if (pDestSMG.getHVEdges(SMGEdgeHasValueFilter.objectFilter(newObj).filterAtOffset(hve.getOffset()).filterWithoutSize()).iterator().hasNext()) continue;
            if (!pDestSMG.getValues().contains(newVal)) {
                pDestSMG.addValue(newVal);
            }
            if (!pMapping.containsKey(subDlsValue)) {
                pMapping.map(subDlsValue, newVal);
            }
            pDestSMG.addHasValueEdge(new SMGEdgeHasValue(hve.getSizeInBits(), hve.getOffset(), newObj, newVal));
        }
    }

    public SMGJoinStatus getStatus() {
        return this.status;
    }

    public UnmodifiableSMG getInputSMG1() {
        return this.inputSMG1;
    }

    public UnmodifiableSMG getInputSMG2() {
        return this.inputSMG2;
    }

    public SMG getDestinationSMG() {
        return this.destSMG;
    }

    public SMGValue getValue() {
        return this.value;
    }

    public boolean isDefined() {
        return this.defined;
    }

    public boolean isRecoverable() {
        return this.recoverable;
    }

    public boolean subSmgHasAbstractionsCandidates() {
        return false;
    }

    public List<SMGGenericAbstractionCandidate> getAbstractionCandidates() {
        return this.abstractionCandidates;
    }
}

