/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import com.google.common.truth.Truth;
import org.junit.Before;
import org.junit.Test;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.SMG;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgePointsTo;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGKnownSymValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinStatus;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGJoinValues;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGLevelMapping;
import org.sosy_lab.cpachecker.cpa.smg.join.SMGNodeMapping;

public class SMGJoinValuesTest {
    private SMG smg1;
    private SMG smg2;
    private SMG smgDest;
    private SMGState dummyState;
    private SMGNodeMapping mapping1;
    private SMGNodeMapping mapping2;
    private final SMGValue value1 = SMGKnownSymValue.of();
    private final SMGValue value2 = SMGKnownSymValue.of();
    private final SMGValue value3 = SMGKnownSymValue.of();

    @Before
    public void setUp() throws InvalidConfigurationException {
        this.dummyState = new SMGState(LogManager.createTestLogManager(), MachineModel.LINUX32, new SMGOptions(Configuration.defaultConfiguration()));
        this.smg1 = new SMG(MachineModel.LINUX64);
        this.smg2 = new SMG(MachineModel.LINUX64);
        this.smgDest = new SMG(MachineModel.LINUX64);
        this.mapping1 = new SMGNodeMapping();
        this.mapping2 = new SMGNodeMapping();
    }

    @Test
    public void joinValuesAlreadyJoinedTest() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        this.mapping1.map(this.value1, this.value3);
        this.mapping2.map(this.value2, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, false, 0, 0, 0, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)jv.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jv.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jv.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jv.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jv.getDestinationSMG()).isSameInstanceAs((Object)this.smgDest);
        Truth.assertThat((Object)jv.mapping1).isSameInstanceAs((Object)this.mapping1);
        Truth.assertThat((Object)jv.mapping2).isSameInstanceAs((Object)this.mapping2);
        Truth.assertThat((Comparable)jv.getValue()).isEqualTo((Object)this.value3);
    }

    @Test
    public void joinValuesNonPointers() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        this.mapping1.map(this.value1, this.value3);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, false, 0, 0, 0, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
        this.mapping1 = new SMGNodeMapping();
        this.mapping2.map(this.value2, this.value3);
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, false, 0, 0, 0, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
        this.mapping2 = new SMGNodeMapping();
        jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, false, 0, 0, 0, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)jv.isDefined()).isTrue();
        Truth.assertThat((Comparable)((Object)jv.getStatus())).isEqualTo((Object)SMGJoinStatus.EQUAL);
        Truth.assertThat((Object)jv.getInputSMG1()).isSameInstanceAs((Object)this.smg1);
        Truth.assertThat((Object)jv.getInputSMG2()).isSameInstanceAs((Object)this.smg2);
        Truth.assertThat((Object)jv.getDestinationSMG()).isSameInstanceAs((Object)this.smgDest);
        Truth.assertThat((Object)jv.mapping1).isSameInstanceAs((Object)this.mapping1);
        Truth.assertThat((Object)jv.mapping2).isSameInstanceAs((Object)this.mapping2);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value1);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value2);
        Truth.assertThat((Comparable)jv.getValue()).isNotEqualTo((Object)this.value3);
        Truth.assertThat((Comparable)this.mapping1.get(this.value1)).isEqualTo((Object)jv.getValue());
        Truth.assertThat((Comparable)this.mapping2.get(this.value2)).isEqualTo((Object)jv.getValue());
    }

    @Test
    public void joinValuesSinglePointer() throws SMGInconsistentException {
        this.smg1.addValue(this.value1);
        this.smg2.addValue(this.value2);
        this.smgDest.addValue(this.value3);
        SMGRegion obj1 = new SMGRegion(64L, "Object");
        SMGEdgePointsTo pt = new SMGEdgePointsTo(this.value1, obj1, 0L);
        this.smg1.addPointsToEdge(pt);
        SMGJoinValues jv = new SMGJoinValues(SMGJoinStatus.EQUAL, this.smg1, this.smg2, this.smgDest, this.mapping1, this.mapping2, SMGLevelMapping.createDefaultLevelMap(), this.value1, this.value2, 0, false, 0, 0, 0, this.dummyState, this.dummyState);
        Truth.assertThat((Boolean)jv.isDefined()).isFalse();
    }
}

