/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.join;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGObject;
import org.sosy_lab.cpachecker.cpa.smg.graphs.value.SMGValue;

public class SMGNodeMapping {
    private final Map<SMGObject, SMGObject> object_map = new HashMap<SMGObject, SMGObject>();
    private final Map<SMGValue, SMGValue> value_map = new HashMap<SMGValue, SMGValue>();

    public int hashCode() {
        return Objects.hash(this.object_map, this.value_map);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SMGNodeMapping)) {
            return false;
        }
        SMGNodeMapping other = (SMGNodeMapping)obj;
        return Objects.equals(this.object_map, other.object_map) && Objects.equals(this.value_map, other.value_map);
    }

    public SMGNodeMapping() {
    }

    public SMGNodeMapping(SMGNodeMapping origin) {
        this.object_map.putAll(origin.object_map);
        this.value_map.putAll(origin.value_map);
    }

    public SMGValue get(SMGValue i) {
        return this.value_map.get(i);
    }

    public SMGObject get(SMGObject o) {
        return this.object_map.get(o);
    }

    public void map(SMGObject key, SMGObject value) {
        this.object_map.put(key, value);
    }

    public void map(SMGValue key, SMGValue value) {
        this.value_map.put(key, value);
    }

    public void removeValue(SMGValue value) {
        for (Map.Entry<SMGValue, SMGValue> entry : this.value_map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            this.value_map.remove(entry.getKey());
            return;
        }
    }

    public void removeValue(SMGObject value) {
        for (Map.Entry<SMGObject, SMGObject> entry : this.object_map.entrySet()) {
            if (!entry.getValue().equals(value)) continue;
            this.object_map.remove(entry.getKey());
            return;
        }
    }

    public boolean containsKey(SMGValue key) {
        return this.value_map.containsKey(key);
    }

    public boolean containsKey(SMGObject key) {
        return this.object_map.containsKey(key);
    }

    public boolean containsValue(SMGObject value) {
        return this.object_map.containsValue(value);
    }

    public Set<Map.Entry<SMGObject, SMGObject>> getObject_mapEntrySet() {
        return this.object_map.entrySet();
    }

    public Set<Map.Entry<SMGValue, SMGValue>> getValue_mapEntrySet() {
        return this.value_map.entrySet();
    }

    public String toString() {
        return "Objects:\n" + this.object_map + "\nValues:\n" + this.value_map;
    }
}

