/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.core.interfaces.Refiner;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGCPA;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGCPA;
import org.sosy_lab.cpachecker.util.CPAs;

public class SMGBasicRefiner
implements Refiner {
    private final LogManager logger;
    private final ARGCPA argCpa;
    private static Set<ARGState> cache;

    private SMGBasicRefiner(LogManager pLogger, ARGCPA pArgCpa) {
        this.logger = pLogger;
        this.argCpa = pArgCpa;
    }

    public static SMGBasicRefiner create(ConfigurableProgramAnalysis pCpa) throws InvalidConfigurationException {
        ARGCPA argCpa = CPAs.retrieveCPAOrFail(pCpa, ARGCPA.class, SMGBasicRefiner.class);
        SMGCPA smgCpa = CPAs.retrieveCPAOrFail(pCpa, SMGCPA.class, SMGBasicRefiner.class);
        cache = new HashSet<ARGState>();
        return new SMGBasicRefiner(smgCpa.getLogger(), argCpa);
    }

    @Override
    public boolean performRefinement(ReachedSet pReached) throws InterruptedException {
        Map<ARGState, CounterexampleInfo> counterexamples = this.argCpa.getARGExporter().getAllCounterexamples(pReached);
        this.logger.log(Level.FINEST, new Object[]{"Filtering new SMG counterexample."});
        for (Map.Entry<ARGState, CounterexampleInfo> cex : counterexamples.entrySet()) {
            ARGState lastSate = cex.getKey();
            if (!cache.add(lastSate)) continue;
            this.argCpa.getARGExporter().exportCounterexampleOnTheFly(lastSate, cex.getValue());
        }
        this.logger.log(Level.FINEST, new Object[]{"SMG counterexample has been exported."});
        return false;
    }
}

