/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import java.util.HashSet;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionCandidate;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGEdgeInterpolator;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;

public class SMGEdgeHeapAbstractionInterpolator {
    private final LogManager logger;
    private final SMGFeasibilityChecker checker;
    private final BlockOperator blockOperator;

    public SMGEdgeHeapAbstractionInterpolator(LogManager pLogger, SMGFeasibilityChecker pChecker, BlockOperator pBlockOperator) {
        this.logger = pLogger;
        this.checker = pChecker;
        this.blockOperator = pBlockOperator;
    }

    public SMGEdgeInterpolator.SMGHeapAbstractionInterpoaltionResult calculateHeapAbstractionBlocks(SMGState pState, ARGPath pRemainingErrorPath, SMGPrecision pPrecision, CFANode pStateLocation, CFAEdge pCurrentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        SMGState state = pState;
        if (!pPrecision.allowsHeapAbstractionOnNode(pStateLocation, this.blockOperator)) {
            return SMGEdgeInterpolator.SMGHeapAbstractionInterpoaltionResult.emptyAndUnchanged();
        }
        this.logger.log(Level.ALL, new Object[]{"Begin interpolating heap abstraction on node " + pStateLocation.getNodeNumber()});
        SMGState abstractionTest = pState.copyOf();
        HashSet<SMGAbstractionBlock> result = new HashSet<SMGAbstractionBlock>(pPrecision.getAbstractionBlocks(pStateLocation));
        SMGAbstractionCandidate candidate = abstractionTest.executeHeapAbstractionOneStep(result);
        boolean change = false;
        while (!candidate.isEmpty()) {
            if (this.isRemainingPathFeasible(pRemainingErrorPath, abstractionTest, pCurrentEdge, pAllTargets)) {
                result.add(candidate.createAbstractionBlock(state));
                abstractionTest = state.copyOf();
            } else {
                state.executeHeapAbstractionOneStep(result);
                change = true;
            }
            candidate = abstractionTest.executeHeapAbstractionOneStep(result);
        }
        this.logger.log(Level.ALL, new Object[]{"Finish interpolating heap abstraction on node " + pStateLocation.getNodeNumber()});
        if (!change && result.isEmpty()) {
            return SMGEdgeInterpolator.SMGHeapAbstractionInterpoaltionResult.emptyAndUnchanged();
        }
        return new SMGEdgeInterpolator.SMGHeapAbstractionInterpoaltionResult(result, change);
    }

    private boolean isRemainingPathFeasible(ARGPath pRemainingErrorPath, UnmodifiableSMGState pAbstractionTest, CFAEdge pCurrentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        return this.checker.isRemainingPathFeasible(pRemainingErrorPath, pAbstractionTest, pCurrentEdge, pAllTargets);
    }
}

