/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cpa.arg.ARGReachedSet;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.SMGStateInformation;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.graphs.edge.SMGEdgeHasValue;
import org.sosy_lab.cpachecker.cpa.smg.graphs.object.SMGRegion;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGEdgeHeapAbstractionInterpolator;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGFeasibilityChecker;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolantManager;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGStrongestPostOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.Precisions;
import org.sosy_lab.cpachecker.util.predicates.BlockOperator;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGEdgeInterpolator {
    private final SMGStrongestPostOperator postOperator;
    private final SMGPrecision strongPrecision;
    private final SMGInterpolantManager interpolantManager;
    private final SMGFeasibilityChecker checker;
    private int numberOfInterpolationQueries = 0;
    private final SMGEdgeHeapAbstractionInterpolator heapAbstractionInterpolator;
    private final ShutdownNotifier shutdownNotifier;
    private final BlockOperator blockOperator;

    public SMGEdgeInterpolator(SMGFeasibilityChecker pFeasibilityChecker, SMGStrongestPostOperator pStrongestPostOperator, SMGInterpolantManager pInterpolantManager, ShutdownNotifier pShutdownNotifier, LogManager pLogger, BlockOperator pBlockOperator) {
        this.checker = pFeasibilityChecker;
        this.postOperator = pStrongestPostOperator;
        this.interpolantManager = pInterpolantManager;
        this.strongPrecision = SMGPrecision.createStaticPrecision(false);
        this.shutdownNotifier = pShutdownNotifier;
        this.blockOperator = pBlockOperator;
        this.heapAbstractionInterpolator = new SMGEdgeHeapAbstractionInterpolator(pLogger, pFeasibilityChecker, pBlockOperator);
    }

    public List<SMGInterpolant> deriveInterpolant(CFAEdge pCurrentEdge, PathPosition pOffset, SMGInterpolant pInputInterpolant, boolean pAllTargets, ARGReachedSet pReached, ARGState pSuccessorARGstate) throws CPAException, InterruptedException {
        boolean onlySuccessor;
        Object intermediate;
        this.numberOfInterpolationQueries = 0;
        CFAEdge currentEdge = pCurrentEdge;
        Object initialStates = pInputInterpolant.reconstructState();
        if (currentEdge == null) {
            PathIterator it = pOffset.fullPathIterator();
            intermediate = initialStates;
            while (intermediate.isEmpty() || !it.isPositionWithState()) {
                ArrayList<SMGState> newIntermediate = new ArrayList<SMGState>();
                Iterator iterator = intermediate.iterator();
                while (iterator.hasNext()) {
                    SMGState state = (SMGState)iterator.next();
                    newIntermediate.addAll(this.getInitialSuccessor(state, it.getOutgoingEdge()));
                }
                intermediate = newIntermediate;
                it.advance();
            }
            initialStates = new HashSet(intermediate);
            currentEdge = it.getOutgoingEdge();
            if (initialStates.isEmpty()) {
                return Collections.singletonList(this.interpolantManager.getFalseInterpolant());
            }
        }
        HashSet<SMGState> successors = new HashSet<SMGState>();
        intermediate = initialStates.iterator();
        while (intermediate.hasNext()) {
            SMGState state = (SMGState)intermediate.next();
            successors.addAll(this.getInitialSuccessor(state, currentEdge));
        }
        if (successors.isEmpty()) {
            return Collections.singletonList(this.interpolantManager.getFalseInterpolant());
        }
        boolean noChange = initialStates.equals(successors) || this.isFunctionOrTypeDeclaration(currentEdge);
        SMGPrecision currentPrecision = Precisions.extractPrecisionByType(pReached.asReachedSet().getPrecision(pSuccessorARGstate), SMGPrecision.class);
        if (noChange && !currentPrecision.allowsHeapAbstractionOnNode(currentEdge.getPredecessor(), this.blockOperator)) {
            return Collections.singletonList(pInputInterpolant);
        }
        boolean bl = onlySuccessor = successors.size() == 1;
        if (onlySuccessor && this.isOnlyVariableRenamingEdge(pCurrentEdge) && !currentPrecision.allowsHeapAbstractionOnNode(currentEdge.getPredecessor(), this.blockOperator)) {
            return Collections.singletonList(this.interpolantManager.createInterpolant((Collection<SMGState>)successors));
        }
        ImmutableList.Builder resultingInterpolants = ImmutableList.builderWithExpectedSize((int)successors.size());
        ARGPath remainingErrorPath = pOffset.iterator().getSuffixExclusive();
        for (SMGState state : successors) {
            if (currentPrecision.getAbstractionOptions().allowsStackAbstraction()) {
                this.interpolateStackVariables(state, remainingErrorPath, currentEdge, pAllTargets);
            }
            if (currentPrecision.getAbstractionOptions().allowsFieldAbstraction()) {
                this.interpolateFields(state, remainingErrorPath, currentEdge, pAllTargets);
            }
            Object abstractionBlocks = ImmutableSet.of();
            if (currentPrecision.getAbstractionOptions().allowsHeapAbstraction()) {
                SMGState originalState = state.copyOf();
                SMGHeapAbstractionInterpoaltionResult heapInterpoaltionResult = this.interpolateHeapAbstraction(state, remainingErrorPath, currentEdge.getPredecessor(), currentEdge, pAllTargets, currentPrecision);
                if (heapInterpoaltionResult.isChanged()) {
                    resultingInterpolants.add((Object)this.interpolantManager.createInterpolant((Collection<SMGState>)Collections.singleton(originalState)));
                    abstractionBlocks = heapInterpoaltionResult.getBlocks();
                }
            }
            SMGInterpolant result = this.interpolantManager.createInterpolant(state, (Set<SMGAbstractionBlock>)abstractionBlocks);
            resultingInterpolants.add((Object)result);
        }
        return resultingInterpolants.build();
    }

    private boolean isFunctionOrTypeDeclaration(CFAEdge pCurrentEdge) {
        if (pCurrentEdge.getEdgeType() == CFAEdgeType.DeclarationEdge) {
            CDeclarationEdge dclEdge = (CDeclarationEdge)pCurrentEdge;
            CDeclaration dcl = dclEdge.getDeclaration();
            return dcl instanceof CFunctionDeclaration || dcl instanceof CTypeDeclaration;
        }
        return false;
    }

    private UnmodifiableSMGState interpolateStackVariables(SMGState pState, ARGPath pRemainingErrorPath, CFAEdge currentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        SMGState state = pState;
        for (Map.Entry<MemoryLocation, SMGRegion> memoryLocationEntry : state.getStackVariables().entrySet()) {
            this.shutdownNotifier.shutdownIfNecessary();
            MemoryLocation memoryLocation = memoryLocationEntry.getKey();
            SMGRegion region = memoryLocationEntry.getValue();
            SMGStateInformation info = state.forgetStackVariable(memoryLocation);
            if (!this.isRemainingPathFeasible(pRemainingErrorPath, state, currentEdge, pAllTargets)) continue;
            state.remember(memoryLocation, region, info);
        }
        return state;
    }

    private UnmodifiableSMGState interpolateFields(SMGState pState, ARGPath pRemainingErrorPath, CFAEdge currentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        SMGState state = pState;
        for (SMGEdgeHasValue currentHveEdge : state.getHeap().getHVEdges()) {
            this.shutdownNotifier.shutdownIfNecessary();
            if (currentHveEdge.getObject().isAbstract()) continue;
            state.forget(currentHveEdge);
            if (!this.isRemainingPathFeasible(pRemainingErrorPath, state, currentEdge, pAllTargets)) continue;
            state.remember(currentHveEdge);
        }
        return state;
    }

    private SMGHeapAbstractionInterpoaltionResult interpolateHeapAbstraction(SMGState pInitialSuccessor, ARGPath pRemainingErrorPath, CFANode pStateLocation, CFAEdge pCurrentEdge, boolean pAllTargets, SMGPrecision pCurrentPrecision) throws CPAException, InterruptedException {
        return this.heapAbstractionInterpolator.calculateHeapAbstractionBlocks(pInitialSuccessor, pRemainingErrorPath, pCurrentPrecision, pStateLocation, pCurrentEdge, pAllTargets);
    }

    private Collection<SMGState> getInitialSuccessor(SMGState pState, CFAEdge pCurrentEdge) throws CPAException, InterruptedException {
        return this.getInitialSuccessor(pState, pCurrentEdge, this.strongPrecision);
    }

    private Collection<SMGState> getInitialSuccessor(SMGState pInitialState, CFAEdge pInitialEdge, SMGPrecision precision) throws CPAException, InterruptedException {
        SMGState oldState = pInitialState;
        return this.postOperator.getStrongestPost(Collections.singleton(oldState), precision, pInitialEdge);
    }

    private boolean isOnlyVariableRenamingEdge(CFAEdge cfaEdge) {
        return cfaEdge != null && cfaEdge.getEdgeType() == CFAEdgeType.FunctionReturnEdge;
    }

    public boolean isRemainingPathFeasible(ARGPath remainingErrorPath, UnmodifiableSMGState state, CFAEdge pCurrentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        ++this.numberOfInterpolationQueries;
        return this.checker.isRemainingPathFeasible(remainingErrorPath, state, pCurrentEdge, pAllTargets);
    }

    public int getNumberOfInterpolationQueries() {
        return this.numberOfInterpolationQueries;
    }

    public static class SMGHeapAbstractionInterpoaltionResult {
        private static final SMGHeapAbstractionInterpoaltionResult EMPTY_AND_UNCHANGED = new SMGHeapAbstractionInterpoaltionResult((Set<SMGAbstractionBlock>)ImmutableSet.of(), false);
        private final Set<SMGAbstractionBlock> blocks;
        private final boolean change;

        public SMGHeapAbstractionInterpoaltionResult(Set<SMGAbstractionBlock> pBlocks, boolean pChange) {
            this.blocks = pBlocks;
            this.change = pChange;
        }

        public Set<SMGAbstractionBlock> getBlocks() {
            return this.blocks;
        }

        public boolean isChanged() {
            return this.change;
        }

        public String toString() {
            return "SMGHeapAbstractionInterpoaltionResult [blocks=" + this.blocks + ", change=" + this.change + "]";
        }

        public static SMGHeapAbstractionInterpoaltionResult emptyAndUnchanged() {
            return EMPTY_AND_UNCHANGED;
        }
    }
}

