/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.core.interfaces.AbstractState;
import org.sosy_lab.cpachecker.core.interfaces.Precision;
import org.sosy_lab.cpachecker.core.interfaces.StateSpacePartition;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.cpa.arg.path.ARGPath;
import org.sosy_lab.cpachecker.cpa.arg.path.PathIterator;
import org.sosy_lab.cpachecker.cpa.arg.path.PathPosition;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonState;
import org.sosy_lab.cpachecker.cpa.automaton.AutomatonTransferRelation;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGPrecision;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGStrongestPostOperator;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.AbstractStates;
import org.sosy_lab.cpachecker.util.refinement.FeasibilityChecker;

public class SMGFeasibilityChecker
implements FeasibilityChecker<UnmodifiableSMGState> {
    private final LogManager logger;
    private final SMGStrongestPostOperator strongestPostOp;
    private final UnmodifiableSMGState initialState;
    private final SMGPrecision precision;
    private final CFANode mainFunction;
    private final Set<ControlAutomatonCPA> automatonCPA;

    public SMGFeasibilityChecker(SMGStrongestPostOperator pStrongestPostOp, LogManager pLogger, CFA pCfa, UnmodifiableSMGState pInitialState, Set<ControlAutomatonCPA> pAutomatonCPA) {
        this.strongestPostOp = pStrongestPostOp;
        this.initialState = pInitialState;
        this.logger = pLogger;
        this.precision = SMGPrecision.createStaticPrecision(false);
        this.mainFunction = pCfa.getMainFunction();
        this.automatonCPA = pAutomatonCPA;
    }

    private ReachabilityResult isReachable(ARGPath pPath, UnmodifiableSMGState pStartingPoint, SMGPrecision pPrecision) throws CPAException, InterruptedException {
        SMGState start = pStartingPoint.copyOf();
        ArrayList<SMGState> next = new ArrayList<SMGState>();
        next.add(start);
        try {
            CFAEdge edge = null;
            PathIterator iterator = pPath.pathIterator();
            while (iterator.hasNext()) {
                edge = iterator.getOutgoingEdge();
                Collection<SMGState> successors = this.strongestPostOp.getStrongestPost(next, pPrecision, edge);
                if (successors.isEmpty()) {
                    this.logger.log(Level.FINE, new Object[]{"found path to be infeasible: ", iterator.getOutgoingEdge(), " did not yield a successor"});
                    return ReachabilityResult.isNotReachable(iterator.getPosition());
                }
                iterator.advance();
                next.clear();
                next.addAll(successors);
            }
            return ReachabilityResult.isReachable(next, edge, iterator.getPosition());
        }
        catch (CPATransferException e) {
            throw new CPAException("Computation of successor failed for checking path: " + e.getMessage(), e);
        }
    }

    private boolean isTarget(Collection<SMGState> pLastStates, CFAEdge pLastEdge, ARGState pLastState, boolean allTargets) throws CPATransferException, InterruptedException {
        Set<ControlAutomatonCPA> automatonCPAsToCheck = this.getAutomata(pLastState, allTargets);
        for (SMGState lastState : pLastStates) {
            lastState.pruneUnreachable();
            for (ControlAutomatonCPA automaton : automatonCPAsToCheck) {
                boolean isTarget = this.isTarget(lastState, pLastEdge, automaton);
                if (allTargets && isTarget) {
                    return true;
                }
                if (allTargets || isTarget) continue;
                return false;
            }
        }
        return !allTargets;
    }

    private Set<ControlAutomatonCPA> getAutomata(ARGState pLastState, boolean allTargets) {
        if (allTargets) {
            return this.automatonCPA;
        }
        ImmutableSet automatonNames = AbstractStates.asIterable(pLastState).filter(AutomatonState.class).filter(AutomatonState::isTarget).transform(AutomatonState::getOwningAutomatonName).toSet();
        return FluentIterable.from(this.automatonCPA).filter(arg_0 -> SMGFeasibilityChecker.lambda$getAutomata$0((Set)automatonNames, arg_0)).toSet();
    }

    private boolean isTarget(UnmodifiableSMGState pLastState, CFAEdge pLastEdge, ControlAutomatonCPA pAutomaton) throws CPATransferException, InterruptedException {
        if (pAutomaton == null) {
            return true;
        }
        StateSpacePartition defaultPartition = StateSpacePartition.getDefaultPartition();
        AbstractState initialAutomatonState = pAutomaton.getInitialState(this.mainFunction, defaultPartition);
        AutomatonTransferRelation transferRelation = pAutomaton.getTransferRelation();
        Precision automatonPrecision = pAutomaton.getInitialPrecision(this.mainFunction, defaultPartition);
        Collection<? extends AbstractState> successors = transferRelation.getAbstractSuccessorsForEdge(initialAutomatonState, automatonPrecision, pLastEdge);
        HashSet<? extends AbstractState> strengthenResult = new HashSet<AbstractState>();
        List<AbstractState> lastStateSingelton = Collections.singletonList(pLastState);
        for (AbstractState abstractState : successors) {
            strengthenResult.addAll(transferRelation.strengthen(abstractState, lastStateSingelton, pLastEdge, automatonPrecision));
        }
        return Iterables.any(strengthenResult, AbstractStates::isTargetState);
    }

    @Override
    public boolean isFeasible(ARGPath pPath) throws CPAException, InterruptedException {
        return this.isFeasible(pPath, this.initialState);
    }

    @Override
    public boolean isFeasible(ARGPath pPath, UnmodifiableSMGState pStartingPoint) throws CPAException, InterruptedException {
        return this.isFeasible(pPath, pStartingPoint, this.precision, false);
    }

    @Override
    boolean isFeasible(ARGPath pErrorPath, boolean pAllTargets) throws CPAException, InterruptedException {
        return this.isFeasible(pErrorPath, this.initialState, this.precision, pAllTargets);
    }

    private boolean isFeasible(ARGPath pPath, UnmodifiableSMGState pStartingPoint, SMGPrecision pPrecision, boolean pAllTargets) throws CPAException, InterruptedException {
        Preconditions.checkArgument((!pPath.getInnerEdges().isEmpty() ? 1 : 0) != 0);
        ReachabilityResult result = this.isReachable(pPath, pStartingPoint, pPrecision);
        if (result.isReachable()) {
            return this.isTarget(result.getLastState(), result.getLastEdge(), pPath.getLastState(), pAllTargets);
        }
        return false;
    }

    public boolean isRemainingPathFeasible(ARGPath pRemainingErrorPath, UnmodifiableSMGState pState, CFAEdge pCurrentEdge, boolean pAllTargets) throws CPAException, InterruptedException {
        if (pRemainingErrorPath.size() > 1) {
            return this.isFeasible(pRemainingErrorPath, pState);
        }
        SMGState state = pState.copyOf();
        return this.isTarget((Collection<SMGState>)ImmutableSet.of((Object)state), pCurrentEdge, pRemainingErrorPath.getLastState(), pAllTargets);
    }

    @Override
    public boolean isFeasible(ARGPath pPath, UnmodifiableSMGState pStartingPoint, Deque<UnmodifiableSMGState> pCallstack) throws CPAException, InterruptedException {
        throw new UnsupportedOperationException("method not yet implemented");
    }

    private static /* synthetic */ boolean lambda$getAutomata$0(Set automatonNames, ControlAutomatonCPA cpa) {
        return automatonNames.contains(cpa.getTopState().getOwningAutomatonName());
    }

    private static class ReachabilityResult {
        private final boolean isReachable;
        private final Collection<SMGState> lastStates;
        private final CFAEdge lastEdge;
        private final PathPosition lastPosition;

        private ReachabilityResult(Collection<SMGState> pLastStates, CFAEdge pLastEdge, PathPosition pLastPosition) {
            Preconditions.checkNotNull((Object)pLastEdge);
            Preconditions.checkNotNull(pLastStates);
            this.isReachable = true;
            this.lastStates = pLastStates;
            this.lastEdge = pLastEdge;
            this.lastPosition = pLastPosition;
        }

        public ReachabilityResult(PathPosition pLastPosition) {
            this.isReachable = false;
            this.lastStates = null;
            this.lastEdge = null;
            this.lastPosition = pLastPosition;
        }

        public boolean isReachable() {
            return this.isReachable;
        }

        public Collection<SMGState> getLastState() {
            assert (this.isReachable) : "Getting the last state of the path is only supported if the last state is reachable.";
            return this.lastStates;
        }

        public CFAEdge getLastEdge() {
            assert (this.isReachable) : "Getting the last edge of the path is only supported if the last state is reachable.";
            return this.lastEdge;
        }

        public PathPosition getLastPosition() {
            return this.lastPosition;
        }

        public static ReachabilityResult isReachable(Collection<SMGState> lastStates, CFAEdge lastEdge, PathPosition pLastPosition) {
            return new ReachabilityResult(lastStates, lastEdge, pLastPosition);
        }

        public static ReachabilityResult isNotReachable(PathPosition pLastPosition) {
            return new ReachabilityResult(pLastPosition);
        }
    }
}

