/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.base.Preconditions;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGIntersectStates;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPath;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGMemoryPathCollector;
import org.sosy_lab.cpachecker.util.refinement.Interpolant;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public class SMGInterpolant
implements Interpolant<Collection<SMGState>, SMGInterpolant> {
    private static final SMGInterpolant FALSE = new SMGInterpolant();
    private final ImmutableSet<SMGAbstractionBlock> abstractionBlock;
    private final ImmutableSet<SMGMemoryPath> trackedMemoryPaths;
    private final ImmutableSet<MemoryLocation> trackedStackVariables;
    private final ImmutableSet<UnmodifiableSMGState> smgStates;

    private SMGInterpolant() {
        this.abstractionBlock = ImmutableSet.of();
        this.trackedMemoryPaths = ImmutableSet.of();
        this.trackedStackVariables = ImmutableSet.of();
        this.smgStates = ImmutableSet.of();
    }

    public SMGInterpolant(Collection<? extends UnmodifiableSMGState> pStates) {
        this(pStates, (Collection<SMGAbstractionBlock>)ImmutableSet.of());
    }

    public SMGInterpolant(Collection<? extends UnmodifiableSMGState> pStates, Collection<SMGAbstractionBlock> pAbstractionBlock) {
        this.smgStates = ImmutableSet.copyOf(pStates);
        this.abstractionBlock = ImmutableSet.copyOf(pAbstractionBlock);
        ImmutableSet.Builder memoryPaths = ImmutableSet.builder();
        ImmutableSet.Builder stackVariables = ImmutableSet.builder();
        for (UnmodifiableSMGState state : this.smgStates) {
            memoryPaths.addAll(new SMGMemoryPathCollector(state.getHeap()).getMemoryPaths());
            stackVariables.addAll(state.getStackVariables().keySet());
        }
        this.trackedMemoryPaths = memoryPaths.build();
        this.trackedStackVariables = stackVariables.build();
    }

    @Override
    public Set<SMGState> reconstructState() {
        if (this.isFalse()) {
            throw new IllegalStateException("Can't reconstruct state from FALSE-interpolant");
        }
        return new HashSet<SMGState>(Collections2.transform(this.smgStates, s -> s.copyOf()));
    }

    @Override
    public Set<MemoryLocation> getMemoryLocations() {
        return this.trackedStackVariables;
    }

    Set<SMGMemoryPath> getMemoryPaths() {
        return this.trackedMemoryPaths;
    }

    @Override
    public boolean isTrue() {
        return !this.isFalse() && this.trackedMemoryPaths.isEmpty() && this.trackedStackVariables.isEmpty();
    }

    @Override
    public boolean isFalse() {
        return this == FALSE;
    }

    @Override
    public boolean isTrivial() {
        return this.isTrue() || this.isFalse();
    }

    @Override
    public SMGInterpolant join(SMGInterpolant pOtherInterpolant) {
        if (this.isFalse() || pOtherInterpolant.isFalse()) {
            return FALSE;
        }
        HashSet<UnmodifiableSMGState> joinResult = new HashSet<UnmodifiableSMGState>();
        HashSet<UnmodifiableSMGState> originalStatesNotJoint = new HashSet<UnmodifiableSMGState>((Collection<UnmodifiableSMGState>)this.smgStates);
        for (UnmodifiableSMGState otherState : pOtherInterpolant.smgStates) {
            UnmodifiableSMGState state;
            SMGIntersectStates.SMGIntersectionResult result = SMGIntersectStates.SMGIntersectionResult.getNotDefinedInstance();
            Iterator iterator = originalStatesNotJoint.iterator();
            while (iterator.hasNext() && !(result = new SMGIntersectStates(state = (UnmodifiableSMGState)iterator.next(), otherState).intersect()).isDefined()) {
            }
            if (result.isDefined()) {
                originalStatesNotJoint.remove(result.getSmg1());
                joinResult.add(result.getCombinationResult());
                continue;
            }
            joinResult.add(otherState);
        }
        joinResult.addAll(originalStatesNotJoint);
        Sets.SetView jointAbstractionBlock = Sets.union(this.abstractionBlock, pOtherInterpolant.abstractionBlock);
        return new SMGInterpolant(joinResult, (Collection<SMGAbstractionBlock>)jointAbstractionBlock);
    }

    public static SMGInterpolant createInitial(LogManager logger, MachineModel model, FunctionEntryNode pMainFunctionNode, SMGOptions options) throws SMGInconsistentException {
        SMGState initState = new SMGState(logger, model, options);
        CFunctionEntryNode functionNode = (CFunctionEntryNode)pMainFunctionNode;
        initState.addStackFrame(functionNode.getFunctionDefinition());
        return new SMGInterpolant((Collection<? extends UnmodifiableSMGState>)ImmutableSet.of((Object)initState));
    }

    public static SMGInterpolant getFalseInterpolant() {
        return FALSE;
    }

    public String toString() {
        if (this.isFalse()) {
            return "FALSE";
        }
        return "Tracked memory paths: " + this.trackedMemoryPaths + "\nAbstraction blocks: " + this.abstractionBlock + "\nTracked stack variables: " + this.trackedStackVariables + "\nBasic SMG states: " + Collections2.transform(this.smgStates, UnmodifiableSMGState::getId);
    }

    public static SMGInterpolant getTrueInterpolant(SMGInterpolant template) {
        Preconditions.checkArgument((!template.isFalse() ? 1 : 0) != 0, (Object)"Can't create true interpolant from a false interpolant template.");
        UnmodifiableSMGState templateState = (UnmodifiableSMGState)template.smgStates.iterator().next();
        SMGState newState = templateState.copyOf();
        newState.clearValues();
        newState.clearObjects();
        return new SMGInterpolant((Collection<? extends UnmodifiableSMGState>)ImmutableSet.of((Object)newState));
    }

    public SMGPrecisionIncrement getPrecisionIncrement() {
        return new SMGPrecisionIncrement((Collection<SMGMemoryPath>)this.trackedMemoryPaths, (Collection<SMGAbstractionBlock>)this.abstractionBlock, (Collection<MemoryLocation>)this.trackedStackVariables);
    }

    @Override
    public int getSize() {
        return this.trackedStackVariables.size();
    }

    public static class SMGPrecisionIncrement {
        private final ImmutableSet<SMGMemoryPath> pathsToTrack;
        private final ImmutableSet<SMGAbstractionBlock> abstractionBlock;
        private final ImmutableSet<MemoryLocation> stackVariablesToTrack;

        private SMGPrecisionIncrement(Collection<SMGMemoryPath> pPathsToTrack, Collection<SMGAbstractionBlock> pAbstractionBlock, Collection<MemoryLocation> pStackVariablesToTrack) {
            this.pathsToTrack = ImmutableSet.copyOf(pPathsToTrack);
            this.abstractionBlock = ImmutableSet.copyOf(pAbstractionBlock);
            this.stackVariablesToTrack = ImmutableSet.copyOf(pStackVariablesToTrack);
        }

        public Set<SMGMemoryPath> getPathsToTrack() {
            return this.pathsToTrack;
        }

        public Set<SMGAbstractionBlock> getAbstractionBlock() {
            return this.abstractionBlock;
        }

        public Set<MemoryLocation> getStackVariablesToTrack() {
            return this.stackVariablesToTrack;
        }

        public int hashCode() {
            return Objects.hash(this.abstractionBlock, this.pathsToTrack, this.stackVariablesToTrack);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof SMGPrecisionIncrement)) {
                return false;
            }
            SMGPrecisionIncrement other = (SMGPrecisionIncrement)obj;
            return Objects.equals(this.abstractionBlock, other.abstractionBlock) && Objects.equals(this.pathsToTrack, other.pathsToTrack) && Objects.equals(this.stackVariablesToTrack, other.stackVariablesToTrack);
        }

        public String toString() {
            return "SMGPrecisionIncrement [pathsToTrack=" + this.pathsToTrack + ", abstractionBlock=" + this.abstractionBlock + ", stackVariablesToTrack=" + this.stackVariablesToTrack + "]";
        }

        public SMGPrecisionIncrement join(SMGPrecisionIncrement pInc2) {
            return new SMGPrecisionIncrement((Collection<SMGMemoryPath>)Sets.union(this.pathsToTrack, pInc2.pathsToTrack), (Collection<SMGAbstractionBlock>)Sets.union(this.abstractionBlock, pInc2.abstractionBlock), (Collection<MemoryLocation>)Sets.union(this.stackVariablesToTrack, pInc2.stackVariablesToTrack));
        }
    }
}

