/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.cpa.smg.refiner;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cpa.smg.SMGAbstractionBlock;
import org.sosy_lab.cpachecker.cpa.smg.SMGInconsistentException;
import org.sosy_lab.cpachecker.cpa.smg.SMGOptions;
import org.sosy_lab.cpachecker.cpa.smg.SMGState;
import org.sosy_lab.cpachecker.cpa.smg.UnmodifiableSMGState;
import org.sosy_lab.cpachecker.cpa.smg.refiner.SMGInterpolant;
import org.sosy_lab.cpachecker.util.refinement.InterpolantManager;

public class SMGInterpolantManager
implements InterpolantManager<Collection<SMGState>, SMGInterpolant> {
    private final SMGInterpolant initalInterpolant;

    public SMGInterpolantManager(LogManager pLogger, CFA pCfa, SMGOptions options) throws SMGInconsistentException {
        this.initalInterpolant = SMGInterpolant.createInitial(pLogger, pCfa.getMachineModel(), pCfa.getMainFunction(), options);
    }

    @Override
    public SMGInterpolant createInitialInterpolant() {
        return this.initalInterpolant;
    }

    @Override
    public SMGInterpolant createInterpolant(Collection<SMGState> pStates) {
        return new SMGInterpolant(pStates);
    }

    @Override
    public SMGInterpolant getTrueInterpolant() {
        return new SMGInterpolant((Collection<? extends UnmodifiableSMGState>)ImmutableSet.of());
    }

    @Override
    public SMGInterpolant getFalseInterpolant() {
        return SMGInterpolant.getFalseInterpolant();
    }

    public SMGInterpolant createInterpolant(UnmodifiableSMGState pState, Set<SMGAbstractionBlock> pAbstractionBlocks) {
        return new SMGInterpolant((Collection<? extends UnmodifiableSMGState>)ImmutableSet.of((Object)pState), pAbstractionBlocks);
    }
}

